/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.script;

import com.dtolabs.rundeck.core.common.Framework;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class ScriptfileUtils {
    private static void writeStream(InputStream input, FileWriter writer) throws IOException {
        String inData;
        InputStreamReader inStream = new InputStreamReader(input);
        BufferedReader inbuff = new BufferedReader(inStream);
        String linesep = System.getProperty("line.separator");
        while ((inData = inbuff.readLine()) != null) {
            writer.write(inData);
            writer.write(linesep);
        }
        inbuff.close();
    }

    private static void writeReader(Reader reader, FileWriter writer) throws IOException {
        String inData;
        BufferedReader inbuff = new BufferedReader(reader);
        String linesep = System.getProperty("line.separator");
        while ((inData = inbuff.readLine()) != null) {
            writer.write(inData);
            writer.write(linesep);
        }
        inbuff.close();
    }

    public static File writeScriptTempfile(Framework framework, File sourcefile) throws IOException {
        return ScriptfileUtils.writeScriptTempfile(framework, new FileInputStream(sourcefile), null, null);
    }

    public static File writeScriptTempfile(Framework framework, InputStream stream) throws IOException {
        return ScriptfileUtils.writeScriptTempfile(framework, stream, null, null);
    }

    public static File writeScriptTempfile(Framework framework, String source) throws IOException {
        return ScriptfileUtils.writeScriptTempfile(framework, null, source, null);
    }

    public static File writeScriptTempfile(Framework framework, Reader source) throws IOException {
        return ScriptfileUtils.writeScriptTempfile(framework, null, null, source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File writeScriptTempfile(Framework framework, InputStream stream, String source, Reader reader) throws IOException {
        File scriptfile = ScriptfileUtils.createTempFile(framework);
        FileWriter writer = new FileWriter(scriptfile);
        try {
            if (null != source) {
                writer.write(source);
            } else if (null != reader) {
                ScriptfileUtils.writeReader(reader, writer);
            } else if (null != stream) {
                ScriptfileUtils.writeStream(stream, writer);
            }
        }
        finally {
            writer.close();
        }
        return scriptfile;
    }

    public static File createTempFile(Framework framework) throws IOException {
        File dispatch = File.createTempFile("dispatch", ".tmp", new File(framework.getProperty("framework.tmp.dir")));
        dispatch.deleteOnExit();
        return dispatch;
    }

    public static void setExecutePermissions(File scriptfile) throws IOException {
        if (!System.getProperty("os.name").toLowerCase().contains("windows")) {
            Process process = Runtime.getRuntime().exec(new String[]{"chmod", "+x", scriptfile.getAbsolutePath()});
            int result = -1;
            try {
                result = process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (result > 0) {
                throw new IOException("exec returned: " + result);
            }
        }
    }
}

