/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.service;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.dispatcher.DataContextUtils;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.impl.common.BaseFileCopier;
import com.dtolabs.rundeck.core.execution.service.FileCopier;
import com.dtolabs.rundeck.core.execution.service.FileCopierException;
import com.dtolabs.rundeck.core.plugins.AbstractDescribableScriptPlugin;
import com.dtolabs.rundeck.core.plugins.PluginException;
import com.dtolabs.rundeck.core.plugins.ScriptDataContextUtil;
import com.dtolabs.rundeck.core.plugins.ScriptPluginProvider;
import com.dtolabs.rundeck.core.utils.StringArrayUtil;
import com.dtolabs.utils.Streams;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

class ScriptPluginFileCopier
extends AbstractDescribableScriptPlugin
implements FileCopier {
    public boolean isAllowCustomProperties() {
        return false;
    }

    ScriptPluginFileCopier(ScriptPluginProvider provider, Framework framework) {
        super(provider, framework);
    }

    static void validateScriptPlugin(ScriptPluginProvider plugin) throws PluginException {
        if (null == plugin.getScriptArgs()) {
            throw new PluginException("no script-args defined for provider: " + plugin);
        }
    }

    public String copyFileStream(ExecutionContext executionContext, InputStream inputStream, INodeEntry node) throws FileCopierException {
        return this.copyFile(executionContext, null, inputStream, null, node);
    }

    public String copyFile(ExecutionContext executionContext, File file, INodeEntry node) throws FileCopierException {
        return this.copyFile(executionContext, file, null, null, node);
    }

    public String copyScriptContent(ExecutionContext executionContext, String s, INodeEntry node) throws FileCopierException {
        return this.copyFile(executionContext, null, null, s, node);
    }

    String copyFile(ExecutionContext executionContext, File file, InputStream input, String content, INodeEntry node) throws FileCopierException {
        File workingdir = null;
        String scriptargs = null;
        Object dirstring = null;
        ScriptPluginProvider plugin = this.getProvider();
        String pluginname = plugin.getName();
        File scriptfile = plugin.getScriptFile();
        scriptargs = plugin.getScriptArgs();
        String scriptinterpreter = plugin.getScriptInterpreter();
        boolean interpreterargsquoted = plugin.getInterpreterArgsQuoted();
        if (null == scriptargs) {
            throw new FileCopierException("[" + pluginname + " file copier] no script-args defined for plugin");
        }
        Map<String, Map<String, String>> localDataContext = ScriptDataContextUtil.createScriptDataContextForProject(executionContext.getFramework(), executionContext.getFrameworkProject());
        localDataContext.get("plugin").putAll(this.createPluginDataContext());
        localDataContext.putAll(executionContext.getDataContext());
        localDataContext.put("node", DataContextUtils.nodeData(node));
        File tempfile = BaseFileCopier.writeScriptTempFile(executionContext, file, input, content, node);
        HashMap<String, String> scptexec = new HashMap<String, String>();
        scptexec.put("file", tempfile.getAbsolutePath());
        localDataContext.put("file-copy", scptexec);
        ArrayList<String> arglist = new ArrayList<String>();
        if (null != scriptinterpreter) {
            arglist.addAll(Arrays.asList(scriptinterpreter.split(" ")));
        }
        if (null != scriptinterpreter && interpreterargsquoted) {
            StringBuilder sbuf = new StringBuilder(scriptfile.getAbsolutePath());
            if (null != scriptargs) {
                sbuf.append(" ");
                sbuf.append(DataContextUtils.replaceDataReferences(scriptargs, localDataContext));
            }
            arglist.add(sbuf.toString());
        } else {
            arglist.add(scriptfile.getAbsolutePath());
            if (null != scriptargs) {
                arglist.addAll(Arrays.asList(DataContextUtils.replaceDataReferences(scriptargs.split(" "), localDataContext)));
            }
        }
        String[] finalargs = arglist.toArray(new String[arglist.size()]);
        Map<String, String> envMap = DataContextUtils.generateEnvVarsFromContext(localDataContext);
        ArrayList<String> envlist = new ArrayList<String>();
        for (Map.Entry<String, String> entry : envMap.entrySet()) {
            envlist.add(entry.getKey() + "=" + entry.getValue());
        }
        String[] envarr = envlist.toArray(new String[envlist.size()]);
        int result = -1;
        boolean success = false;
        Streams.StreamCopyThread errthread = null;
        Streams.StreamCopyThread outthread = null;
        executionContext.getExecutionListener().log(3, "[" + pluginname + "] executing: " + StringArrayUtil.asString(finalargs, " "));
        Runtime runtime = Runtime.getRuntime();
        Process exec = null;
        try {
            exec = runtime.exec(finalargs, envarr, workingdir);
        }
        catch (IOException e) {
            throw new FileCopierException(e);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            errthread = Streams.copyStreamThread(exec.getErrorStream(), System.err);
            outthread = Streams.copyStreamThread(exec.getInputStream(), byteArrayOutputStream);
            errthread.start();
            outthread.start();
            exec.getOutputStream().close();
            result = exec.waitFor();
            errthread.join();
            outthread.join();
            success = 0 == result;
        }
        catch (InterruptedException e) {
            throw new FileCopierException(e);
        }
        catch (IOException e) {
            throw new FileCopierException(e);
        }
        if (!success) {
            throw new FileCopierException("[" + pluginname + "]: external script failed with exit code: " + result);
        }
        String output = byteArrayOutputStream.toString();
        if (null == output || output.length() < 1) {
            throw new FileCopierException("[" + pluginname + "]: No output from external script");
        }
        String[] split1 = output.split("(\\r?\\n)");
        if (split1.length < 1) {
            throw new FileCopierException("[" + pluginname + "]: No output from external script");
        }
        String remotefilepath = split1[0];
        executionContext.getExecutionListener().log(3, "[" + pluginname + "]: result filepath: " + remotefilepath);
        return remotefilepath;
    }
}

