/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.service;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.dispatcher.DataContextUtils;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.ExecutionException;
import com.dtolabs.rundeck.core.execution.service.NodeExecutor;
import com.dtolabs.rundeck.core.execution.service.NodeExecutorResult;
import com.dtolabs.rundeck.core.plugins.AbstractDescribableScriptPlugin;
import com.dtolabs.rundeck.core.plugins.PluginException;
import com.dtolabs.rundeck.core.plugins.ScriptDataContextUtil;
import com.dtolabs.rundeck.core.plugins.ScriptPluginProvider;
import com.dtolabs.rundeck.core.utils.StringArrayUtil;
import com.dtolabs.utils.Streams;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

class ScriptPluginNodeExecutor
extends AbstractDescribableScriptPlugin
implements NodeExecutor {
    ScriptPluginNodeExecutor(ScriptPluginProvider provider, Framework framework) {
        super(provider, framework);
    }

    public boolean isAllowCustomProperties() {
        return false;
    }

    static void validateScriptPlugin(ScriptPluginProvider plugin) throws PluginException {
    }

    public NodeExecutorResult executeCommand(ExecutionContext executionContext, String[] command, INodeEntry node) throws ExecutionException {
        Process exec;
        File workingdir = null;
        ScriptPluginProvider plugin = this.getProvider();
        File scriptfile = plugin.getScriptFile();
        final String pluginname = plugin.getName();
        executionContext.getExecutionListener().log(3, "[" + pluginname + "] execCommand started, command: " + StringArrayUtil.asString(command, " "));
        String scriptargs = plugin.getScriptArgs();
        String scriptinterpreter = plugin.getScriptInterpreter();
        boolean interpreterargsquoted = plugin.getInterpreterArgsQuoted();
        executionContext.getExecutionListener().log(3, "[" + pluginname + "] scriptargs: " + scriptargs + ", interpreter: " + scriptinterpreter);
        Map<String, Map<String, String>> localDataContext = ScriptDataContextUtil.createScriptDataContextForProject(executionContext.getFramework(), executionContext.getFrameworkProject());
        localDataContext.get("plugin").putAll(this.createPluginDataContext());
        localDataContext.putAll(executionContext.getDataContext());
        HashMap<String, String> scptexec = new HashMap<String, String>();
        scptexec.put("command", StringArrayUtil.asString(command, " "));
        localDataContext.put("exec", scptexec);
        ArrayList<String> arglist = new ArrayList<String>();
        if (null != scriptinterpreter) {
            arglist.addAll(Arrays.asList(scriptinterpreter.split(" ")));
        }
        if (null != scriptinterpreter && interpreterargsquoted) {
            StringBuilder sbuf = new StringBuilder(scriptfile.getAbsolutePath());
            if (null != scriptargs) {
                sbuf.append(" ");
                sbuf.append(DataContextUtils.replaceDataReferences(scriptargs, localDataContext));
            }
            arglist.add(sbuf.toString());
        } else {
            arglist.add(scriptfile.getAbsolutePath());
            if (null != scriptargs) {
                arglist.addAll(Arrays.asList(DataContextUtils.replaceDataReferences(scriptargs.split(" "), localDataContext)));
            }
        }
        String[] finalargs = arglist.toArray(new String[arglist.size()]);
        Map<String, String> envMap = DataContextUtils.generateEnvVarsFromContext(localDataContext);
        ArrayList<String> envlist = new ArrayList<String>();
        for (Map.Entry<String, String> entry : envMap.entrySet()) {
            envlist.add(entry.getKey() + "=" + entry.getValue());
        }
        String[] envarr = envlist.toArray(new String[envlist.size()]);
        int result = -1;
        boolean success = false;
        executionContext.getExecutionListener().log(3, "[" + pluginname + "] executing: " + StringArrayUtil.asString(finalargs, " "));
        Runtime runtime = Runtime.getRuntime();
        try {
            exec = runtime.exec(finalargs, envarr, workingdir);
        }
        catch (IOException e) {
            throw new ExecutionException(e);
        }
        try {
            Streams.StreamCopyThread errthread = Streams.copyStreamThread(exec.getErrorStream(), System.err);
            Streams.StreamCopyThread outthread = Streams.copyStreamThread(exec.getInputStream(), System.out);
            errthread.start();
            outthread.start();
            exec.getOutputStream().close();
            result = exec.waitFor();
            errthread.join();
            outthread.join();
            success = 0 == result;
        }
        catch (InterruptedException e) {
            e.printStackTrace(System.err);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
        executionContext.getExecutionListener().log(3, "[" + pluginname + "]: result code: " + result + ", success: " + success);
        final int returnresult = result;
        final boolean returnsuccess = success;
        return new NodeExecutorResult(){

            public int getResultCode() {
                return returnresult;
            }

            public boolean isSuccess() {
                return returnsuccess;
            }

            public String toString() {
                return "[" + pluginname + "] success: " + this.isSuccess() + ", result code: " + this.getResultCode();
            }
        };
    }
}

