/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.utils;

import com.dtolabs.rundeck.core.execution.utils.Responder;
import com.dtolabs.rundeck.core.utils.PartialLineBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResponderTask
implements Callable<ResponderResult> {
    static Logger logger = Logger.getLogger((String)ResponderTask.class.getName());
    private Responder responder;
    private OutputStream outputStream;
    private InputStreamReader reader;
    private boolean success;
    private boolean failed;
    private String failureReason;
    private ResultHandler resultHandler;
    private PartialLineBuffer partialLineBuffer;
    static String[] STEP_DESCS = new String[]{"waiting for input prompt", "writing response", "waiting for response"};

    public ResponderTask(Responder responder, InputStream inputStream, OutputStream outputStream, ResultHandler resultHandler) {
        this(responder, new InputStreamReader(inputStream), outputStream, resultHandler, new PartialLineBuffer());
    }

    private ResponderTask(Responder responder, InputStreamReader reader, OutputStream outputStream, ResultHandler resultHandler, PartialLineBuffer buffer) {
        this.responder = responder;
        this.outputStream = outputStream;
        this.reader = reader;
        this.resultHandler = resultHandler;
        this.partialLineBuffer = buffer;
    }

    @Override
    public ResponderResult call() throws Exception {
        logger.debug((Object)"started responder thread");
        this.runResponder();
        if (null != this.resultHandler && !Thread.currentThread().isInterrupted()) {
            this.resultHandler.handleResult(this.success, this.failureReason);
        }
        return new ResponderResult(this.responder, this.failureReason, this.success, Thread.interrupted());
    }

    private void runResponder() {
        int step = 0;
        try {
            block16: {
                block15: {
                    if (null != this.responder.getInputSuccessPattern() || null != this.responder.getInputFailurePattern()) {
                        logger.debug((Object)("Awaiting input: " + this.responder.getInputSuccessPattern() + ";" + this.responder.getInputFailurePattern()));
                        try {
                            boolean detected = ResponderTask.detect(this.responder.getInputSuccessPattern(), this.responder.getInputFailurePattern(), this.responder.getInputMaxTimeout(), this.responder.getInputMaxLines(), this.reader, this.partialLineBuffer);
                            logger.debug((Object)("Success detected? " + detected));
                            if (Thread.currentThread().isInterrupted()) {
                                logger.debug((Object)"interrupted");
                                return;
                            }
                            if (!detected) {
                                this.fail(step, "Expected input was not seen");
                                return;
                            }
                        }
                        catch (ThreshholdException e) {
                            if (this.responder.isFailOnInputLinesThreshold() && e.getType() == ThresholdType.lines) {
                                logger.debug((Object)("Threshold met " + this.reason(e)));
                                this.fail(step, this.reason(e));
                                return;
                            }
                            if (this.responder.isFailOnInputTimeoutThreshold() && e.getType() == ThresholdType.milliseconds) {
                                logger.debug((Object)("Threshold met " + this.reason(e)));
                                this.fail(step, this.reason(e));
                                return;
                            }
                            if (!this.responder.isSuccessOnInputThreshold()) break block15;
                            this.success = true;
                            return;
                        }
                    }
                }
                ++step;
                if (null != this.responder.getInputString()) {
                    logger.debug((Object)"Writing to output");
                    this.outputStream.write(this.responder.getInputString().getBytes());
                    logger.debug((Object)"Wrote to output");
                }
                ++step;
                if (null != this.responder.getResponseSuccessPattern() || null != this.responder.getResponseFailurePattern()) {
                    boolean succeeded = false;
                    try {
                        logger.debug((Object)("Awaiting response: " + this.responder.getResponseSuccessPattern() + ", " + this.responder.getResponseFailurePattern()));
                        succeeded = ResponderTask.detect(this.responder.getResponseSuccessPattern(), this.responder.getResponseFailurePattern(), this.responder.getResponseMaxTimeout(), this.responder.getResponseMaxLines(), this.reader, this.partialLineBuffer);
                        if (Thread.currentThread().isInterrupted()) {
                            logger.debug((Object)"interrupted");
                            return;
                        }
                        this.success = succeeded;
                        if (!succeeded) {
                            this.fail(step, "Did not see the correct response");
                        }
                        logger.debug((Object)("Success detected? " + succeeded));
                        return;
                    }
                    catch (ThreshholdException e) {
                        if (!this.responder.isFailOnResponseThreshold()) break block16;
                        logger.debug((Object)("Threshold met " + this.reason(e)));
                        this.fail(step, this.reason(e));
                        return;
                    }
                }
            }
            this.success = true;
        }
        catch (IOException e) {
            logger.debug((Object)("IOException " + e.getMessage()), (Throwable)e);
            this.fail(step, e.getMessage());
            e.printStackTrace();
        }
    }

    private void fail(int step, String reason) {
        this.success = false;
        this.failed = true;
        this.failureReason = "Failed " + (step < STEP_DESCS.length ? STEP_DESCS[step] : "?") + ": " + reason;
    }

    private String reason(ThreshholdException e) {
        return "Expected input was not seen in " + e.getValue() + " " + (Object)((Object)e.getType());
    }

    public boolean isFailed() {
        return this.failed;
    }

    private ResponderTask chainResponder(Responder responder, ResultHandler resultHandler) {
        return new ResponderTask(responder, this.reader, this.outputStream, resultHandler, this.partialLineBuffer);
    }

    public Callable<ResponderResult> createSequence(Responder responder) {
        return this.createSequence(responder, this.resultHandler);
    }

    public Callable<ResponderResult> createSequence(Responder responder, ResultHandler resultHandler) {
        return new Sequence<ResponderResult>(this, this.chainResponder(responder, resultHandler));
    }

    static boolean detect(String detectPattern, String failurePattern, long timeout, int maxLines, InputStreamReader reader, PartialLineBuffer buffer) throws IOException, ThreshholdException {
        if (null == detectPattern && null == failurePattern) {
            throw new IllegalArgumentException("detectPattern or failurePattern required");
        }
        long start = System.currentTimeMillis();
        int linecount = 0;
        Pattern success = null != detectPattern ? Pattern.compile(detectPattern) : null;
        Pattern failure = null != failurePattern ? Pattern.compile(failurePattern) : null;
        block2: while (System.currentTimeMillis() < start + timeout && linecount < maxLines && !Thread.currentThread().isInterrupted()) {
            String line = buffer.readLine();
            while (null != line) {
                logger.debug((Object)("read line: " + line));
                start = System.currentTimeMillis();
                ++linecount;
                if (null != success && success.matcher(line).matches()) {
                    logger.debug((Object)"success matched");
                    return true;
                }
                if (null != failure && failure.matcher(line).matches()) {
                    logger.debug((Object)"failure matched");
                    return false;
                }
                if (linecount >= maxLines) break block2;
                line = buffer.readLine();
            }
            line = buffer.getPartialLine();
            if (null != line) {
                logger.debug((Object)("read partial: " + line));
                if (null != success && success.matcher(line).matches()) {
                    logger.debug((Object)"success matched partial");
                    buffer.clearPartial();
                    return true;
                }
                if (null != failure && failure.matcher(line).matches()) {
                    logger.debug((Object)"failure matched partial");
                    buffer.clearPartial();
                    return false;
                }
            }
            if (!reader.ready()) {
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return false;
                }
            }
            int c = buffer.read(reader);
            if (c < 0) {
                logger.debug((Object)"end of input");
                continue;
            }
            if (c <= 0) continue;
            logger.debug((Object)("read " + c));
        }
        if (Thread.currentThread().isInterrupted()) {
            logger.debug((Object)"detect interrupted");
        }
        if (linecount >= maxLines) {
            logger.debug((Object)"max input lines");
            throw new ThreshholdException(maxLines, ThresholdType.lines);
        }
        if (System.currentTimeMillis() >= start + timeout) {
            logger.debug((Object)"max timeout");
            throw new ThreshholdException(timeout, ThresholdType.milliseconds);
        }
        return false;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public static final class ResponderResult
    implements SuccessResult {
        private String failureReason;
        private boolean success;
        private boolean interrupted;
        private Responder responder;

        ResponderResult(Responder responder, String failureReason, boolean success, boolean interrupted) {
            this.responder = responder;
            this.failureReason = failureReason;
            this.success = success;
            this.interrupted = interrupted;
        }

        public String getFailureReason() {
            return this.failureReason;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public boolean isInterrupted() {
            return this.interrupted;
        }

        public Responder getResponder() {
            return this.responder;
        }

        public String toString() {
            return "ResponderResult{failureReason='" + this.failureReason + '\'' + ", success=" + this.success + ", interrupted=" + this.interrupted + ", responder=" + this.responder + '}';
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Sequence<T extends SuccessResult>
    implements Callable<T> {
        private Callable<T> step1;
        private Callable<T> step2;

        public Sequence(Callable<T> step1, Callable<T> step2) {
            this.step1 = step1;
            this.step2 = step2;
        }

        @Override
        public T call() throws Exception {
            SuccessResult result1 = (SuccessResult)this.step1.call();
            if (result1.isSuccess() && !Thread.currentThread().isInterrupted()) {
                return (T)((SuccessResult)this.step2.call());
            }
            return (T)result1;
        }
    }

    public static interface SuccessResult {
        public boolean isSuccess();
    }

    static final class ThreshholdException
    extends Exception {
        private Object value;
        private ThresholdType type;

        ThreshholdException(Object value, ThresholdType type) {
            this.value = value;
            this.type = type;
        }

        ThreshholdException(String s, Object value, ThresholdType type) {
            super(s);
            this.value = value;
            this.type = type;
        }

        public Object getValue() {
            return this.value;
        }

        public ThresholdType getType() {
            return this.type;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ThresholdType {
        milliseconds,
        lines;

    }

    public static interface ResultHandler {
        public void handleResult(boolean var1, String var2);
    }
}

