/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.workflow;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.ExecutionItem;
import com.dtolabs.rundeck.core.execution.ExecutionListener;
import com.dtolabs.rundeck.core.execution.ExecutionResult;
import com.dtolabs.rundeck.core.execution.StatusResult;
import com.dtolabs.rundeck.core.execution.dispatch.DispatcherException;
import com.dtolabs.rundeck.core.execution.dispatch.DispatcherResult;
import com.dtolabs.rundeck.core.execution.workflow.StepFirstWorkflowStrategy;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionItem;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionListener;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowStepFailureException;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseWorkflowStrategy
implements WorkflowStrategy {
    final Framework framework;

    public BaseWorkflowStrategy(Framework framework) {
        this.framework = framework;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final WorkflowExecutionResult executeWorkflow(ExecutionContext executionContext, WorkflowExecutionItem item) {
        WorkflowExecutionListener wlistener = this.getWorkflowListener(executionContext);
        if (null != wlistener && !StepFirstWorkflowStrategy.isInnerLoop(item)) {
            wlistener.beginWorkflowExecution(executionContext, item);
        }
        WorkflowExecutionResult result = null;
        try {
            result = this.executeWorkflowImpl(executionContext, item);
        }
        finally {
            if (null != wlistener && !StepFirstWorkflowStrategy.isInnerLoop(item)) {
                wlistener.finishWorkflowExecution(result, executionContext, item);
            }
        }
        return result;
    }

    private WorkflowExecutionListener getWorkflowListener(ExecutionContext executionContext) {
        WorkflowExecutionListener wlistener = null;
        ExecutionListener elistener = executionContext.getExecutionListener();
        if (null != elistener && elistener instanceof WorkflowExecutionListener) {
            wlistener = (WorkflowExecutionListener)elistener;
        }
        return wlistener;
    }

    public abstract WorkflowExecutionResult executeWorkflowImpl(ExecutionContext var1, WorkflowExecutionItem var2);

    protected boolean executeWFItem(ExecutionContext executionContext, Map<Integer, Object> failedMap, List<DispatcherResult> resultList, int c, ExecutionItem cmd, boolean keepgoing) throws WorkflowStepFailureException {
        boolean itemsuccess;
        WorkflowExecutionListener wlistener = this.getWorkflowListener(executionContext);
        if (null != wlistener) {
            wlistener.beginWorkflowItem(c, cmd);
        }
        executionContext.getExecutionListener().log(4, c + ": " + cmd.toString());
        ExecutionResult result = null;
        Throwable wfstepthrowable = null;
        try {
            executionContext.getExecutionListener().log(4, "ExecutionItem created, executing: " + cmd);
            result = this.framework.getExecutionService().executeItem(executionContext, cmd);
            itemsuccess = null != result && result.isSuccess();
        }
        catch (Throwable exc) {
            if (keepgoing) {
                executionContext.getExecutionListener().log(3, "Step " + c + "of the workflow failed: " + StringUtils.getStackTrace((Throwable)exc));
                wfstepthrowable = exc;
                itemsuccess = false;
            }
            if (null != wlistener) {
                wlistener.finishWorkflowItem(c, cmd);
            }
            throw new WorkflowStepFailureException("Step " + c + " of the workflow threw exception: " + exc.getMessage(), exc, c);
        }
        if (null != result && null != result.getResultObject()) {
            resultList.add(result.getResultObject());
        }
        if (null != wlistener) {
            wlistener.finishWorkflowItem(c, cmd);
        }
        if (itemsuccess) {
            executionContext.getExecutionListener().log(4, c + ": ExecutionItem finished, result: " + result);
        } else if (keepgoing) {
            failedMap.put(c, null != wfstepthrowable ? wfstepthrowable.getMessage() : (null != result && null != result.getException() ? result.getException() : (null != result && null != result.getResultObject() ? result.getResultObject() : "no result")));
            executionContext.getExecutionListener().log(4, "Workflow continues");
        } else {
            failedMap.put(c, null != wfstepthrowable ? wfstepthrowable.getMessage() : (null != result && null != result.getException() ? result.getException() : (null != result && null != result.getResultObject() ? result.getResultObject() : "no result")));
            if (null != result && null != result.getException()) {
                throw new WorkflowStepFailureException("Step " + c + " of the workflow threw an exception: " + result.getException().getMessage(), result.getException(), c);
            }
            throw new WorkflowStepFailureException("Step " + c + " of the workflow failed with result: " + (result != null ? result.getResultObject() : null), result, c);
        }
        return itemsuccess;
    }

    protected boolean executeWorkflowItemsForNodeSet(ExecutionContext executionContext, Map<Integer, Object> failedMap, List<DispatcherResult> resultList, List<ExecutionItem> iWorkflowCmdItems, boolean keepgoing) throws WorkflowStepFailureException {
        boolean workflowsuccess = true;
        int c = 1;
        for (ExecutionItem cmd : iWorkflowCmdItems) {
            if (!this.executeWFItem(executionContext, failedMap, resultList, c, cmd, keepgoing)) {
                workflowsuccess = false;
            }
            ++c;
        }
        return workflowsuccess;
    }

    protected HashMap<String, List<StatusResult>> convertResults(List<DispatcherResult> resultList) {
        HashMap<String, List<StatusResult>> results = new HashMap<String, List<StatusResult>>();
        int i = 0;
        for (DispatcherResult dispatcherResult : resultList) {
            for (String s : dispatcherResult.getResults().keySet()) {
                StatusResult interpreterResult = dispatcherResult.getResults().get(s);
                if (!results.containsKey(s)) {
                    results.put(s, new ArrayList());
                }
                results.get(s).add(interpreterResult);
            }
            ++i;
        }
        return results;
    }

    protected Map<String, Collection<String>> convertFailures(Map<Integer, Object> failedMap) {
        HashMap<String, Collection<String>> failures = new HashMap<String, Collection<String>>();
        for (Map.Entry<Integer, Object> entry : failedMap.entrySet()) {
            Exception e;
            Object o = entry.getValue();
            if (o instanceof DispatcherResult) {
                DispatcherResult dispatcherResult = (DispatcherResult)o;
                for (String s : dispatcherResult.getResults().keySet()) {
                    StatusResult interpreterResult = dispatcherResult.getResults().get(s);
                    if (!failures.containsKey(s)) {
                        failures.put(s, new ArrayList());
                    }
                    ((Collection)failures.get(s)).add(interpreterResult.toString());
                }
                continue;
            }
            if (o instanceof DispatcherException) {
                String key;
                e = (DispatcherException)o;
                INodeEntry node = ((DispatcherException)e).getNode();
                String string = key = null != node ? node.getNodename() : "?";
                if (!failures.containsKey(key)) {
                    failures.put(key, new ArrayList());
                }
                ((Collection)failures.get(key)).add(e.getMessage());
                continue;
            }
            if (o instanceof Exception) {
                e = (Exception)o;
                if (!failures.containsKey("?")) {
                    failures.put("?", new ArrayList());
                }
                ((Collection)failures.get("?")).add(e.getMessage());
                continue;
            }
            if (!failures.containsKey("?")) {
                failures.put("?", new ArrayList());
            }
            ((Collection)failures.get("?")).add(o.toString());
        }
        return failures;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class WorkflowExecutionResult
    implements com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionResult {
        private final HashMap<String, List<StatusResult>> results;
        private final Map<String, Collection<String>> failures;
        private final boolean success;
        private final Exception orig;

        public WorkflowExecutionResult(HashMap<String, List<StatusResult>> results, Map<String, Collection<String>> failures, boolean success, Exception orig) {
            this.results = results;
            this.failures = failures;
            this.success = success;
            this.orig = orig;
        }

        @Override
        public Map<String, List<StatusResult>> getResultSet() {
            return this.results;
        }

        @Override
        public Map<String, Collection<String>> getFailureMessages() {
            return this.failures;
        }

        @Override
        public boolean isSuccess() {
            return this.success;
        }

        @Override
        public Exception getException() {
            return this.orig;
        }

        public String toString() {
            return "[Workflow " + (null != this.getResultSet() && this.getResultSet().size() > 0 ? "results: " + this.getResultSet() : "") + (null != this.getFailureMessages() && this.getFailureMessages().size() > 0 ? ", failures: " + this.getFailureMessages() : "") + (null != this.getException() ? ": exception: " + this.getException() : "") + "]";
        }
    }
}

