/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.workflow;

import com.dtolabs.rundeck.core.CoreException;
import com.dtolabs.rundeck.core.NodesetEmptyException;
import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.common.INodeSet;
import com.dtolabs.rundeck.core.common.NodeFileParserException;
import com.dtolabs.rundeck.core.common.NodesSelector;
import com.dtolabs.rundeck.core.common.SelectorUtils;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.ExecutionContextImpl;
import com.dtolabs.rundeck.core.execution.ExecutionItem;
import com.dtolabs.rundeck.core.execution.StatusResult;
import com.dtolabs.rundeck.core.execution.dispatch.Dispatchable;
import com.dtolabs.rundeck.core.execution.dispatch.DispatcherException;
import com.dtolabs.rundeck.core.execution.dispatch.DispatcherResult;
import com.dtolabs.rundeck.core.execution.service.ExecutionServiceException;
import com.dtolabs.rundeck.core.execution.workflow.BaseWorkflowStrategy;
import com.dtolabs.rundeck.core.execution.workflow.IWorkflow;
import com.dtolabs.rundeck.core.execution.workflow.StepFirstWorkflowStrategy;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionItem;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionItemImpl;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class NodeFirstWorkflowStrategy
extends BaseWorkflowStrategy {
    public NodeFirstWorkflowStrategy(Framework framework) {
        super(framework);
    }

    public BaseWorkflowStrategy.WorkflowExecutionResult executeWorkflowImpl(ExecutionContext executionContext, WorkflowExecutionItem item) {
        Exception exception = null;
        IWorkflow workflow = item.getWorkflow();
        boolean nodesuccess = false;
        HashMap<String, List<StatusResult>> results = new HashMap<String, List<StatusResult>>();
        HashMap<String, Collection<String>> failures = new HashMap<String, Collection<String>>();
        try {
            INodeSet nodes;
            NodesSelector nodeSelector = executionContext.getNodeSelector();
            List<ExecutionItem> iWorkflowCmdItems = workflow.getCommands();
            if (iWorkflowCmdItems.size() < 1) {
                executionContext.getExecutionListener().log(1, "Workflow has 0 items");
            }
            String project = executionContext.getFrameworkProject();
            try {
                nodes = this.framework.filterAuthorizedNodes(project, new HashSet<String>(Arrays.asList("read", "run")), this.framework.filterNodeSet(nodeSelector, project, executionContext.getNodesFile()));
            }
            catch (NodeFileParserException e) {
                throw new CoreException("Error parsing node resource file: " + e.getMessage(), e);
            }
            if (0 == nodes.getNodes().size()) {
                throw new NodesetEmptyException(nodeSelector);
            }
            final WorkflowExecutionItem innerLoopItem = NodeFirstWorkflowStrategy.createInnerLoopItem(item);
            final WorkflowExecutor executor = this.framework.getWorkflowExecutionService().getExecutorForItem(innerLoopItem);
            DispatcherResult dispatch = this.framework.getExecutionService().dispatchToNodes(executionContext, new Dispatchable(){

                public StatusResult dispatch(ExecutionContext context, INodeEntry node) throws DispatcherException {
                    return executor.executeWorkflow(new ExecutionContextImpl.Builder(context).nodeSelector(SelectorUtils.singleNode(node.getNodename())).build(), innerLoopItem);
                }
            });
            for (String nodename : dispatch.getResults().keySet()) {
                StatusResult interpreterResult = dispatch.getResults().get(nodename);
                BaseWorkflowStrategy.WorkflowExecutionResult workflowExecutionResult = (BaseWorkflowStrategy.WorkflowExecutionResult)interpreterResult;
                for (String s : workflowExecutionResult.getResultSet().keySet()) {
                    List<StatusResult> collection = workflowExecutionResult.getResultSet().get(s);
                    ArrayList<StatusResult> statusResults = new ArrayList<StatusResult>();
                    for (StatusResult statusResult : collection) {
                        if (!statusResult.isSuccess()) {
                            if (null == failures.get(s)) {
                                failures.put(s, new ArrayList());
                            }
                            ((Collection)failures.get(s)).add(statusResult.toString());
                            continue;
                        }
                        statusResults.add(statusResult);
                    }
                    results.put(s, statusResults);
                }
                for (String s : workflowExecutionResult.getFailureMessages().keySet()) {
                    Collection<String> strings = workflowExecutionResult.getFailureMessages().get(s);
                    if (null == failures.get(s)) {
                        failures.put(s, new ArrayList());
                    }
                    ((Collection)failures.get(s)).addAll(strings);
                }
                if (null == workflowExecutionResult.getException()) continue;
                if (null == failures.get(nodename)) {
                    failures.put(nodename, new ArrayList());
                }
                ((Collection)failures.get(nodename)).add(workflowExecutionResult.getException().getMessage());
            }
            nodesuccess = dispatch.isSuccess();
        }
        catch (RuntimeException e) {
            exception = e;
        }
        catch (DispatcherException e) {
            exception = e;
        }
        catch (ExecutionServiceException e) {
            exception = e;
        }
        boolean success = nodesuccess;
        Exception fexception = exception;
        return new BaseWorkflowStrategy.WorkflowExecutionResult(results, failures, success, fexception);
    }

    public static WorkflowExecutionItem createInnerLoopItem(WorkflowExecutionItem item) {
        WorkflowExecutionItemImpl workflowExecutionItem = new WorkflowExecutionItemImpl(new StepFirstWorkflowStrategy.stepFirstWrapper(item.getWorkflow()));
        return workflowExecutionItem;
    }
}

