/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.workflow;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.ExecutionItem;
import com.dtolabs.rundeck.core.execution.StatusResult;
import com.dtolabs.rundeck.core.execution.dispatch.DispatcherResult;
import com.dtolabs.rundeck.core.execution.workflow.BaseWorkflowStrategy;
import com.dtolabs.rundeck.core.execution.workflow.IWorkflow;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionItem;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowFailureException;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowStepFailureException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StepFirstWorkflowStrategy
extends BaseWorkflowStrategy {
    public StepFirstWorkflowStrategy(Framework framework) {
        super(framework);
    }

    public BaseWorkflowStrategy.WorkflowExecutionResult executeWorkflowImpl(ExecutionContext executionContext, WorkflowExecutionItem item) {
        boolean workflowsuccess = false;
        Exception exception = null;
        IWorkflow workflow = item.getWorkflow();
        HashMap<Integer, Object> failedList = new HashMap<Integer, Object>();
        ArrayList<DispatcherResult> resultList = new ArrayList<DispatcherResult>();
        try {
            executionContext.getExecutionListener().log(4, "NodeSet: " + executionContext.getNodeSelector());
            executionContext.getExecutionListener().log(4, "Workflow: " + workflow);
            executionContext.getExecutionListener().log(4, "data context: " + executionContext.getDataContext());
            List<ExecutionItem> iWorkflowCmdItems = workflow.getCommands();
            if (iWorkflowCmdItems.size() < 1) {
                executionContext.getExecutionListener().log(1, "Workflow has 0 items");
            }
            if (!(workflowsuccess = this.executeWorkflowItemsForNodeSet(executionContext, failedList, resultList, iWorkflowCmdItems, workflow.isKeepgoing()))) {
                throw new WorkflowFailureException("Some steps in the workflow failed: " + failedList);
            }
        }
        catch (RuntimeException e) {
            exception = e;
        }
        catch (WorkflowStepFailureException e) {
            exception = e;
        }
        catch (WorkflowFailureException e) {
            exception = e;
        }
        boolean success = workflowsuccess;
        Exception orig = exception;
        HashMap<String, List<StatusResult>> results = this.convertResults(resultList);
        Map<String, Collection<String>> failures = this.convertFailures(failedList);
        return new BaseWorkflowStrategy.WorkflowExecutionResult(results, failures, success, orig);
    }

    static boolean isInnerLoop(WorkflowExecutionItem item) {
        return item.getWorkflow() instanceof stepFirstWrapper;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class stepFirstWrapper
    implements IWorkflow {
        private IWorkflow workflow;

        stepFirstWrapper(IWorkflow workflow) {
            this.workflow = workflow;
        }

        @Override
        public List<ExecutionItem> getCommands() {
            return this.workflow.getCommands();
        }

        @Override
        public int getThreadcount() {
            return this.workflow.getThreadcount();
        }

        @Override
        public boolean isKeepgoing() {
            return this.workflow.isKeepgoing();
        }

        @Override
        public String getStrategy() {
            return "step-first";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof stepFirstWrapper)) {
                return false;
            }
            stepFirstWrapper that = (stepFirstWrapper)o;
            return !(this.workflow != null ? !this.workflow.equals(that.workflow) : that.workflow != null);
        }

        public int hashCode() {
            return this.workflow != null ? this.workflow.hashCode() : 0;
        }
    }
}

