/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.workflow;

import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.ExecutionItem;
import com.dtolabs.rundeck.core.execution.FailedNodesListener;
import com.dtolabs.rundeck.core.execution.commands.InterpreterResult;
import com.dtolabs.rundeck.core.execution.workflow.ContextLogger;
import com.dtolabs.rundeck.core.execution.workflow.ContextualExecutionListener;
import com.dtolabs.rundeck.core.execution.workflow.WFStepContext;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionItem;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionListener;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionResult;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowExecutionListenerImpl
extends ContextualExecutionListener
implements WorkflowExecutionListener {
    private InheritableThreadLocal<WFStepContext> localStep = new InheritableThreadLocal();
    private InheritableThreadLocal<INodeEntry> localNode = new InheritableThreadLocal();
    private InheritableThreadLocal<String> contextPrefix = new InheritableThreadLocal();

    public WorkflowExecutionListenerImpl(FailedNodesListener failedNodesListener, ContextLogger logger, boolean terse, String logFormat) {
        super(failedNodesListener, logger, terse, logFormat);
    }

    @Override
    public void beginInterpretCommand(ExecutionContext context, ExecutionItem item, INodeEntry node) {
        super.beginInterpretCommand(context, item, node);
        this.localNode.set(node);
        context.getExecutionListener().log(4, "beginInterpretCommand(" + node.getNodename() + "): " + item.getType() + ": " + item);
    }

    @Override
    public void finishInterpretCommand(InterpreterResult result, ExecutionContext context, ExecutionItem item, INodeEntry node) {
        super.finishInterpretCommand(result, context, item, node);
        this.localNode.set(null);
        this.log(4, "finishInterpretCommand(" + node.getNodename() + "): " + item.getType() + ": " + result);
    }

    @Override
    public Map<String, String> getLoggingContext() {
        if (null != this.localStep.get() || null != this.localNode.get()) {
            HashMap<String, String> loggingContext = new HashMap<String, String>();
            if (null != this.localNode.get()) {
                INodeEntry node = (INodeEntry)this.localNode.get();
                loggingContext.put("node", node.getNodename());
                loggingContext.put("user", node.extractUserName());
            }
            if (null != this.localStep.get()) {
                WFStepContext wfStepInfo = (WFStepContext)this.localStep.get();
                int step = wfStepInfo.step;
                String s = this.makePrefix(wfStepInfo);
                if (null != this.contextPrefix.get()) {
                    loggingContext.put("command", (String)this.contextPrefix.get() + ":" + s);
                } else {
                    loggingContext.put("command", s);
                }
                if (step > -1) {
                    loggingContext.put("step", Integer.toString(step));
                }
            }
            return loggingContext;
        }
        return null;
    }

    private String makePrefix(WFStepContext wfStepInfo) {
        return wfStepInfo.step + "-" + wfStepInfo.stepItem.getType();
    }

    @Override
    public void beginWorkflowExecution(ExecutionContext executionContext, WorkflowExecutionItem item) {
        if (null != this.localStep.get()) {
            String prefix = this.makePrefix((WFStepContext)this.localStep.get());
            if (null != this.contextPrefix.get()) {
                this.contextPrefix.set((String)this.contextPrefix.get() + ":" + prefix);
            } else {
                this.contextPrefix.set(prefix);
            }
        }
        this.localStep.set(null);
        this.localNode.set(null);
        this.log(4, "[workflow] Begin execution: " + item.getType());
    }

    @Override
    public void finishWorkflowExecution(WorkflowExecutionResult result, ExecutionContext executionContext, WorkflowExecutionItem item) {
        String s = (String)this.contextPrefix.get();
        if (null != s) {
            if (s.lastIndexOf(":") > 0) {
                this.contextPrefix.set(s.substring(0, s.lastIndexOf(":")));
            } else {
                this.contextPrefix.set(null);
            }
        }
        this.localStep.set(null);
        this.localNode.set(null);
        this.log(4, "[workflow] Finish execution:  " + item.getType() + ": " + result);
    }

    @Override
    public void beginWorkflowItem(int step, ExecutionItem item) {
        this.localStep.set(new WFStepContext(item, step));
        this.log(4, "[workflow] Begin step: " + step + "," + item.getType());
    }

    @Override
    public void finishWorkflowItem(int step, ExecutionItem item) {
        this.localStep.set(null);
        this.log(4, "[workflow] Finish step: " + step + "," + item.getType());
    }
}

