/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.plugins;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.plugins.ScriptPluginProvider;
import com.dtolabs.rundeck.core.plugins.configuration.AbstractBaseDescription;
import com.dtolabs.rundeck.core.plugins.configuration.ConfigurationException;
import com.dtolabs.rundeck.core.plugins.configuration.Describable;
import com.dtolabs.rundeck.core.plugins.configuration.Description;
import com.dtolabs.rundeck.core.plugins.configuration.Property;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDescribableScriptPlugin
implements Describable {
    public static final String TITLE_PROP = "title";
    public static final String DESCRIPTION_PROP = "description";
    public static final String CONFIG_PROP_PREFIX = "config";
    public static final String CONFIG_TITLE = "title";
    public static final String CONFIG_DESCRIPTION = "description";
    public static final String CONFIG_NAME = "name";
    public static final String CONFIG_TYPE = "type";
    public static final String CONFIG_REQUIRED = "required";
    public static final String CONFIG_DEFAULT = "default";
    public static final String CONFIG_VALUES = "values";
    private final ScriptPluginProvider provider;
    private final Framework framework;
    Description providerDescription;

    public AbstractDescribableScriptPlugin(ScriptPluginProvider provider, Framework framework) {
        this.provider = provider;
        this.framework = framework;
    }

    public Map<String, String> createPluginDataContext() {
        HashMap<String, String> pluginDataContext = new HashMap<String, String>();
        pluginDataContext.put("file", this.provider.getArchiveFile().getAbsolutePath());
        pluginDataContext.put("scriptfile", this.provider.getScriptFile().getAbsolutePath());
        pluginDataContext.put("base", this.provider.getContentsBasedir().getAbsolutePath());
        return pluginDataContext;
    }

    private static List<Property> createProperties(ScriptPluginProvider provider) throws ConfigurationException {
        ArrayList<Property> properties = new ArrayList<Property>();
        boolean i = true;
        Map<String, Object> metadata = provider.getMetadata();
        Object config = metadata.get(CONFIG_PROP_PREFIX);
        if (config instanceof List) {
            List configs = (List)config;
            for (Object citem : configs) {
                ArrayList<String> values;
                String[] split;
                String defaultValue;
                Property.Type type;
                if (!(citem instanceof Map)) continue;
                Map itemmeta = (Map)citem;
                String typestr = AbstractDescribableScriptPlugin.metaStringProp(itemmeta, CONFIG_TYPE);
                try {
                    type = Property.Type.valueOf(typestr);
                }
                catch (IllegalArgumentException e) {
                    throw new ConfigurationException("Invalid property type: " + typestr);
                }
                String name = AbstractDescribableScriptPlugin.metaStringProp(itemmeta, CONFIG_NAME);
                String title = AbstractDescribableScriptPlugin.metaStringProp(itemmeta, "title");
                String description = AbstractDescribableScriptPlugin.metaStringProp(itemmeta, "description");
                Object reqValue = itemmeta.get(CONFIG_REQUIRED);
                boolean required = reqValue instanceof Boolean ? (Boolean)reqValue : reqValue instanceof String && Boolean.parseBoolean((String)reqValue);
                Object defObj = itemmeta.get(CONFIG_DEFAULT);
                String string = defaultValue = null != defObj ? defObj.toString() : null;
                if (null == name) {
                    throw new ConfigurationException("Name required");
                }
                String valuesstr = AbstractDescribableScriptPlugin.metaStringProp(itemmeta, CONFIG_VALUES);
                String[] stringArray = split = null != valuesstr ? valuesstr.split(",") : null;
                if (null != split) {
                    ArrayList<String> valuesA = new ArrayList<String>();
                    for (String s : split) {
                        valuesA.add(s.trim());
                    }
                    values = valuesA;
                } else {
                    values = null;
                }
                properties.add(PropertyUtil.forType(type, name, title, description, required, defaultValue, values));
            }
        }
        return properties;
    }

    private static String metaStringProp(Map<String, Object> metadata, String prop) {
        return AbstractDescribableScriptPlugin.metaStringProp(metadata, prop, null);
    }

    private static String metaStringProp(Map<String, Object> metadata, String prop, String defString) {
        Object titleobj = metadata.get(prop);
        return null != titleobj && titleobj instanceof String ? (String)titleobj : defString;
    }

    protected static Description createDescription(final ScriptPluginProvider provider, boolean allowCustomProperties) throws ConfigurationException {
        final String title = AbstractDescribableScriptPlugin.metaStringProp(provider.getMetadata(), "title", provider.getName() + " Script Plugin");
        final String description = AbstractDescribableScriptPlugin.metaStringProp(provider.getMetadata(), "description", "");
        final List<Property> properties = allowCustomProperties ? AbstractDescribableScriptPlugin.createProperties(provider) : null;
        return new AbstractBaseDescription(){

            @Override
            public String getName() {
                return provider.getName();
            }

            @Override
            public String getTitle() {
                return title;
            }

            @Override
            public String getDescription() {
                return description;
            }

            @Override
            public List<Property> getProperties() {
                return properties;
            }
        };
    }

    @Override
    public Description getDescription() {
        if (null == this.providerDescription) {
            try {
                this.providerDescription = AbstractDescribableScriptPlugin.createDescription(this.provider, this.isAllowCustomProperties());
            }
            catch (ConfigurationException e) {
                e.printStackTrace();
            }
        }
        return this.providerDescription;
    }

    public abstract boolean isAllowCustomProperties();

    public ScriptPluginProvider getProvider() {
        return this.provider;
    }

    public Framework getFramework() {
        return this.framework;
    }
}

