/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.plugins;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.ProviderService;
import com.dtolabs.rundeck.core.execution.service.ExecutionServiceException;
import com.dtolabs.rundeck.core.execution.service.MissingProviderException;
import com.dtolabs.rundeck.core.execution.service.ProviderCreationException;
import com.dtolabs.rundeck.core.plugins.ProviderIdent;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseProviderRegistryService<T>
implements ProviderService<T> {
    protected HashMap<String, Class<? extends T>> registry;
    protected HashMap<String, T> instanceregistry;
    protected final Framework framework;

    public BaseProviderRegistryService(Framework framework) {
        this.framework = framework;
        this.instanceregistry = new HashMap();
        this.registry = new HashMap();
    }

    public void registerClass(String name, Class<? extends T> clazz) {
        this.registry.put(name, clazz);
    }

    public void registerInstance(String name, T object) {
        this.instanceregistry.put(name, object);
    }

    @Override
    public T providerOfType(String providerName) throws ExecutionServiceException {
        if (null == providerName) {
            throw new IllegalArgumentException("provider name was null for Service: " + this.getName());
        }
        if (null == this.instanceregistry.get(providerName)) {
            T instance = this.createProviderInstanceOfType(providerName);
            this.instanceregistry.put(providerName, instance);
            return instance;
        }
        return this.instanceregistry.get(providerName);
    }

    public List<ProviderIdent> listProviders() {
        HashSet<ProviderIdent> providers = new HashSet<ProviderIdent>();
        for (String s : this.registry.keySet()) {
            providers.add(new ProviderIdent(this.getName(), s));
        }
        for (String s : this.instanceregistry.keySet()) {
            providers.add(new ProviderIdent(this.getName(), s));
        }
        return new ArrayList<ProviderIdent>(providers);
    }

    private T createProviderInstanceOfType(String providerName) throws ExecutionServiceException {
        if (null == this.registry.get(providerName)) {
            throw new MissingProviderException("Not found", this.getName(), providerName);
        }
        Class<? extends T> execClass = this.registry.get(providerName);
        return this.createProviderInstanceFromType(execClass, providerName);
    }

    protected T createProviderInstanceFromType(Class<? extends T> execClass, String providerName) throws ProviderCreationException {
        boolean ctrfound = true;
        try {
            Constructor<T> method = execClass.getDeclaredConstructor(Framework.class);
            T executor = method.newInstance(this.framework);
            return executor;
        }
        catch (NoSuchMethodException e) {
            ctrfound = false;
        }
        catch (Exception e) {
            throw new ProviderCreationException("Unable to create provider instance: " + e.getMessage(), e, this.getName(), providerName);
        }
        try {
            Constructor<T> method = execClass.getDeclaredConstructor(new Class[0]);
            T executor = method.newInstance(new Object[0]);
            return executor;
        }
        catch (NoSuchMethodException e) {
            throw new ProviderCreationException("No constructor found with signature (Framework) or (): " + e.getMessage(), e, this.getName(), providerName);
        }
        catch (Exception e) {
            throw new ProviderCreationException("Unable to create provider instance: " + e.getMessage(), e, this.getName(), providerName);
        }
    }

    protected boolean hasValidProviderSignature(Class clazz) {
        try {
            Constructor method = clazz.getDeclaredConstructor(Framework.class);
            return null != method;
        }
        catch (NoSuchMethodException e) {
            try {
                Constructor method = clazz.getDeclaredConstructor(new Class[0]);
                return null != method;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return false;
            }
        }
    }
}

