/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.plugins;

import com.dtolabs.rundeck.core.plugins.DirPluginScanner;
import com.dtolabs.rundeck.core.plugins.JarPluginProviderLoader;
import com.dtolabs.rundeck.core.plugins.ProviderLoader;
import com.dtolabs.rundeck.core.utils.cache.FileCache;
import java.io.File;
import java.io.FileFilter;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JarPluginScanner
extends DirPluginScanner {
    static Logger log = Logger.getLogger((String)JarPluginScanner.class.getName());
    public static final FileFilter FILENAME_FILTER = new FileFilter(){

        public boolean accept(File file) {
            return file.isFile() && file.getName().endsWith(".jar");
        }
    };
    final File cachedir;

    JarPluginScanner(File extdir, File cachedir, FileCache<ProviderLoader> filecache, int rescanInterval) {
        super(extdir, filecache, rescanInterval);
        this.cachedir = cachedir;
    }

    @Override
    public boolean isValidPluginFile(File file) {
        return JarPluginProviderLoader.isValidJarPlugin(file);
    }

    @Override
    public FileFilter getFileFilter() {
        return FILENAME_FILTER;
    }

    @Override
    public ProviderLoader createCacheItemForFile(File file) {
        return this.createLoader(file);
    }

    @Override
    public ProviderLoader createLoader(File file) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("create JarFileProviderLoader: " + file));
        }
        return new JarPluginProviderLoader(file, this.cachedir);
    }

    @Override
    protected String getVersionForFile(File file) {
        return JarPluginProviderLoader.getVersionForFile(file);
    }
}

