/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.plugins.configuration;

import com.dtolabs.rundeck.core.plugins.configuration.Property;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyBase;
import com.dtolabs.rundeck.core.plugins.configuration.ValidationException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyUtil {
    static final Property.Validator booleanValidator = new Property.Validator(){

        public boolean isValid(String value) throws ValidationException {
            return "true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value);
        }
    };
    static final Property.Validator integerValidator = new Property.Validator(){

        public boolean isValid(String value) throws ValidationException {
            try {
                Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                throw new ValidationException("Not a valid integer");
            }
            return true;
        }
    };
    static final Property.Validator longValidator = new Property.Validator(){

        public boolean isValid(String value) throws ValidationException {
            try {
                Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                throw new ValidationException("Not a valid integer");
            }
            return true;
        }
    };

    public static Property forType(Property.Type type, String name, String title, String description, boolean required, String defaultValue, List<String> values) {
        switch (type) {
            case Integer: {
                return PropertyUtil.integer(name, title, description, required, defaultValue);
            }
            case Boolean: {
                return PropertyUtil.bool(name, title, description, required, defaultValue);
            }
            case Long: {
                return PropertyUtil.longProp(name, title, description, required, defaultValue);
            }
            case Select: {
                return PropertyUtil.select(name, title, description, required, defaultValue, values);
            }
            case FreeSelect: {
                return PropertyUtil.freeSelect(name, title, description, required, defaultValue, values);
            }
        }
        return PropertyUtil.string(name, title, description, required, defaultValue);
    }

    public static Property string(String name, String title, String description, boolean required, String defaultValue, Property.Validator validator) {
        return new StringProperty(name, title, description, required, defaultValue, validator);
    }

    public static Property string(String name, String title, String description, boolean required, String defaultValue) {
        return new StringProperty(name, title, description, required, defaultValue, null);
    }

    public static Property bool(String name, String title, String description, boolean required, String defaultValue) {
        return new BooleanProperty(name, title, description, required, defaultValue);
    }

    public static Property integer(String name, String title, String description, boolean required, String defaultValue) {
        return new IntegerProperty(name, title, description, required, defaultValue);
    }

    public static Property longProp(String name, String title, String description, boolean required, String defaultValue) {
        return new LongProperty(name, title, description, required, defaultValue);
    }

    public static Property select(String name, String title, String description, boolean required, String defaultValue, List<String> selectValues) {
        return new SelectProperty(name, title, description, required, defaultValue, selectValues);
    }

    public static Property freeSelect(String name, String title, String description, boolean required, String defaultValue, List<String> selectValues) {
        return new FreeSelectProperty(name, title, description, required, defaultValue, selectValues);
    }

    private static class Generic
    extends PropertyBase {
        private final Property.Type type;

        public Generic(String name, String title, String description, boolean required, String defaultValue, Property.Validator validator, Property.Type type) {
            super(name, title, description, required, defaultValue, validator);
            this.type = type;
        }

        public Property.Type getType() {
            return this.type;
        }
    }

    static final class LongProperty
    extends PropertyBase {
        public LongProperty(String name, String title, String description, boolean required, String defaultValue) {
            super(name, title, description, required, defaultValue, longValidator);
        }

        public Property.Type getType() {
            return Property.Type.Long;
        }
    }

    static final class IntegerProperty
    extends PropertyBase {
        public IntegerProperty(String name, String title, String description, boolean required, String defaultValue) {
            super(name, title, description, required, defaultValue, integerValidator);
        }

        public Property.Type getType() {
            return Property.Type.Integer;
        }
    }

    static final class BooleanProperty
    extends PropertyBase {
        public BooleanProperty(String name, String title, String description, boolean required, String defaultValue) {
            super(name, title, description, required, defaultValue, booleanValidator);
        }

        public Property.Type getType() {
            return Property.Type.Boolean;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class SelectValidator
    implements Property.Validator {
        final List<String> selectValues;

        SelectValidator(List<String> selectValues) {
            this.selectValues = selectValues;
        }

        @Override
        public boolean isValid(String value) throws ValidationException {
            return this.selectValues.contains(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class SelectProperty
    extends PropertyBase {
        final List<String> selectValues;

        public SelectProperty(String name, String title, String description, boolean required, String defaultValue, List<String> selectValues) {
            super(name, title, description, required, defaultValue, new SelectValidator(selectValues));
            this.selectValues = selectValues;
        }

        @Override
        public Property.Type getType() {
            return Property.Type.Select;
        }

        @Override
        public List<String> getSelectValues() {
            return this.selectValues;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class FreeSelectProperty
    extends PropertyBase {
        final List<String> selectValues;

        public FreeSelectProperty(String name, String title, String description, boolean required, String defaultValue, List<String> selectValues) {
            super(name, title, description, required, defaultValue, null);
            this.selectValues = selectValues;
        }

        @Override
        public Property.Type getType() {
            return Property.Type.FreeSelect;
        }

        @Override
        public List<String> getSelectValues() {
            return this.selectValues;
        }
    }

    static final class StringProperty
    extends PropertyBase {
        public StringProperty(String name, String title, String description, boolean required, String defaultValue, Property.Validator validator) {
            super(name, title, description, required, defaultValue, validator);
        }

        public Property.Type getType() {
            return Property.Type.String;
        }
    }
}

