/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.resources;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.INodeSet;
import com.dtolabs.rundeck.core.plugins.ScriptDataContextUtil;
import com.dtolabs.rundeck.core.plugins.configuration.AbstractBaseDescription;
import com.dtolabs.rundeck.core.plugins.configuration.Configurable;
import com.dtolabs.rundeck.core.plugins.configuration.ConfigurationException;
import com.dtolabs.rundeck.core.plugins.configuration.Property;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyUtil;
import com.dtolabs.rundeck.core.plugins.configuration.ValidationException;
import com.dtolabs.rundeck.core.resources.ResourceModelSource;
import com.dtolabs.rundeck.core.resources.ResourceModelSourceException;
import com.dtolabs.rundeck.core.resources.ScriptResourceUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ScriptResourceModelSource
implements Configurable,
ResourceModelSource {
    static Logger logger = Logger.getLogger((String)ScriptResourceModelSource.class.getName());
    static ArrayList<Property> scriptResourceProperties = new ArrayList();
    public static final String CONFIG_FILE = "file";
    public static final String CONFIG_INTERPRETER = "interpreter";
    public static final String CONFIG_ARGS = "args";
    public static final String CONFIG_INTERPRETER_ARGS_QUOTED = "argsQuoted";
    public static final String CONFIG_FORMAT = "format";
    private String format;
    private File scriptFile;
    private String interpreter;
    private String args;
    private boolean interpreterArgsQuoted;
    private String project;
    HashMap<String, Map<String, String>> configDataContext;
    Map<String, Map<String, String>> executionDataContext;
    private Framework framework;

    public ScriptResourceModelSource(Framework framework) {
        this.framework = framework;
    }

    public void configure(Properties configuration) throws ConfigurationException {
        if (!configuration.containsKey("project")) {
            throw new ConfigurationException("project is required");
        }
        this.project = configuration.getProperty("project");
        if (!configuration.containsKey(CONFIG_FILE)) {
            throw new ConfigurationException("file is required");
        }
        this.scriptFile = new File(configuration.getProperty(CONFIG_FILE));
        if (!this.scriptFile.isFile()) {
            throw new ConfigurationException("file does not exist or is not a file: " + this.scriptFile.getAbsolutePath());
        }
        this.interpreter = configuration.getProperty(CONFIG_INTERPRETER);
        this.args = configuration.getProperty(CONFIG_ARGS);
        if (!configuration.containsKey(CONFIG_FORMAT)) {
            throw new ConfigurationException("format is required");
        }
        this.format = configuration.getProperty(CONFIG_FORMAT);
        this.interpreterArgsQuoted = Boolean.parseBoolean(configuration.getProperty(CONFIG_INTERPRETER_ARGS_QUOTED));
        this.configDataContext = new HashMap();
        HashMap<String, String> configdata = new HashMap<String, String>();
        configdata.put("project", this.project);
        this.configDataContext.put("context", configdata);
        this.executionDataContext = ScriptDataContextUtil.createScriptDataContextForProject(this.framework, this.project);
        this.executionDataContext.putAll(this.configDataContext);
    }

    public INodeSet getNodes() throws ResourceModelSourceException {
        try {
            return ScriptResourceUtil.executeScript(this.scriptFile, this.args, this.interpreter, "script", this.executionDataContext, this.format, this.framework, this.project, logger, this.interpreterArgsQuoted);
        }
        catch (ResourceModelSourceException e) {
            throw new ResourceModelSourceException("failed to execute: " + this.scriptFile + ": " + e.getMessage(), e);
        }
    }

    public String toString() {
        return "ScriptResourceModelSource{scriptFile=" + this.scriptFile + ", format='" + this.format + '\'' + '}';
    }

    static {
        scriptResourceProperties.add(PropertyUtil.string(CONFIG_FILE, "Script File Path", "Path to script file to execute", true, null, new Property.Validator(){

            public boolean isValid(String value) throws ValidationException {
                return new File(value).isFile();
            }
        }));
        scriptResourceProperties.add(PropertyUtil.string(CONFIG_INTERPRETER, "Interpreter", "Command interpreter to use (optional)", false, null));
        scriptResourceProperties.add(PropertyUtil.string(CONFIG_ARGS, "Arguments", "Arguments to pass to the script (optional)", false, null));
        scriptResourceProperties.add(PropertyUtil.bool(CONFIG_INTERPRETER_ARGS_QUOTED, "Quote Interpreter Args", "If true, pass script file and args as a single argument to interpreter, otherwise, pass as multiple arguments", false, "false"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Description
    extends AbstractBaseDescription {
        final List<Property> properties;

        Description(List<String> formats) {
            ArrayList<Property> properties1 = new ArrayList<Property>(scriptResourceProperties);
            properties1.add(PropertyUtil.freeSelect(ScriptResourceModelSource.CONFIG_FORMAT, "Resource Format", "Resources document format that the script will produce", true, null, formats));
            this.properties = Collections.unmodifiableList(properties1);
        }

        @Override
        public String getName() {
            return "script";
        }

        @Override
        public String getTitle() {
            return "Script";
        }

        @Override
        public String getDescription() {
            return "Run a script to produce resource model data";
        }

        @Override
        public List<Property> getProperties() {
            return this.properties;
        }
    }
}

