/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.resources.format;

import com.dtolabs.rundeck.core.common.INodeSet;
import com.dtolabs.rundeck.core.common.NodeFileParserException;
import com.dtolabs.rundeck.core.common.NodeReceiver;
import com.dtolabs.rundeck.core.common.NodeSetImpl;
import com.dtolabs.rundeck.core.common.NodesXMLParser;
import com.dtolabs.rundeck.core.plugins.Plugin;
import com.dtolabs.rundeck.core.plugins.configuration.AbstractBaseDescription;
import com.dtolabs.rundeck.core.plugins.configuration.Describable;
import com.dtolabs.rundeck.core.plugins.configuration.Description;
import com.dtolabs.rundeck.core.resources.format.ResourceFormatParser;
import com.dtolabs.rundeck.core.resources.format.ResourceFormatParserException;
import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Plugin(name="resourcexml", service="ResourceFormatParser")
public class ResourceXMLFormatParser
implements ResourceFormatParser,
Describable {
    public static final String SERVICE_PROVIDER_TYPE = "resourcexml";
    public static final Set<String> EXTENSIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("xml")));
    public static final Set<String> MIME_TYPES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("*/xml")));
    private static final Description DESCRIPTION = new AbstractBaseDescription(){

        public String getName() {
            return ResourceXMLFormatParser.SERVICE_PROVIDER_TYPE;
        }

        public String getTitle() {
            return "Resource XML";
        }

        public String getDescription() {
            return "The RunDeck Resource XML format 1.3";
        }
    };

    @Override
    public Set<String> getFileExtensions() {
        return EXTENSIONS;
    }

    @Override
    public Set<String> getMIMETypes() {
        return MIME_TYPES;
    }

    @Override
    public INodeSet parseDocument(File file) throws ResourceFormatParserException {
        NodeSetImpl nodeReceiver = new NodeSetImpl();
        try {
            new NodesXMLParser(file, (NodeReceiver)nodeReceiver).parse();
        }
        catch (NodeFileParserException e) {
            throw new ResourceFormatParserException(e);
        }
        return nodeReceiver;
    }

    @Override
    public INodeSet parseDocument(InputStream input) throws ResourceFormatParserException {
        NodeSetImpl nodeReceiver = new NodeSetImpl();
        try {
            new NodesXMLParser(input, (NodeReceiver)nodeReceiver).parse();
        }
        catch (NodeFileParserException e) {
            throw new ResourceFormatParserException(e);
        }
        return nodeReceiver;
    }

    @Override
    public Description getDescription() {
        return DESCRIPTION;
    }
}

