/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.utils;

import java.util.Arrays;

public final class Base64 {
    private static final boolean debug = false;
    static final byte[] X = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47, 61};

    private Base64() {
    }

    public static final boolean isBase64(String t) {
        return Base64.isBase64(t.getBytes());
    }

    public static final boolean isBase64(byte[] b) {
        if (b.length < 4) {
            return false;
        }
        if (b.length == 0) {
            return true;
        }
        String t = new String(b);
        int end = 0;
        if (t.endsWith("==")) {
            end = 2;
        } else if (t.endsWith("=")) {
            end = 1;
        }
        int vc = 0;
        for (int i = 0; i < b.length - end; ++i) {
            if (b[i] == 13 || b[i] == 10 || b[i] == 32) continue;
            boolean ok = false;
            for (int j = 0; j < X.length - 1; ++j) {
                if (X[j] != b[i]) continue;
                ok = true;
                break;
            }
            if (!ok) {
                return false;
            }
            ++vc;
        }
        return (vc + end) % 4 == 0;
    }

    public static final String encode(String in) {
        return new String(Base64.encode(in.getBytes()));
    }

    private static final String hex(byte in) {
        return Long.toHexString((long)in & 0xFFL);
    }

    public static final byte[] encode(byte[] in) {
        int pad = 0 == in.length % 3 ? 0 : 3 - in.length % 3;
        int padded = in.length + pad;
        byte[] sa = new byte[padded];
        Arrays.fill(sa, (byte)0);
        System.arraycopy(in, 0, sa, 0, in.length);
        byte[] ou = new byte[padded / 3 * 4];
        int dest = 0;
        boolean mx = false;
        for (int i = 0; i < sa.length; i += 3) {
            ou[dest++] = X[(sa[i] & 0xFC) >> 2];
            ou[dest++] = X[(sa[i] & 3) << 4 | (sa[i + 1] & 0xF0) >> 4];
            if (2 == pad && i + 3 >= sa.length) {
                ou[dest++] = X[64];
                ou[dest++] = X[64];
                break;
            }
            ou[dest++] = X[(sa[i + 1] & 0xF) << 2 | (sa[i + 2] & 0xC0) >> 6];
            if (1 == pad && i + 3 >= sa.length) {
                ou[dest++] = X[64];
                break;
            }
            ou[dest++] = X[sa[i + 2] & 0x3F];
            mx = false;
        }
        return ou;
    }

    public static final byte[] decode(String in) {
        return Base64.decode(in.getBytes());
    }

    public static final byte[] decode(byte[] in) {
        if (in.length == 0) {
            return new byte[0];
        }
        if (!Base64.isBase64(in)) {
            return null;
        }
        int olen = in.length / 4 * 3;
        int pad = 0;
        if (in[in.length - 1] == X[64]) {
            ++pad;
            if (in[in.length - 2] == X[64]) {
                ++pad;
            }
        }
        byte[] ou = new byte[olen -= pad];
        int dest = 0;
        boolean mx = false;
        byte[] ck = Base64.ndx(in);
        for (int i = 0; i < ck.length; i += 4) {
            ou[dest++] = (byte)(((ck[i] & 0x3F) << 2 | (ck[i + 1] & 0x30) >> 4) & 0xFF);
            if (pad == 2 && i + 4 >= ck.length) break;
            ou[dest++] = (byte)(((ck[i + 1] & 0xF) << 4 | (ck[i + 2] & 0x3C) >> 2) & 0xFF);
            if (pad == 1 && i + 4 >= ck.length) break;
            ou[dest++] = (byte)(((ck[i + 2] & 3) << 6 | ck[i + 3] & 0x3F) & 0xFF);
            mx = false;
        }
        return ou;
    }

    private static final byte ndx(byte w) {
        for (int i = 0; i < X.length - 1; ++i) {
            if (X[i] != w) continue;
            return (byte)i;
        }
        return -1;
    }

    private static final byte[] ndx(byte[] w) {
        byte[] o = new byte[w.length];
        for (int i = 0; i < w.length; ++i) {
            o[i] = Base64.ndx(w[i]);
        }
        return o;
    }
}

