/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.utils;

import java.io.File;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.FilterSet;
import org.apache.tools.ant.types.Mapper;

public class ConfigWriter {
    final File configDir;
    final File defaultsFile;
    final String includes;
    final String to;

    private ConfigWriter(File dir, File propFile, String includes, String to) {
        this.configDir = dir;
        this.defaultsFile = propFile;
        this.includes = includes;
        this.to = to;
    }

    public static ConfigWriter create(File dir, File propFile, String includes, String to) {
        return new ConfigWriter(dir, propFile, includes, to);
    }

    public void write(boolean overwrite) {
        Project project = new Project();
        Copy copy = new Copy();
        copy.setProject(project);
        copy.setTodir(this.configDir);
        copy.setFiltering(true);
        copy.setOverwrite(overwrite);
        FilterSet filterset = copy.createFilterSet();
        filterset.createFiltersfile().setFile(this.defaultsFile);
        FileSet fileset = new FileSet();
        fileset.setProject(project);
        fileset.setIncludes(this.includes);
        fileset.setDir(this.configDir);
        copy.addFileset(fileset);
        Mapper mapper = copy.createMapper();
        mapper.setFrom(this.includes);
        mapper.setTo(this.to);
        Mapper.MapperType glob = new Mapper.MapperType();
        glob.setValue("glob");
        mapper.setType(glob);
        copy.execute();
    }
}

