/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.utils;

import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.common.NodesSelector;
import com.dtolabs.rundeck.core.common.SelectorUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeSet
extends ProjectComponent
implements NodesSelector {
    public static final String HOSTNAME = "hostname";
    public static final String NAME = "name";
    public static final String TYPE = "type";
    public static final String TAGS = "tags";
    public static final String OS_NAME = "os-name";
    public static final String OS_FAMILY = "os-family";
    public static final String OS_ARCH = "os-arch";
    public static final String OS_VERSION = "os-version";
    private String singleNodeName;
    private static final String[] FILTER_KEYS = new String[]{"hostname", "name", "type", "tags", "os-name", "os-family", "os-arch", "os-version"};
    public static final List<String> FILTER_KEYS_LIST = Collections.unmodifiableList(Arrays.asList(FILTER_KEYS));
    public static final Collection<String> FILTER_KEYSET = new HashSet<String>(FILTER_KEYS_LIST);
    private Include includes;
    private Exclude excludes;
    private int threadCount = 1;
    private boolean keepgoing = false;
    private File failedNodesfile;

    public NodeSet() {
    }

    public NodeSet(String singleNodeName) {
        this.singleNodeName = singleNodeName;
    }

    public NodeSet(INodeEntry singleNode) {
        this(singleNode.getNodename());
    }

    public String getSingleNodeName() {
        return this.singleNodeName;
    }

    public void setSingleNodeName(String singleNodeName) {
        this.singleNodeName = singleNodeName;
    }

    @Override
    public boolean acceptNode(INodeEntry entry) {
        return !this.shouldExclude(entry);
    }

    public NodesSelector nodeSelectorWithDefault(String nodename) {
        final NodesSelector nodesSelector = SelectorUtils.singleNode(nodename);
        return new NodesSelector(){

            public boolean acceptNode(INodeEntry entry) {
                return !NodeSet.this.isBlank() ? NodeSet.this.acceptNode(entry) : nodesSelector.acceptNode(entry);
            }
        };
    }

    public NodesSelector nodeSelectorWithDefaultAll() {
        return new NodesSelector(){

            public boolean acceptNode(INodeEntry entry) {
                return NodeSet.this.isBlank() || NodeSet.this.acceptNode(entry);
            }
        };
    }

    public boolean isBlank() {
        return !(null != this.getInclude() && !this.getInclude().isBlank() || null != this.getExclude() && !this.getExclude().isBlank() || null != this.getSingleNodeName());
    }

    public Include createInclude() {
        if (null != this.includes) {
            throw new BuildException("only one include is allowed");
        }
        this.includes = new Include();
        return this.includes;
    }

    public Exclude createExclude() throws BuildException {
        if (null != this.excludes) {
            throw new BuildException("only one exclude is allowed");
        }
        this.excludes = new Exclude();
        return this.excludes;
    }

    public Include getInclude() throws BuildException {
        return this.includes;
    }

    public Exclude getExclude() {
        return this.excludes;
    }

    public boolean shouldExclude(INodeEntry entry) {
        boolean excludesMatch;
        if (null != this.getSingleNodeName()) {
            return !this.getSingleNodeName().equals(entry.getNodename());
        }
        boolean includesMatch = this.includes != null ? this.includes.matches(entry) : false;
        boolean bl = excludesMatch = this.excludes != null ? this.excludes.matches(entry) : false;
        if (null == this.excludes || this.excludes.isBlank()) {
            return !includesMatch;
        }
        if (null == this.includes || this.includes.isBlank()) {
            return excludesMatch;
        }
        if (null != this.includes && this.includes.isDominant()) {
            return !includesMatch && excludesMatch;
        }
        return !includesMatch || excludesMatch;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public boolean isKeepgoing() {
        return this.keepgoing;
    }

    public void setKeepgoing(boolean keepgoing) {
        this.keepgoing = keepgoing;
    }

    public void validate() {
        if (null != this.failedNodesfile && this.failedNodesfile.getName().startsWith("${") && this.failedNodesfile.getName().endsWith("}")) {
            this.failedNodesfile = null;
        }
    }

    protected static boolean matchesInput(String inputSelector, String propValue) {
        if (null == propValue || "".equals(propValue.trim())) {
            return false;
        }
        if (null == inputSelector || "".equals(inputSelector.trim())) {
            return false;
        }
        List<String> list = Arrays.asList(inputSelector.split(","));
        return NodeSet.matchRegexOrEquals(inputSelector, propValue) || list.contains(propValue);
    }

    protected static boolean matchesInput(Map<String, String> attrSelectors, Map<String, String> values, boolean matchAll) {
        if (null == attrSelectors || null == values) {
            return false;
        }
        for (Map.Entry<String, String> entry : attrSelectors.entrySet()) {
            boolean match = NodeSet.matchesInput(entry.getValue(), values.get(entry.getKey()));
            if (!match && matchAll) {
                return false;
            }
            if (!match || matchAll) continue;
            return true;
        }
        return matchAll;
    }

    static boolean matchesInputSet(String inputSelector, Collection propSet) {
        if (null == propSet || propSet.size() < 1) {
            return false;
        }
        if (null == inputSelector || "".equals(inputSelector.trim())) {
            return false;
        }
        if (inputSelector.indexOf("+") >= 0 || inputSelector.indexOf(",") >= 0) {
            HashSet<String> orSet = new HashSet<String>();
            orSet.addAll(Arrays.asList(inputSelector.split(",")));
            for (String clause : orSet) {
                HashSet<String> set = new HashSet<String>();
                set.addAll(Arrays.asList(clause.split("\\+")));
                boolean found = true;
                for (String tag : set) {
                    if (propSet.contains(tag.trim())) continue;
                    boolean rematch = false;
                    for (String item : propSet) {
                        if (!NodeSet.matchRegexOrEquals(tag, item)) continue;
                        rematch = true;
                        break;
                    }
                    if (rematch) continue;
                    found = false;
                }
                if (!found) continue;
                return true;
            }
            return false;
        }
        boolean contain = propSet.contains(inputSelector);
        boolean rematch = false;
        for (String item : propSet) {
            if (!NodeSet.matchRegexOrEquals(inputSelector, item)) continue;
            rematch = true;
            break;
        }
        return rematch || contain;
    }

    public static boolean matchRegexOrEquals(String inputSelector, String item) {
        String testregex = inputSelector;
        if (testregex.length() >= 2 && testregex.indexOf(47) == 0 && testregex.lastIndexOf(47) == testregex.length() - 1) {
            testregex = inputSelector.substring(1, inputSelector.length() - 1);
            return item.matches(testregex.trim());
        }
        boolean match = false;
        try {
            match = item.matches(inputSelector.trim());
        }
        catch (PatternSyntaxException e) {
            // empty catch block
        }
        return match || inputSelector.trim().equals(item);
    }

    public Exclude createExclude(Map excludeMap) {
        Exclude exclude = this.createExclude();
        this.populateSetSelector(excludeMap, exclude);
        return exclude;
    }

    public Include createInclude(Map includeMap) {
        Include include = this.createInclude();
        this.populateSetSelector(includeMap, include);
        return include;
    }

    public SetSelector populateSetSelector(Map map, SetSelector setselector) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        Iterator i$ = map.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = i$.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (HOSTNAME.equals(key)) {
                setselector.setHostname(value);
                continue;
            }
            if (OS_FAMILY.equals(key)) {
                setselector.setOsfamily(value);
                continue;
            }
            if (OS_ARCH.equals(key)) {
                setselector.setOsarch(value);
                continue;
            }
            if (OS_NAME.equals(key)) {
                setselector.setOsname(value);
                continue;
            }
            if (OS_VERSION.equals(key)) {
                setselector.setOsversion(value);
                continue;
            }
            if (NAME.equals(key)) {
                setselector.setName(value);
                continue;
            }
            if (TAGS.equals(key)) {
                setselector.setTags(value);
                continue;
            }
            attrs.put(key, value);
        }
        setselector.setAttributesMap(attrs);
        return setselector;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeSet nodeSet = (NodeSet)o;
        if (this.keepgoing != nodeSet.keepgoing) {
            return false;
        }
        if (this.threadCount != nodeSet.threadCount) {
            return false;
        }
        if (this.excludes != null ? !this.excludes.equals(nodeSet.excludes) : nodeSet.excludes != null) {
            return false;
        }
        if (this.includes != null ? !this.includes.equals(nodeSet.includes) : nodeSet.includes != null) {
            return false;
        }
        return !(this.singleNodeName != null ? !this.singleNodeName.equals(nodeSet.singleNodeName) : nodeSet.singleNodeName != null);
    }

    public int hashCode() {
        int result = this.singleNodeName != null ? this.singleNodeName.hashCode() : 0;
        result = 31 * result + (this.includes != null ? this.includes.hashCode() : 0);
        result = 31 * result + (this.excludes != null ? this.excludes.hashCode() : 0);
        result = 31 * result + this.threadCount;
        result = 31 * result + (this.keepgoing ? 1 : 0);
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("NodeSet{");
        if (null != this.excludes && !this.excludes.isBlank()) {
            builder.append("excludes=").append(this.excludes).append(", ");
        }
        if (null != this.includes && !this.includes.isBlank()) {
            builder.append("includes=").append(this.includes);
        }
        if (null != this.singleNodeName) {
            builder.append("singleNode=").append(this.singleNodeName);
        }
        builder.append("}");
        return builder.toString();
    }

    public File getFailedNodesfile() {
        return this.failedNodesfile;
    }

    public void setFailedNodesfile(File failedNodesfile) {
        this.failedNodesfile = failedNodesfile;
    }

    public static class AttributeSet {
        private String prefix;

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public String toString() {
            return "AttributeSet{prefix='" + this.prefix + '\'' + '}';
        }
    }

    public static class Attribute {
        private String name;
        private String value;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String toString() {
            return "Attribute{name='" + this.name + '\'' + ", value='" + this.value + '\'' + '}';
        }
    }

    public class Exclude
    extends SetSelector {
    }

    public class Include
    extends SetSelector {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class SetSelector {
        private boolean dominant = false;
        private String hostname = "";
        private String osfamily = "";
        private String osarch = "";
        private String osname = "";
        private String tags = "";
        private String osversion = "";
        private String name = "";
        private Collection<Attribute> attributes;
        private AttributeSet attributeSet;
        private Map<String, String> attributesMap;

        public void setHostname(String hostname) {
            this.hostname = hostname;
            this.attributes = new ArrayList<Attribute>();
        }

        public String getHostname() {
            return this.hostname;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("{");
            if (!this.isBlank(this.hostname)) {
                builder.append("hostname=").append(this.getHostname()).append(", ");
            }
            if (!this.isBlank(this.osfamily)) {
                builder.append("osfamily=").append(this.getOsfamily()).append(", ");
            }
            if (!this.isBlank(this.osarch)) {
                builder.append("osarch=").append(this.getOsarch()).append(", ");
            }
            if (!this.isBlank(this.osname)) {
                builder.append("osname=").append(this.getOsname()).append(", ");
            }
            if (!this.isBlank(this.osversion)) {
                builder.append("osversion=").append(this.getOsversion()).append(", ");
            }
            if (!this.isBlank(this.tags)) {
                builder.append("tags=").append(this.getTags()).append(", ");
            }
            if (!this.isBlank(this.name)) {
                builder.append("name=").append(this.getName()).append(", ");
            }
            builder.append("dominant=").append(this.isDominant()).append(", ");
            if (null != this.getAttributes() && this.getAttributes().size() > 0) {
                builder.append("attributes=").append(this.getAttributes()).append(", ");
            }
            if (null != this.getAttributeSet() && null != NodeSet.this.getProject()) {
                builder.append("attributeset=").append(this.getAttributeSet()).append(", ");
            }
            if (null != this.getAttributes() && this.getAttributes().size() > 0 || null != this.getAttributeSet() && null != NodeSet.this.getProject()) {
                builder.append("attributesMap=").append(this.getAttributesMap());
            }
            builder.append("}");
            return builder.toString();
        }

        public boolean isBlank(String value) {
            return null == value || "".equals(value.trim());
        }

        public boolean isBlank() {
            return this.isBlank(this.hostname) && this.isBlank(this.osfamily) && this.isBlank(this.osarch) && this.isBlank(this.osname) && this.isBlank(this.tags) && this.isBlank(this.osversion) && this.isBlank(this.name) && (null == this.attributes || 0 == this.attributes.size()) && this.isBlank(this.getAttributesMap());
        }

        public boolean isBlank(Map map) {
            return null == map || map.isEmpty();
        }

        public boolean matchOrBlank(Map<String, String> selector, Map<String, String> value) {
            return this.isBlank(selector) || NodeSet.matchesInput(selector, value, true);
        }

        public boolean matchOrBlank(String selector, String value) {
            return this.isBlank(selector) || NodeSet.matchesInput(selector, value);
        }

        public boolean matchOrBlank(String selector, Collection set) {
            return this.isBlank(selector) || NodeSet.matchesInputSet(selector, set);
        }

        public boolean matches(INodeEntry entry) {
            return !this.isBlank() && this.matchOrBlank(this.hostname, entry.getHostname()) && this.matchOrBlank(this.name, entry.getNodename()) && this.matchOrBlank(this.tags, entry.getTags()) && this.matchOrBlank(this.osfamily, entry.getOsFamily()) && this.matchOrBlank(this.osarch, entry.getOsArch()) && this.matchOrBlank(this.osname, entry.getOsName()) && this.matchOrBlank(this.osversion, entry.getOsVersion()) && this.matchOrBlank(this.getAttributesMap(), entry.getAttributes());
        }

        public String getOsfamily() {
            return this.osfamily;
        }

        public void setOsfamily(String osfamily) {
            this.osfamily = osfamily;
        }

        public String getOsarch() {
            return this.osarch;
        }

        public void setOsarch(String osarch) {
            this.osarch = osarch;
        }

        public String getOsname() {
            return this.osname;
        }

        public void setOsname(String osname) {
            this.osname = osname;
        }

        public String getTags() {
            return this.tags;
        }

        public void setTags(String tags) {
            this.tags = tags;
        }

        public String getOsversion() {
            return this.osversion;
        }

        public void setOsversion(String osversion) {
            this.osversion = osversion;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isDominant() {
            return this.dominant;
        }

        public void setDominant(boolean dominant) {
            this.dominant = dominant;
        }

        public Attribute createAttribute() {
            Attribute atr = new Attribute();
            if (null == this.attributes) {
                this.attributes = new ArrayList<Attribute>();
            }
            this.getAttributes().add(atr);
            return atr;
        }

        public Collection<Attribute> getAttributes() {
            return this.attributes;
        }

        public void setAttributes(Collection<Attribute> attributes) {
            this.attributes = attributes;
        }

        Map<String, String> getAttributesMap() {
            if (null == this.attributesMap) {
                HashMap<String, String> attrs = new HashMap<String, String>();
                if (null != this.attributes) {
                    for (Attribute a : this.attributes) {
                        attrs.put(a.getName(), a.getValue());
                    }
                }
                if (null != this.attributeSet && null != this.attributeSet.getPrefix() && null != NodeSet.this.getProject()) {
                    String prefix = this.attributeSet.getPrefix();
                    for (String key : NodeSet.this.getProject().getProperties().keySet()) {
                        if (!key.startsWith(prefix)) continue;
                        String subkey = key.substring(prefix.length());
                        attrs.put(subkey, NodeSet.this.getProject().getProperty(key));
                    }
                } else if (null != this.attributeSet && null == NodeSet.this.getProject()) {
                    NodeSet.this.log("Error: project is not set", 0);
                }
                this.attributesMap = attrs;
            }
            return this.attributesMap;
        }

        public AttributeSet createAttributeSet() {
            this.attributeSet = new AttributeSet();
            return this.attributeSet;
        }

        public AttributeSet getAttributeSet() {
            return this.attributeSet;
        }

        public void setAttributesMap(Map<String, String> attributesMap) {
            this.attributesMap = attributesMap;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SetSelector)) {
                return false;
            }
            SetSelector that = (SetSelector)o;
            if (this.dominant != that.dominant) {
                return false;
            }
            if (this.attributesMap != null ? !((Object)this.attributesMap).equals(that.attributesMap) : that.attributesMap != null) {
                return false;
            }
            if (this.hostname != null ? !this.hostname.equals(that.hostname) : that.hostname != null) {
                return false;
            }
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
                return false;
            }
            if (this.osarch != null ? !this.osarch.equals(that.osarch) : that.osarch != null) {
                return false;
            }
            if (this.osfamily != null ? !this.osfamily.equals(that.osfamily) : that.osfamily != null) {
                return false;
            }
            if (this.osname != null ? !this.osname.equals(that.osname) : that.osname != null) {
                return false;
            }
            if (this.osversion != null ? !this.osversion.equals(that.osversion) : that.osversion != null) {
                return false;
            }
            return !(this.tags != null ? !this.tags.equals(that.tags) : that.tags != null);
        }

        public int hashCode() {
            int result = this.dominant ? 1 : 0;
            result = 31 * result + (this.hostname != null ? this.hostname.hashCode() : 0);
            result = 31 * result + (this.osfamily != null ? this.osfamily.hashCode() : 0);
            result = 31 * result + (this.osarch != null ? this.osarch.hashCode() : 0);
            result = 31 * result + (this.osname != null ? this.osname.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.osversion != null ? this.osversion.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.attributesMap != null ? ((Object)this.attributesMap).hashCode() : 0);
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FILTER_ENUM {
        F_HOSTNAME("hostname"){

            public String value(SetSelector set) {
                return set.getHostname();
            }
        }
        ,
        F_NAME("name"){

            public String value(SetSelector set) {
                return set.getName();
            }
        }
        ,
        F_TAGS("tags"){

            public String value(SetSelector set) {
                return set.getTags();
            }
        }
        ,
        F_OS_NAME("os-name"){

            public String value(SetSelector set) {
                return set.getOsname();
            }
        }
        ,
        F_OS_FAMILY("os-family"){

            public String value(SetSelector set) {
                return set.getOsfamily();
            }
        }
        ,
        F_OS_ARCH("os-arch"){

            public String value(SetSelector set) {
                return set.getOsarch();
            }
        }
        ,
        F_OS_VERSION("os-version"){

            public String value(SetSelector set) {
                return set.getOsversion();
            }
        };

        private final String name;

        private FILTER_ENUM(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public abstract String value(SetSelector var1);
    }
}

