/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipUtil {
    public static void extractZip(String path, File dest) throws IOException {
        ZipUtil.extractZip(path, dest, null);
    }

    public static void extractZip(String path, File dest, String prefix) throws IOException {
        ZipUtil.extractZip(path, dest, prefix, null);
    }

    public static void extractZipFile(String path, File dest, final String fileName) throws IOException {
        FilenameFilter filter = null;
        if (null != fileName) {
            filter = new FilenameFilter(){

                public boolean accept(File file, String name) {
                    return fileName.equals(name) || fileName.startsWith(name);
                }
            };
        }
        ZipUtil.extractZip(path, dest, filter, null, null);
    }

    public static void extractZip(String path, File dest, String prefix, String stripPrefix) throws IOException {
        ZipUtil.extractZip(path, dest, prefix, stripPrefix, null);
    }

    public static void extractZip(String path, File dest, String prefix, String stripPrefix, streamCopier copier) throws IOException {
        ZipUtil.extractZip(path, dest, prefix, (renamer)new PrefixStripper(stripPrefix), copier);
    }

    public static void extractZip(String path, File dest, final String prefix, renamer rename, streamCopier copier) throws IOException {
        FilenameFilter filter = null;
        if (null != prefix) {
            filter = new FilenameFilter(){

                public boolean accept(File file, String name) {
                    return name.startsWith(prefix);
                }
            };
        }
        ZipUtil.extractZip(path, dest, filter, rename, copier);
    }

    public static void extractZip(String path, File dest, FilenameFilter filter, renamer rename, streamCopier copier) throws IOException {
        ZipFile jar = new ZipFile(path);
        Enumeration<? extends ZipEntry> enumeration = jar.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry entry = enumeration.nextElement();
            if (null != filter && !filter.accept(dest, entry.getName())) continue;
            String name = entry.getName();
            if (null != rename) {
                name = rename.rename(name);
            }
            File destFile = new File(dest, name);
            if (entry.isDirectory() && !destFile.isDirectory()) {
                if (destFile.mkdirs()) continue;
                throw new IOException("Unable to make directory: " + destFile);
            }
            if (entry.isDirectory()) continue;
            if (!destFile.exists()) {
                File parent = destFile.getParentFile();
                if (!parent.exists() && !parent.mkdirs()) {
                    throw new IOException("Unable to create parent dir for file: " + destFile.getAbsolutePath());
                }
                if (!destFile.createNewFile()) {
                    throw new IOException("Unable to create file: " + destFile.getAbsolutePath());
                }
            }
            if (null != copier) {
                copier.copyStream(jar.getInputStream(entry), new FileOutputStream(destFile));
                continue;
            }
            ZipUtil.copyStream(jar.getInputStream(entry), new FileOutputStream(destFile));
        }
    }

    public static void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int c;
        byte[] buffer = new byte[4096];
        while (-1 != (c = inputStream.read(buffer))) {
            outputStream.write(buffer, 0, c);
        }
    }

    public static class CopyStreamCopier
    implements streamCopier {
        public void copyStream(InputStream in, OutputStream out) throws IOException {
            ZipUtil.copyStream(in, out);
        }
    }

    public static interface streamCopier {
        public void copyStream(InputStream var1, OutputStream var2) throws IOException;
    }

    public static class PrefixStripper
    implements renamer {
        String prefix;

        public PrefixStripper(String prefix) {
            this.prefix = prefix;
        }

        public String rename(String name) {
            if (null != this.prefix && name.startsWith(this.prefix)) {
                return name.substring(this.prefix.length());
            }
            return name;
        }
    }

    public static interface renamer {
        public String rename(String var1);
    }
}

