/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.utils.cache;

import java.io.File;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileCache<T extends Cacheable> {
    private HashMap<File, T> cache = new HashMap();
    private HashMap<File, Long> expiry = new HashMap();
    private final Expiration<T> expiration;

    public FileCache() {
        this(new LastModifiedExpiration());
    }

    public FileCache(Expiration<T> expiration) {
        this.expiration = expiration;
    }

    public synchronized void remove(File file) {
        Cacheable t = (Cacheable)this.cache.get(file);
        this.expiry.remove(file);
        this.cache.remove(file);
        if (null != t && t instanceof Expireable) {
            Expireable exp = (Expireable)t;
            exp.expire();
        }
    }

    public synchronized T get(File file, ItemCreator<T> creator) {
        Cacheable entry;
        if (!file.exists()) {
            this.remove(file);
            return null;
        }
        long lastmod = file.lastModified();
        Long cachetime = this.expiry.get(file);
        Cacheable orig = (Cacheable)this.cache.get(file);
        if (null == cachetime || this.expiration.isExpired(file, cachetime, orig)) {
            entry = (Cacheable)creator.createCacheItemForFile(file);
            if (null == entry) {
                this.remove(file);
                return null;
            }
            if (null != orig && !entry.equals(orig)) {
                this.remove(file);
                this.cache.put(file, entry);
            } else if (null == orig) {
                this.cache.put(file, entry);
            }
            this.expiry.put(file, lastmod);
        } else {
            entry = (Cacheable)this.cache.get(file);
        }
        return (T)entry;
    }

    public static interface Expireable
    extends Cacheable {
        public void expire();
    }

    public static interface Cacheable {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LastModifiedExpiration<T>
    implements Expiration<T> {
        @Override
        public boolean isExpired(File file, Long cacheTime, T item) {
            return file.lastModified() > cacheTime;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Expiration<T> {
        public boolean isExpired(File var1, Long var2, T var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ItemCreator<T> {
        public T createCacheItemForFile(File var1);
    }
}

