/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.Predicate;

public abstract class Mapper {
    public static final Mapper toString = new Mapper(){

        public Object map(Object a) {
            return a == null ? null : a.toString();
        }
    };
    public static final Mapper identity = new Mapper(){

        public Object map(Object a) {
            return a;
        }
    };

    public static Comparator comparator(Mapper mapper) {
        return Mapper.comparator(mapper, false);
    }

    public static Comparator comparator(final Mapper mapper, final boolean reverse) {
        return new Comparator(){

            public int compare(Object o, Object o1) {
                return ((Comparable)mapper.map(reverse ? o1 : o)).compareTo(mapper.map(reverse ? o : o1));
            }
        };
    }

    public Mapper concat(Mapper mapper) {
        return Mapper.concat(this, mapper);
    }

    public static Mapper concat(Mapper[] arr) {
        return new ConcatMapper(arr);
    }

    public static Mapper concat(Mapper first, Mapper second) {
        return new ConcatMapper(new Mapper[]{first, second});
    }

    public static Map zip(List keys, List values) {
        return Mapper.zip(keys, values, false);
    }

    public static Map zip(List keys, List values, boolean includeNull) {
        Iterator k = keys.iterator();
        Iterator v = values.iterator();
        HashMap hm = new HashMap();
        while (k.hasNext() && v.hasNext()) {
            Object o = k.next();
            Object p = v.next();
            if (!includeNull && (o == null || p == null)) continue;
            hm.put(o, p);
        }
        return hm;
    }

    public static Map zip(Object[] keys, Object[] values) {
        return Mapper.zip(Arrays.asList(keys), Arrays.asList(values), false);
    }

    public static Map zip(Object[] keys, Object[] values, boolean includeNull) {
        return Mapper.zip(Arrays.asList(keys), Arrays.asList(values), includeNull);
    }

    public static Map zip(Iterator keys, Iterator values) {
        return Mapper.zip(keys, values, false);
    }

    public static Map zip(Iterator keys, Iterator values, boolean includeNull) {
        HashMap hm = new HashMap();
        while (keys.hasNext() && values.hasNext()) {
            Object o = keys.next();
            Object p = values.next();
            if (!includeNull && (o == null || p == null)) continue;
            hm.put(o, p);
        }
        return hm;
    }

    public static Collection map(Mapper mapper, Object o) {
        return Collections.singleton(mapper.map(o));
    }

    public static Collection map(Mapper mapper, Collection c) {
        return Mapper.map(mapper, c, false);
    }

    public Collection apply(Collection c) {
        return Mapper.map(this, c);
    }

    public static Collection map(Mapper mapper, Collection c, boolean allowNull) {
        return Mapper.map(mapper, c.iterator(), allowNull);
    }

    public static Collection map(Mapper mapper, Object[] arr) {
        return Mapper.map(mapper, arr, false);
    }

    public Collection apply(Object[] arr) {
        return Mapper.map(this, arr);
    }

    public static Collection map(Mapper mapper, Object[] arr, boolean allowNull) {
        return Mapper.map(mapper, Arrays.asList(arr), allowNull);
    }

    public static Collection map(Mapper mapper, Enumeration en) {
        return Mapper.map(mapper, en, false);
    }

    public Collection apply(Enumeration en) {
        return Mapper.map(this, en);
    }

    public static Collection map(Mapper mapper, Enumeration en, boolean allowNull) {
        ArrayList<Object> l = new ArrayList<Object>();
        while (en.hasMoreElements()) {
            Object o = mapper.map(en.nextElement());
            if (!allowNull && o == null) continue;
            l.add(o);
        }
        return l;
    }

    public static Map mapKeys(Mapper mapper, Map map) {
        return Mapper.mapKeys(mapper, map, false);
    }

    public Map applyToKeys(Map map) {
        return Mapper.mapKeys(this, map);
    }

    public static Map mapKeys(Mapper mapper, Map map, boolean allowNull) {
        HashMap h = new HashMap();
        Iterator i$ = map.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry e;
            Map.Entry entry = e = i$.next();
            Object o = mapper.map(entry.getKey());
            if (!allowNull && o == null) continue;
            h.put(o, entry.getValue());
        }
        return h;
    }

    public static Map mapValues(Mapper mapper, Map map) {
        return Mapper.mapValues(mapper, map, false);
    }

    public Map applyToValues(Map map) {
        return Mapper.mapValues(this, map);
    }

    public static Map mapValues(Mapper mapper, Map map, boolean includeNull) {
        HashMap h = new HashMap();
        for (Object e : map.keySet()) {
            Map.Entry entry = (Map.Entry)e;
            Object v = entry.getValue();
            Object o = mapper.map(v);
            if (!includeNull && o == null) continue;
            h.put(entry.getKey(), o);
        }
        return h;
    }

    public static Map mapEntries(Mapper mapper, Map map) {
        return Mapper.mapEntries(mapper, map, false);
    }

    public Map applyToEntries(Map map) {
        return Mapper.mapEntries(this, map);
    }

    public static Map mapEntries(Mapper mapper, Map map, boolean includeNull) {
        HashMap<Object, Object> h = new HashMap<Object, Object>();
        Iterator i$ = map.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry e;
            Map.Entry entry = e = i$.next();
            Object k = entry.getKey();
            Object v = entry.getValue();
            Object nk = mapper.map(k);
            Object o = mapper.map(v);
            if (!includeNull && (o == null || nk == null)) continue;
            h.put(nk, o);
        }
        return h;
    }

    public static Map makeMap(Mapper mapper, Object[] a) {
        return Mapper.makeMap(mapper, Arrays.asList(a), false);
    }

    public Map makeMap(Object[] a) {
        return Mapper.makeMap(this, a);
    }

    public static Map makeMap(Mapper mapper, Object[] a, boolean includeNull) {
        return Mapper.makeMap(mapper, Arrays.asList(a), includeNull);
    }

    public static Map makeMap(Mapper mapper, Collection c) {
        return Mapper.makeMap(mapper, c.iterator(), false);
    }

    public Map makeMap(Collection c) {
        return Mapper.makeMap(this, c);
    }

    public static Map makeMap(Mapper mapper, Collection c, boolean includeNull) {
        return Mapper.makeMap(mapper, c.iterator(), includeNull);
    }

    public static Map makeMap(Mapper mapper, Iterator i) {
        return Mapper.makeMap(mapper, i, false);
    }

    public Map makeMap(Iterator i) {
        return Mapper.makeMap(this, i);
    }

    public static Map makeMap(Mapper mapper, Iterator i, boolean includeNull) {
        HashMap h = new HashMap();
        while (i.hasNext()) {
            Object k = i.next();
            Object v = mapper.map(k);
            if (!includeNull && v == null) continue;
            h.put(k, v);
        }
        return h;
    }

    public static Map makeMap(Mapper mapper, Enumeration en) {
        return Mapper.makeMap(mapper, en, false);
    }

    public Map makeMap(Enumeration en) {
        return Mapper.makeMap(this, en);
    }

    public static Map makeMap(Mapper mapper, Enumeration en, boolean includeNull) {
        HashMap h = new HashMap();
        while (en.hasMoreElements()) {
            Object k = en.nextElement();
            Object v = mapper.map(k);
            if (!includeNull && v == null) continue;
            h.put(k, v);
        }
        return h;
    }

    public static Collection map(Mapper mapper, Iterator i) {
        return Mapper.map(mapper, i, false);
    }

    public Collection apply(Iterator i) {
        return Mapper.map(this, i);
    }

    public static Collection map(Mapper mapper, Iterator i, boolean includeNull) {
        ArrayList<Object> l = new ArrayList<Object>();
        while (i.hasNext()) {
            Object o = mapper.map(i.next());
            if (!includeNull && o == null) continue;
            l.add(o);
        }
        return l;
    }

    public static Collection beanMap(String property, Object[] objs) {
        return Mapper.beanMap(property, Arrays.asList(objs), false);
    }

    public static Collection beanMap(String property, Iterator i) {
        return Mapper.beanMap(property, i, false);
    }

    public static Collection beanMap(String property, Collection c, boolean includeNull) {
        return Mapper.beanMap(property, c.iterator(), includeNull);
    }

    public static Collection beanMap(String property, Collection c) {
        return Mapper.beanMap(property, c.iterator(), false);
    }

    public static Mapper beanMapper(final String property) {
        return new Mapper(){

            public Object map(Object a) {
                try {
                    return BeanUtils.getProperty((Object)a, (String)property);
                }
                catch (Exception e) {
                    throw new ClassCastException("Object was not the expected class: " + a.getClass());
                }
            }
        };
    }

    public static Collection beanMap(String property, Iterator i, boolean includeNull) {
        return Mapper.map(Mapper.beanMapper(property), i, includeNull);
    }

    public static Mapper filterMapper(final Predicate pred) {
        return new Mapper(){

            public Object map(Object a) {
                return pred.evaluate(a) ? a : null;
            }
        };
    }

    public static Mapper uniqueMapper() {
        return new Mapper(){
            HashSet set = new HashSet();

            public Object map(Object a) {
                if (this.set.contains(a)) {
                    return null;
                }
                this.set.add(a);
                return a;
            }
        };
    }

    public static Mapper mapMapper(final Map map) {
        return new Mapper(){

            public Object map(Object a) {
                return map.get(a);
            }
        };
    }

    public abstract Object map(Object var1);

    private static class ConcatMapper
    extends Mapper {
        private Mapper[] arr;

        ConcatMapper(Mapper[] maps) {
            this.arr = maps;
        }

        public Object map(Object a) {
            Object b = a;
            if (b == null) {
                return null;
            }
            if (null != this.arr) {
                for (int i = 0; i < this.arr.length; ++i) {
                    if (null == this.arr[i] || (b = this.arr[i].map(b)) != null) continue;
                    return null;
                }
            }
            return b;
        }

        public Mapper concat(Mapper mapper) {
            if (this.arr != null) {
                Mapper[] l = new Mapper[this.arr.length + 1];
                System.arraycopy(this.arr, 0, l, 0, this.arr.length);
                l[this.arr.length] = mapper;
                return new ConcatMapper(l);
            }
            return new ConcatMapper(new Mapper[]{mapper});
        }
    }
}

