/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;

public class PropertiesUtil {
    public static String stringFromProperties(Properties props) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
        props.store(baos, null);
        String propsString = URLEncoder.encode(baos.toString("ISO-8859-1"), "ISO-8859-1");
        return propsString;
    }

    public static Properties propertiesFromString(String propString) throws IOException {
        Properties props = new Properties();
        String pstring = URLDecoder.decode(propString, "ISO-8859-1");
        props.load(new ByteArrayInputStream(pstring.getBytes()));
        return props;
    }

    public static Collection listPropertiesWithPrefix(Properties props, String prefix) {
        HashSet<String> set = new HashSet<String>();
        for (String string : props.keySet()) {
            if (!string.startsWith(prefix)) continue;
            set.add(props.getProperty(string));
        }
        return set;
    }

    public static class PrefixAdder
    implements Adder {
        private String prefix;
        private Properties props;

        public PrefixAdder(Properties props, String prefix) {
            this.prefix = prefix;
            this.props = props;
        }

        public void addProperty(String name, String value) {
            this.props.put(this.prefix + name, value);
        }

        public void addProperties(Properties properties) {
            for (String string : properties.keySet()) {
                String value = properties.getProperty(string);
                this.addProperty(string, value);
            }
        }

        public Adder withPrefix(String prefix) {
            return new PrefixAdder(this.props, this.prefix + prefix);
        }
    }

    public static class PrefixProducer
    implements Producer {
        private String prefix;
        private Properties props;

        public PrefixProducer(Properties props, String prefix) {
            this.prefix = prefix;
            this.props = props;
        }

        public Properties readProperties() {
            Properties newprops = new Properties();
            for (String string : this.props.keySet()) {
                if (!string.startsWith(this.prefix)) continue;
                String newkey = string.substring(this.prefix.length());
                newprops.setProperty(newkey, this.props.getProperty(string));
            }
            return newprops;
        }
    }

    public static interface Producer {
        public Properties readProperties();
    }

    public static interface Adder {
        public void addProperty(String var1, String var2);

        public void addProperties(Properties var1);
    }
}

