/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.client.utils;

import com.dtolabs.client.utils.BasicAuthenticator;
import com.dtolabs.client.utils.ClientState;
import com.dtolabs.client.utils.HttpAuthenticator;
import com.dtolabs.client.utils.HttpClientException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.cookie.CookiePolicy;
import org.apache.commons.httpclient.cookie.CookieSpec;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.log4j.Logger;

public abstract class BaseFormAuthenticator
implements HttpAuthenticator {
    public static final Logger logger = Logger.getLogger(BaseFormAuthenticator.class);
    public static final String J_SECURITY_CHECK = "j_security_check";
    public static final String JAVA_AUTH_PATH = "/j_security_check";
    public static final String JAVA_USER_PARAM = "j_username";
    public static final String JAVA_PASS_PARAM = "j_password";
    public static final String JAVA_SESSION_COOKIE_NAME = "JSESSIONID";
    public static final Pattern JAVA_SESSION_COOKIE_PATTERN = Pattern.compile("^JSESSIONID$");
    public static final String HTTP_SECURE_PROTOCOL = "https";
    public static final String LOGIN_PAGE = "/user/login";
    private String username;
    private String password;
    private String basePath;
    private String cookieId;

    public BaseFormAuthenticator(String basePath, String username, String password) {
        this.basePath = basePath;
        this.username = username;
        this.password = password;
    }

    abstract String getInitialPath();

    abstract boolean isValidLoginRedirect(HttpMethod var1);

    abstract boolean isLoginError(HttpMethod var1);

    abstract boolean isFollowLoginRedirect();

    @Override
    public boolean authenticate(URL baseURL, HttpClient client) throws HttpClientException {
        HttpState state = client.getState();
        if (BaseFormAuthenticator.hasSessionCookie(baseURL, state, this.basePath)) {
            return true;
        }
        byte[] buffer = new byte[1024];
        boolean doPostLogin = false;
        boolean isLoginFormContent = false;
        logger.debug((Object)"No session found, must login...");
        try {
            URL newUrl = new URL(baseURL.getProtocol(), baseURL.getHost(), baseURL.getPort(), this.basePath + this.getInitialPath());
            GetMethod get = new GetMethod(newUrl.toExternalForm());
            get.setDoAuthentication(false);
            get.setFollowRedirects(false);
            logger.debug((Object)("Requesting: " + newUrl));
            int res = client.executeMethod((HttpMethod)get);
            logger.debug((Object)("Result is: " + res));
            String body = get.getResponseBodyAsString();
            if (null != body && body.contains(J_SECURITY_CHECK) && body.contains(JAVA_USER_PARAM) && body.contains(JAVA_PASS_PARAM)) {
                isLoginFormContent = true;
            }
            get.releaseConnection();
            if (res == 401) {
                if (get.getResponseHeader("WWW-Authenticate") != null && get.getResponseHeader("WWW-Authenticate").getValue().matches("^Basic.*")) {
                    logger.warn((Object)"Form-based login received UNAUTHORIZED, trying to use Basic authentication");
                    BasicAuthenticator auth = new BasicAuthenticator(this.username, this.password);
                    return auth.authenticate(baseURL, client);
                }
                throw new HttpClientException("Form-based login received UNAUTHORIZED, but didn't recognize it as Basic authentication: unable to get a session");
            }
            if (!BaseFormAuthenticator.hasSessionCookie(baseURL, state, this.basePath)) {
                throw new HttpClientException("Unable to get a session from URL : " + newUrl);
            }
            if (res == 200 && isLoginFormContent) {
                doPostLogin = true;
            } else if (res == 302 || res == 301 || res == 303 || res == 307) {
                Header locHeader = get.getResponseHeader("Location");
                if (locHeader == null) {
                    throw new HttpClientException("Redirect with no Location header, request URL: " + newUrl);
                }
                String location = locHeader.getValue();
                if (!this.isValidLoginRedirect((HttpMethod)get)) {
                    throw new HttpClientException("Unexpected redirection when getting session: " + location);
                }
                logger.debug((Object)("Follow redirect: " + res + ": " + location));
                GetMethod redir = new GetMethod(location);
                redir.setFollowRedirects(true);
                res = client.executeMethod((HttpMethod)redir);
                InputStream ins = redir.getResponseBodyAsStream();
                while (ins.available() > 0) {
                    ins.read(buffer);
                }
                redir.releaseConnection();
                if (res != 200) {
                    throw new HttpClientException("Login page status was not OK: " + res);
                }
                logger.debug((Object)("Result: " + res));
                doPostLogin = true;
            } else if (res != 200) {
                throw new HttpClientException("Request to welcome page returned error: " + res + ": " + get);
            }
            if (doPostLogin) {
                String location;
                URL loginUrl = new URL(baseURL.getProtocol(), baseURL.getHost(), baseURL.getPort(), this.basePath + JAVA_AUTH_PATH);
                PostMethod login = new PostMethod(loginUrl.toExternalForm());
                login.setRequestBody(new NameValuePair[]{new NameValuePair(JAVA_USER_PARAM, this.getUsername()), new NameValuePair(JAVA_PASS_PARAM, this.getPassword())});
                login.setFollowRedirects(false);
                logger.debug((Object)("Post login info to URL: " + loginUrl));
                res = client.executeMethod((HttpMethod)login);
                InputStream ins = login.getResponseBodyAsStream();
                while (ins.available() > 0) {
                    ins.read(buffer);
                }
                login.releaseConnection();
                Header locHeader = login.getResponseHeader("Location");
                String string = location = null != locHeader ? locHeader.getValue() : null;
                if (this.isLoginError((HttpMethod)login)) {
                    logger.error((Object)"Form-based auth failed");
                    return false;
                }
                if (null != location && !location.equals(newUrl.toExternalForm())) {
                    logger.warn((Object)"Form-based auth succeeded, but last URL was unexpected");
                }
                if (this.isFollowLoginRedirect() && (res == 302 || res == 301 || res == 303 || res == 307)) {
                    if (location == null) {
                        throw new HttpClientException("Redirect with no Location header, request URL: " + newUrl);
                    }
                    GetMethod get2 = new GetMethod(location);
                    res = client.executeMethod((HttpMethod)get2);
                } else if (res != 200) {
                    throw new HttpClientException("Login didn't seem to work: " + res + ": " + login.getResponseBodyAsString());
                }
                logger.debug((Object)("Result: " + res));
            }
        }
        catch (MalformedURLException e) {
            throw new HttpClientException("Bad URL", e);
        }
        catch (HttpException e) {
            throw new HttpClientException("HTTP Error: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new HttpClientException("Error occurred while trying to authenticate to server: " + e.getMessage(), e);
        }
        return true;
    }

    public static boolean hasSessionCookie(URL reqUrl, HttpState state, String basePath) {
        CookieSpec cookiespec = CookiePolicy.getDefaultSpec();
        Cookie[] initcookies = cookiespec.match(reqUrl.getHost(), reqUrl.getPort() > 0 ? reqUrl.getPort() : 80, basePath.endsWith("/") ? basePath : basePath + "/", HTTP_SECURE_PROTOCOL.equalsIgnoreCase(reqUrl.getProtocol()), state.getCookies());
        boolean hasSession = false;
        if (initcookies.length == 0) {
            hasSession = false;
        } else {
            for (Cookie cookie : initcookies) {
                if (!JAVA_SESSION_COOKIE_NAME.equals(cookie.getName()) && !JAVA_SESSION_COOKIE_PATTERN.matcher(cookie.getName()).matches()) continue;
                logger.debug((Object)("Saw session cookie: " + cookie.getName()));
                hasSession = true;
                break;
            }
        }
        return hasSession;
    }

    @Override
    public boolean needsReAuthentication(int resultCode, HttpMethod method) {
        if (resultCode >= 300 && resultCode < 400 && method.getResponseHeader("Location") != null) {
            String loc = method.getResponseHeader("Location").getValue();
            int logNdx = loc.indexOf(LOGIN_PAGE);
            int qNdx = loc.indexOf("?");
            if (logNdx >= 0 && (qNdx < 0 || logNdx < qNdx)) {
                ClientState.resetHttpState();
                return true;
            }
        } else if (200 == resultCode) {
            String loc = method.getPath();
            int logNdx = loc.indexOf(LOGIN_PAGE);
            int qNdx = loc.indexOf("?");
            if (logNdx >= 0 && (qNdx < 0 || logNdx < qNdx)) {
                ClientState.resetHttpState();
                return true;
            }
        }
        return false;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    private String getPassword() {
        return this.password;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public String getCookieId() {
        return this.cookieId;
    }

    public void setCookieId(String cookieId) {
        this.cookieId = cookieId;
    }
}

