/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.authorization;

import com.dtolabs.rundeck.core.authorization.Attribute;
import com.dtolabs.rundeck.core.authorization.Authorization;
import com.dtolabs.rundeck.core.authorization.AuthorizationException;
import com.dtolabs.rundeck.core.authorization.Decision;
import com.dtolabs.rundeck.core.authorization.Explanation;
import com.dtolabs.rundeck.core.authorization.LegacyAuthorization;
import com.dtolabs.rundeck.core.common.Framework;
import java.io.File;
import java.io.PrintStream;
import java.security.Principal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.log4j.Logger;

public abstract class BaseAuthorization
implements Authorization,
LegacyAuthorization {
    final Framework framework;
    final File baseDir;
    final Explanation explanation = new Explanation(){

        public String toString() {
            return "\t" + BaseAuthorization.this.getDescription() + " => " + (Object)((Object)this.getCode());
        }

        @Override
        public void describe(PrintStream out) {
            out.println(this.toString());
        }

        @Override
        public Explanation.Code getCode() {
            return BaseAuthorization.this.getResultCode();
        }
    };

    protected abstract Logger getLogger();

    protected abstract String getDescription();

    protected abstract Explanation.Code getResultCode();

    protected abstract boolean isAuthorized();

    public BaseAuthorization(Framework framework, File aclBaseDir) {
        this.framework = framework;
        this.baseDir = aclBaseDir;
    }

    @Override
    public String[] getMatchedRoles() {
        return new String[0];
    }

    @Override
    public String listMatchedRoles() {
        return "";
    }

    @Override
    public boolean authorizeScript(String user, String project, String adhocScript) throws AuthorizationException {
        return this.isAuthorized();
    }

    @Override
    public Decision evaluate(Map<String, String> resource, Subject subject, String action, Set<Attribute> environment) {
        BaseAuthorizationDecision decision = new BaseAuthorizationDecision(resource, action, environment, subject);
        StringBuilder sb = new StringBuilder();
        sb.append("Evaluating ").append(decision).append(" (").append(decision.evaluationDuration()).append("ms)").append(':');
        sb.append(decision.explain().toString());
        this.getLogger().info((Object)sb.toString());
        return decision;
    }

    @Override
    public Set<Decision> evaluate(Set<Map<String, String>> resources, Subject subject, Set<String> actions, Set<Attribute> environment) {
        HashSet<Decision> decisions = new HashSet<Decision>();
        for (Map<String, String> resource : resources) {
            for (String action : actions) {
                decisions.add(new BaseAuthorizationDecision(resource, action, environment, subject));
            }
        }
        for (Decision decision : decisions) {
            StringBuilder sb = new StringBuilder();
            sb.append("Evaluating ").append(decision).append(" (").append(decision.evaluationDuration()).append("ms)").append(':');
            sb.append(decision.explain().toString());
            this.getLogger().info((Object)sb.toString());
        }
        return decisions;
    }

    final class BaseAuthorizationDecision
    implements Decision {
        Map<String, String> resource;
        String action;
        Set<Attribute> environment;
        Subject subject;

        BaseAuthorizationDecision(Map<String, String> resource, String action, Set<Attribute> environment, Subject subject) {
            this.resource = resource;
            this.action = action;
            this.environment = environment;
            this.subject = subject;
        }

        @Override
        public boolean isAuthorized() {
            return BaseAuthorization.this.isAuthorized();
        }

        @Override
        public Map<String, String> getResource() {
            return this.resource;
        }

        @Override
        public String getAction() {
            return this.action;
        }

        @Override
        public Set<Attribute> getEnvironment() {
            return this.environment;
        }

        @Override
        public Subject getSubject() {
            return this.subject;
        }

        @Override
        public Explanation explain() {
            return BaseAuthorization.this.explanation;
        }

        @Override
        public long evaluationDuration() {
            return 0L;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Decision for: ");
            builder.append("res<");
            Iterator<Map.Entry<String, String>> riter = this.resource.entrySet().iterator();
            while (riter.hasNext()) {
                Map.Entry<String, String> s = riter.next();
                builder.append(s.getKey()).append(':').append(s.getValue());
                if (!riter.hasNext()) continue;
                builder.append(", ");
            }
            builder.append("> subject<");
            Iterator<Principal> iter = this.subject.getPrincipals().iterator();
            while (iter.hasNext()) {
                Principal principal = iter.next();
                builder.append(principal.getClass().getSimpleName());
                builder.append(':');
                builder.append(principal.getName());
                if (!iter.hasNext()) continue;
                builder.append(' ');
            }
            builder.append("> action<");
            builder.append(this.action);
            builder.append("> env<");
            Iterator<Attribute> eiter = this.environment.iterator();
            while (eiter.hasNext()) {
                Attribute a = eiter.next();
                builder.append(a);
                if (!eiter.hasNext()) continue;
                builder.append(", ");
            }
            builder.append(">");
            builder.append(": authorized: ");
            builder.append(this.isAuthorized());
            builder.append(": ");
            builder.append(BaseAuthorization.this.explanation.toString());
            return builder.toString();
        }
    }
}

