/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.authorization;

import com.dtolabs.rundeck.core.Constants;
import com.dtolabs.rundeck.core.authentication.Group;
import com.dtolabs.rundeck.core.authentication.Username;
import com.dtolabs.rundeck.core.authorization.Attribute;
import com.dtolabs.rundeck.core.authorization.BaseAclsAuthorization;
import com.dtolabs.rundeck.core.authorization.Decision;
import com.dtolabs.rundeck.core.authorization.providers.PoliciesParseException;
import com.dtolabs.rundeck.core.common.Framework;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;

public class CheckAuth {
    public static void main(String ... args) throws IOException, PoliciesParseException {
        System.out.println("Press enter to continue:");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        while (null != bufferedReader.readLine()) {
            System.out.println("Doing test...");
            CheckAuth.doTest(args);
        }
    }

    public static void doTest(String ... args) throws IOException, PoliciesParseException {
        int i = 0;
        String rdeckbase = args[i++];
        String projectName = args[i++];
        String user = args[i++];
        String[] roles = args[i++].split(",\\s*");
        Framework framework = CheckAuth.buildFramework(rdeckbase);
        SingleUserAclsAuthorization singleUserAclsAuthorization = new SingleUserAclsAuthorization(framework, new File(Constants.getFrameworkConfigDir(rdeckbase)), rdeckbase, roles);
        String[] actions = args[i++].split(",\\s*");
        HashSet<String> actionSet = new HashSet<String>(Arrays.asList(actions));
        HashMap<String, String> resmap = new HashMap<String, String>();
        String param = null;
        while (i < args.length) {
            String[] z = args[i].split("=", 2);
            if (z.length > 1) {
                resmap.put(z[0], z[1]);
                if (z[1].contains("#")) {
                    param = z[0];
                }
            }
            ++i;
        }
        HashSet<Map<String, String>> resmapset = new HashSet<Map<String, String>>();
        int max = 200;
        if (param != null) {
            String value = ((String)resmap.get(param)).split("#", 2)[1];
            max = Integer.parseInt(value);
            for (int x = 1; x <= max; ++x) {
                HashMap<String, String> resmap2 = new HashMap<String, String>(resmap);
                String newval = ((String)resmap2.get(param)).replaceAll("#\\d+", Integer.toString(x));
                resmap2.put(param, newval);
                resmapset.add(resmap2);
            }
        } else {
            resmapset.add(resmap);
        }
        Set<Attribute> attributes = projectName.equalsIgnoreCase("--application") ? Collections.singleton(new Attribute(URI.create("http://dtolabs.com/rundeck/env/application"), "rundeck")) : Collections.singleton(new Attribute(URI.create("http://dtolabs.com/rundeck/env/project"), projectName));
        Subject subject = CheckAuth.createSubject(user, roles);
        long warmup = CheckAuth.timeCheck(singleUserAclsAuthorization, actionSet, resmapset, attributes, subject);
        System.out.println("warmup: " + warmup);
        long total = 0L;
        int testcount = 20;
        for (int x = 0; x < testcount; ++x) {
            total += CheckAuth.timeCheck(singleUserAclsAuthorization, actionSet, resmapset, attributes, subject);
        }
        System.out.println("Count(" + testcount + ") resMapsize(" + resmapset.size() + ") avg: " + total / (long)testcount);
    }

    private static long timeCheck(SingleUserAclsAuthorization singleUserAclsAuthorization, HashSet<String> actionSet, Set<Map<String, String>> resmapset, Set<Attribute> attributes, Subject subject) {
        Set<Decision> evaluate = null;
        long time0 = System.currentTimeMillis();
        long time = System.currentTimeMillis();
        evaluate = singleUserAclsAuthorization.evaluate(resmapset, subject, actionSet, attributes);
        long now = System.currentTimeMillis();
        long now0 = System.currentTimeMillis();
        long result = now0 - time0;
        return result;
    }

    private static Subject createSubject(String user, String[] rolelist) {
        Subject subject = new Subject();
        subject.getPrincipals().add(new Username(user));
        for (String s : rolelist) {
            subject.getPrincipals().add(new Group(s));
        }
        return subject;
    }

    private static Framework buildFramework(String rdeckbase) {
        return Framework.getInstance(rdeckbase);
    }

    public static class SingleUserAclsAuthorization
    extends BaseAclsAuthorization {
        private String username;
        private String[] roles;

        public SingleUserAclsAuthorization(Framework framework, File basedir, String username, String[] roles) throws IOException, PoliciesParseException {
            super(framework, basedir);
            this.username = username;
            this.roles = roles;
        }

        @Override
        public String[] determineUserRoles(String user) {
            if (this.username.equals(user)) {
                return this.roles;
            }
            return new String[0];
        }
    }
}

