/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.common;

import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.common.INodeSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class AdditiveListNodeSet
implements INodeSet {
    List<INodeSet> nodeSetList = new ArrayList<INodeSet>();
    TreeSet<String> nodeNames = new TreeSet();
    HashMap<String, INodeSet> nodeIndex = new HashMap();

    public void addNodeSet(INodeSet nodeSet) {
        if (null == nodeSet) {
            return;
        }
        this.nodeSetList.add(nodeSet);
        this.nodeNames.addAll(nodeSet.getNodeNames());
        for (String name : nodeSet.getNodeNames()) {
            this.nodeIndex.put(name, nodeSet);
        }
    }

    @Override
    public Collection<INodeEntry> getNodes() {
        ArrayList<INodeEntry> nodes = new ArrayList<INodeEntry>();
        for (String nodeName : this.nodeNames) {
            nodes.add(this.nodeIndex.get(nodeName).getNode(nodeName));
        }
        return nodes;
    }

    @Override
    public INodeEntry getNode(String name) {
        INodeEntry result = null;
        for (INodeSet iNodeSet : this.nodeSetList) {
            INodeEntry node = iNodeSet.getNode(name);
            if (null == node) continue;
            result = node;
        }
        return result;
    }

    @Override
    public Collection<String> getNodeNames() {
        return this.nodeNames;
    }

    @Override
    public Iterator<INodeEntry> iterator() {
        return this.getNodes().iterator();
    }
}

