/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.workflow.steps;

import com.dtolabs.rundeck.core.common.PropertyRetriever;
import com.dtolabs.rundeck.core.execution.workflow.steps.PropertyResolver;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyScope;

class RuntimePropertyResolver
implements PropertyResolver {
    private PropertyRetriever instanceScopeResolver;
    private PropertyRetriever projectScopeResolver;
    private PropertyRetriever frameworkScopeResolver;

    RuntimePropertyResolver(PropertyRetriever instanceScopeResolver, PropertyRetriever projectScopeResolver, PropertyRetriever frameworkScopeResolver) {
        this.instanceScopeResolver = instanceScopeResolver;
        this.projectScopeResolver = projectScopeResolver;
        this.frameworkScopeResolver = frameworkScopeResolver;
    }

    @Override
    public String resolvePropertyValue(String name, PropertyScope scope) {
        if (null == scope || scope == PropertyScope.Unspecified) {
            throw new IllegalArgumentException("scope must be specified");
        }
        String value = null;
        if (scope.isInstanceLevel() && null != this.instanceScopeResolver) {
            value = this.instanceScopeResolver.getProperty(name);
        }
        if (null != value || scope == PropertyScope.InstanceOnly) {
            return value;
        }
        if (scope.isProjectLevel() && null != this.projectScopeResolver) {
            value = this.projectScopeResolver.getProperty(name);
        }
        if (null != value || scope == PropertyScope.ProjectOnly) {
            return value;
        }
        if (null != this.frameworkScopeResolver && scope.isFrameworkLevel()) {
            value = this.frameworkScopeResolver.getProperty(name);
        }
        return value;
    }
}

