/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.workflow.steps;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.execution.workflow.steps.FailureReason;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepException;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepFailureReason;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepFailureReason;
import com.dtolabs.rundeck.core.plugins.BaseScriptPlugin;
import com.dtolabs.rundeck.core.plugins.PluginException;
import com.dtolabs.rundeck.core.plugins.ScriptPluginProvider;
import com.dtolabs.rundeck.core.plugins.configuration.ConfigurationException;
import com.dtolabs.rundeck.plugins.step.PluginStepContext;
import com.dtolabs.rundeck.plugins.step.StepPlugin;
import com.dtolabs.rundeck.plugins.util.DescriptionBuilder;
import java.io.IOException;
import java.util.Map;

class ScriptPluginStepPlugin
extends BaseScriptPlugin
implements StepPlugin {
    ScriptPluginStepPlugin(ScriptPluginProvider provider, Framework framework) {
        super(provider, framework);
    }

    @Override
    public boolean isAllowCustomProperties() {
        return true;
    }

    static void validateScriptPlugin(ScriptPluginProvider plugin) throws PluginException {
        try {
            ScriptPluginStepPlugin.createDescription(plugin, true, DescriptionBuilder.builder());
        }
        catch (ConfigurationException e) {
            throw new PluginException(e);
        }
    }

    @Override
    public void executeStep(PluginStepContext executionContext, Map<String, Object> config) throws StepException {
        ScriptPluginProvider plugin = this.getProvider();
        String pluginname = plugin.getName();
        executionContext.getLogger().log(3, "[" + pluginname + "] step started, config: " + config);
        int result = -1;
        try {
            result = this.runPluginScript(executionContext, System.out, System.err, this.getFramework(), config);
        }
        catch (IOException e) {
            throw new StepException(e.getMessage(), (FailureReason)StepFailureReason.IOFailure);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new StepException(e.getMessage(), (FailureReason)StepFailureReason.Interrupted);
        }
        executionContext.getLogger().log(3, "[" + pluginname + "]: result code: " + result);
        if (result != 0) {
            throw new StepException("Script result code was: " + result, (FailureReason)NodeStepFailureReason.NonZeroResultCode);
        }
    }
}

