/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.workflow.steps.node;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.execution.workflow.steps.FailureReason;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepFailureReason;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepException;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepFailureReason;
import com.dtolabs.rundeck.core.plugins.BaseScriptPlugin;
import com.dtolabs.rundeck.core.plugins.PluginException;
import com.dtolabs.rundeck.core.plugins.ScriptPluginProvider;
import com.dtolabs.rundeck.core.plugins.configuration.ConfigurationException;
import com.dtolabs.rundeck.plugins.step.NodeStepPlugin;
import com.dtolabs.rundeck.plugins.step.PluginStepContext;
import com.dtolabs.rundeck.plugins.util.DescriptionBuilder;
import java.io.IOException;
import java.util.Map;

class ScriptPluginNodeStepPlugin
extends BaseScriptPlugin
implements NodeStepPlugin {
    ScriptPluginNodeStepPlugin(ScriptPluginProvider provider, Framework framework) {
        super(provider, framework);
    }

    @Override
    public boolean isAllowCustomProperties() {
        return true;
    }

    static void validateScriptPlugin(ScriptPluginProvider plugin) throws PluginException {
        try {
            ScriptPluginNodeStepPlugin.createDescription(plugin, true, DescriptionBuilder.builder());
        }
        catch (ConfigurationException e) {
            throw new PluginException(e);
        }
    }

    @Override
    public void executeNodeStep(PluginStepContext executionContext, Map<String, Object> configuration, INodeEntry node) throws NodeStepException {
        ScriptPluginProvider plugin = this.getProvider();
        String pluginname = plugin.getName();
        executionContext.getLogger().log(3, "[" + pluginname + "] step started, config: " + configuration);
        int result = -1;
        try {
            result = this.runPluginScript(executionContext, System.out, System.err, this.getFramework(), configuration);
        }
        catch (IOException e) {
            throw new NodeStepException(e.getMessage(), (FailureReason)StepFailureReason.IOFailure, node.getNodename());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new NodeStepException(e.getMessage(), (FailureReason)StepFailureReason.Interrupted, node.getNodename());
        }
        executionContext.getLogger().log(3, "[" + pluginname + "]: result code: " + result);
        if (result != 0) {
            throw new NodeStepException("Script result code was: " + result, (FailureReason)NodeStepFailureReason.NonZeroResultCode, node.getNodename());
        }
    }
}

