/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.plugins;

import com.dtolabs.rundeck.core.execution.service.ProviderCreationException;
import com.dtolabs.rundeck.core.execution.service.ProviderLoaderException;
import com.dtolabs.rundeck.core.plugins.PluggableService;
import com.dtolabs.rundeck.core.plugins.Plugin;
import com.dtolabs.rundeck.core.plugins.PluginException;
import com.dtolabs.rundeck.core.plugins.ProviderIdent;
import com.dtolabs.rundeck.core.plugins.ProviderLoader;
import com.dtolabs.rundeck.core.plugins.VersionCompare;
import com.dtolabs.rundeck.core.utils.FileUtils;
import com.dtolabs.rundeck.core.utils.ZipUtil;
import com.dtolabs.rundeck.core.utils.cache.FileCache;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.apache.log4j.Logger;

class JarPluginProviderLoader
implements ProviderLoader,
FileCache.Expireable {
    private static Logger log = Logger.getLogger((String)JarPluginProviderLoader.class.getName());
    public static final String RUNDECK_PLUGIN_ARCHIVE = "Rundeck-Plugin-Archive";
    public static final String RUNDECK_PLUGIN_CLASSNAMES = "Rundeck-Plugin-Classnames";
    public static final String RUNDECK_PLUGIN_LIBS = "Rundeck-Plugin-Libs";
    public static final String JAR_PLUGIN_VERSION = "1.1";
    public static final VersionCompare LOWEST_JAR_PLUGIN_VERSION = VersionCompare.forString("1.1");
    public static final String RUNDECK_PLUGIN_VERSION = "Rundeck-Plugin-Version";
    public static final String RUNDECK_PLUGIN_FILE_VERSION = "Rundeck-Plugin-File-Version";
    public static final String CACHED_JAR_TIMESTAMP_FORMAT = "yyyyMMddHHmmssSSS";
    private final File pluginJar;
    private final File pluginJarCacheDirectory;
    private final File cachedir;
    private final DateFormat cachedJarTimestampFormatter = new SimpleDateFormat("yyyyMMddHHmmssSSS");
    private Map<ProviderIdent, Class> pluginProviderDefs = new HashMap<ProviderIdent, Class>();
    Attributes mainAttributes;
    private Map<String, Class<?>> classCache = new HashMap();

    public JarPluginProviderLoader(File pluginJar, File pluginJarCacheDirectory, File cachedir) {
        if (null == pluginJar) {
            throw new NullPointerException("Expected non-null plugin jar argument.");
        }
        if (!pluginJar.exists()) {
            throw new IllegalArgumentException("File does not exist: " + pluginJar);
        }
        if (!pluginJar.isFile()) {
            throw new IllegalArgumentException("Not a file: " + pluginJar);
        }
        this.pluginJar = pluginJar;
        this.pluginJarCacheDirectory = pluginJarCacheDirectory;
        this.cachedir = cachedir;
    }

    @Override
    public synchronized <T> T load(PluggableService<T> service, String providerName) throws ProviderLoaderException {
        Class cls;
        ProviderIdent ident = new ProviderIdent(service.getName(), providerName);
        JarPluginProviderLoader.debug("loadInstance for " + ident + ": " + this.pluginJar);
        if (null == this.pluginProviderDefs.get(ident)) {
            String[] strings;
            for (String classname : strings = this.getClassnames()) {
                try {
                    Class<?> cls2 = this.loadClass(classname);
                    if (!JarPluginProviderLoader.matchesProviderDeclaration(ident, cls2)) continue;
                    this.pluginProviderDefs.put(ident, cls2);
                }
                catch (PluginException e) {
                    log.error((Object)("Failed to load class from " + this.pluginJar + ": classname: " + classname + ": " + e.getMessage()));
                }
            }
        }
        if (null != (cls = this.pluginProviderDefs.get(ident))) {
            try {
                return JarPluginProviderLoader.createProviderForClass(service, cls);
            }
            catch (PluginException e) {
                throw new ProviderLoaderException(e, service.getName(), providerName);
            }
        }
        return null;
    }

    static boolean matchesProviderDeclaration(ProviderIdent ident, Class<?> cls) throws PluginException {
        Plugin annotation = JarPluginProviderLoader.getPluginMetadata(cls);
        return ((String)ident.getFirst()).equals(annotation.service()) && ((String)ident.getSecond()).equals(annotation.name());
    }

    static ProviderIdent getProviderDeclaration(Class<?> cls) throws PluginException {
        Plugin annotation = JarPluginProviderLoader.getPluginMetadata(cls);
        return new ProviderIdent(annotation.service(), annotation.name());
    }

    public String[] getClassnames() {
        Attributes attributes = this.getMainAttributes();
        if (null == attributes) {
            return null;
        }
        String value = attributes.getValue(RUNDECK_PLUGIN_CLASSNAMES);
        if (null == value) {
            return null;
        }
        return value.split(",");
    }

    private Attributes getMainAttributes() {
        if (null == this.mainAttributes) {
            this.mainAttributes = JarPluginProviderLoader.getJarMainAttributes(this.pluginJar);
        }
        return this.mainAttributes;
    }

    private static Attributes getJarMainAttributes(File file) {
        JarPluginProviderLoader.debug("getJarMainAttributes: " + file);
        try {
            JarInputStream jarInputStream = new JarInputStream(new FileInputStream(file));
            Manifest manifest = jarInputStream.getManifest();
            Attributes mainAttributes = manifest.getMainAttributes();
            jarInputStream.close();
            return mainAttributes;
        }
        catch (IOException e) {
            return null;
        }
    }

    static <T> T createProviderForClass(PluggableService<T> service, Class cls) throws PluginException, ProviderCreationException {
        JarPluginProviderLoader.debug("Try loading provider " + cls.getName());
        Plugin annotation = JarPluginProviderLoader.getPluginMetadata(cls);
        String pluginname = annotation.name();
        if (!service.isValidProviderClass(cls)) {
            throw new PluginException("Class " + cls.getName() + " was not a valid plugin class for service: " + service.getName());
        }
        JarPluginProviderLoader.debug("Succeeded loading plugin " + cls.getName() + " for service: " + service.getName());
        return service.createProviderInstance(cls, pluginname);
    }

    private static void debug(String s) {
        if (log.isDebugEnabled()) {
            log.debug((Object)s);
        }
    }

    static Plugin getPluginMetadata(Class<?> cls) throws PluginException {
        if (!cls.isAnnotationPresent(Plugin.class)) {
            throw new PluginException("No Plugin annotation was found for the class: " + cls.getName());
        }
        Plugin annotation = cls.getAnnotation(Plugin.class);
        String pluginname = annotation.name();
        if (null == pluginname || "".equals(pluginname)) {
            throw new PluginException("Plugin annotation 'name' cannot be empty for the class: " + cls.getName());
        }
        String servicename = annotation.service();
        if (null == servicename || "".equals(servicename)) {
            throw new PluginException("Plugin annotation 'service' cannot be empty for the class: " + cls.getName());
        }
        return annotation;
    }

    protected boolean isEquivalentPluginJar(File other) {
        String name = other.getName();
        int length = CACHED_JAR_TIMESTAMP_FORMAT.length() + 1;
        if (name.length() <= length) {
            log.warn((Object)String.format("%s does not conform to cached plugin jar naming convention.", other));
            return false;
        }
        return other.getName().substring(length).equals(this.pluginJar.getName());
    }

    protected String generateCachedJarName() {
        Date mtime = new Date(this.pluginJar.lastModified());
        return String.format("%s-%s", this.cachedJarTimestampFormatter.format(mtime), this.pluginJar.getName());
    }

    protected File createCachedJar() throws PluginException {
        File cachedJar;
        try {
            JarPluginProviderLoader.debug(String.format("Scanning %s for cached versions of %s", this.pluginJarCacheDirectory, this.pluginJar));
            for (File f : this.pluginJarCacheDirectory.listFiles()) {
                if (!this.isEquivalentPluginJar(f)) continue;
                JarPluginProviderLoader.debug(String.format("Found %s, deleting...", f));
                if (f.delete()) continue;
                log.warn((Object)String.format("Could not delete %s", f));
            }
            cachedJar = new File(this.pluginJarCacheDirectory, this.generateCachedJarName());
            cachedJar.deleteOnExit();
            FileUtils.fileCopy(this.pluginJar, cachedJar, true);
        }
        catch (IOException e) {
            throw new PluginException(e);
        }
        return cachedJar;
    }

    private Class<?> loadClass(String classname) throws PluginException {
        Class<?> cls;
        if (null == classname) {
            throw new IllegalArgumentException("A null java class name was specified.");
        }
        if (null != this.classCache.get(classname)) {
            JarPluginProviderLoader.debug("(loadClass) " + classname + ": " + this.pluginJar);
            return this.classCache.get(classname);
        }
        JarPluginProviderLoader.debug(String.format("Deleting dependency lib cache %s", this.getFileCacheDir()));
        FileUtils.deleteDir(this.getFileCacheDir());
        File cachedJar = this.createCachedJar();
        JarPluginProviderLoader.debug("loadClass! " + classname + ": " + cachedJar);
        ClassLoader parent = JarPluginProviderLoader.class.getClassLoader();
        Collection<File> extlibs = null;
        try {
            extlibs = this.extractDependentLibs();
        }
        catch (IOException e) {
            throw new PluginException("Unable to expand plugin libs: " + e.getMessage(), e);
        }
        try {
            URL[] urlarray;
            URL url = cachedJar.toURI().toURL();
            if (null != extlibs && extlibs.size() > 0) {
                ArrayList<URL> urls = new ArrayList<URL>();
                urls.add(url);
                for (File extlib : extlibs) {
                    urls.add(extlib.toURI().toURL());
                }
                urlarray = urls.toArray(new URL[urls.size()]);
            } else {
                urlarray = new URL[]{url};
            }
            URLClassLoader urlClassLoader = URLClassLoader.newInstance(urlarray, parent);
            cls = Class.forName(classname, true, urlClassLoader);
            this.classCache.put(classname, cls);
        }
        catch (ClassNotFoundException e) {
            throw new PluginException("Class not found: " + classname, e);
        }
        catch (MalformedURLException e) {
            throw new PluginException("Error loading class: " + classname, e);
        }
        catch (Throwable t) {
            throw new PluginException("Error loading class: " + classname, t);
        }
        return cls;
    }

    private Collection<File> extractDependentLibs() throws IOException {
        Attributes attributes = this.getMainAttributes();
        if (null == attributes) {
            JarPluginProviderLoader.debug("no manifest attributes");
            return null;
        }
        ArrayList<File> files = new ArrayList<File>();
        String libs = attributes.getValue(RUNDECK_PLUGIN_LIBS);
        if (null != libs) {
            JarPluginProviderLoader.debug("jar libs listed: " + libs + " for file: " + this.pluginJar);
            String[] libsarr = libs.split(" ");
            File cachedir = this.getFileCacheDir();
            this.extractJarContents(libsarr, cachedir);
            for (String s : libsarr) {
                files.add(new File(cachedir, s));
            }
        } else {
            JarPluginProviderLoader.debug("no jar libs listed in manifest: " + this.pluginJar);
        }
        return files;
    }

    private void extractJarContents(String[] entries, File destdir) throws IOException {
        if (!destdir.exists() && !destdir.mkdir()) {
            log.warn((Object)("Unable to create cache dir for plugin: " + destdir.getAbsolutePath()));
        }
        JarPluginProviderLoader.debug("extracting lib files from jar: " + this.pluginJar);
        for (String path : entries) {
            JarPluginProviderLoader.debug("Expand zip " + this.pluginJar.getAbsolutePath() + " to dir: " + destdir + ", file: " + path);
            ZipUtil.extractZipFile(this.pluginJar.getAbsolutePath(), destdir, path);
        }
    }

    String getFileBasename() {
        return JarPluginProviderLoader.basename(this.pluginJar);
    }

    private static String basename(File file) {
        String name = file.getName();
        return name.substring(0, name.lastIndexOf("."));
    }

    File getFileCacheDir() {
        return new File(this.cachedir, this.getFileBasename());
    }

    @Override
    public synchronized boolean isLoaderFor(ProviderIdent ident) {
        String[] strings;
        for (String classname : strings = this.getClassnames()) {
            try {
                if (!JarPluginProviderLoader.matchesProviderDeclaration(ident, this.loadClass(classname))) continue;
                return true;
            }
            catch (PluginException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    @Override
    public synchronized List<ProviderIdent> listProviders() {
        String[] strings;
        ArrayList<ProviderIdent> providerIdents = new ArrayList<ProviderIdent>();
        for (String classname : strings = this.getClassnames()) {
            try {
                providerIdents.add(JarPluginProviderLoader.getProviderDeclaration(this.loadClass(classname)));
            }
            catch (PluginException e) {
                e.printStackTrace();
            }
        }
        return providerIdents;
    }

    private synchronized boolean removeScriptPluginCache() {
        File fileExpandedDir = this.getFileCacheDir();
        if (null != fileExpandedDir && fileExpandedDir.exists()) {
            JarPluginProviderLoader.debug("removeScriptPluginCache: " + fileExpandedDir);
            return FileUtils.deleteDir(fileExpandedDir);
        }
        return true;
    }

    @Override
    public void expire() {
        this.removeScriptPluginCache();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JarPluginProviderLoader that = (JarPluginProviderLoader)o;
        if (this.classCache != null ? !((Object)this.classCache).equals(that.classCache) : that.classCache != null) {
            return false;
        }
        if (!this.pluginJar.equals(that.pluginJar)) {
            return false;
        }
        if (this.mainAttributes != null ? !this.mainAttributes.equals(that.mainAttributes) : that.mainAttributes != null) {
            return false;
        }
        return !(this.pluginProviderDefs != null ? !((Object)this.pluginProviderDefs).equals(that.pluginProviderDefs) : that.pluginProviderDefs != null);
    }

    public int hashCode() {
        int result = this.pluginJar.hashCode();
        result = 31 * result + (this.pluginProviderDefs != null ? ((Object)this.pluginProviderDefs).hashCode() : 0);
        result = 31 * result + (this.mainAttributes != null ? this.mainAttributes.hashCode() : 0);
        result = 31 * result + (this.classCache != null ? ((Object)this.classCache).hashCode() : 0);
        return result;
    }

    public static boolean isValidJarPlugin(File file) {
        try {
            JarInputStream jarInputStream = new JarInputStream(new FileInputStream(file));
            Manifest manifest = jarInputStream.getManifest();
            if (null == manifest) {
                jarInputStream.close();
                return false;
            }
            Attributes mainAttributes = manifest.getMainAttributes();
            JarPluginProviderLoader.validateJarManifest(mainAttributes);
            jarInputStream.close();
            return true;
        }
        catch (IOException e) {
            log.error((Object)(file.getAbsolutePath() + ": " + e.getMessage()));
            return false;
        }
        catch (InvalidManifestException e) {
            log.error((Object)(file.getAbsolutePath() + ": " + e.getMessage()));
            return false;
        }
    }

    static void validateJarManifest(Attributes mainAttributes) throws InvalidManifestException {
        String value1 = mainAttributes.getValue(RUNDECK_PLUGIN_ARCHIVE);
        String plugvers = mainAttributes.getValue(RUNDECK_PLUGIN_VERSION);
        String plugclassnames = mainAttributes.getValue(RUNDECK_PLUGIN_CLASSNAMES);
        if (null == value1) {
            throw new InvalidManifestException("Jar plugin manifest attribute missing: Rundeck-Plugin-Archive");
        }
        if (!"true".equals(value1)) {
            throw new InvalidManifestException("Rundeck-Plugin-Archive was not 'true': " + value1);
        }
        if (null == plugvers) {
            throw new InvalidManifestException("Jar plugin manifest attribute missing: Rundeck-Plugin-Version");
        }
        VersionCompare pluginVersion = VersionCompare.forString(plugvers);
        if (!pluginVersion.atLeast(LOWEST_JAR_PLUGIN_VERSION)) {
            throw new InvalidManifestException("Unsupported plugin version: Rundeck-Plugin-Version: " + plugvers);
        }
        if (null == plugclassnames) {
            throw new InvalidManifestException("Jar plugin manifest attribute missing: Rundeck-Plugin-Classnames");
        }
    }

    static String getVersionForFile(File file) {
        return JarPluginProviderLoader.loadManifestAttribute(file, RUNDECK_PLUGIN_FILE_VERSION);
    }

    private static String loadManifestAttribute(File file, String attribute) {
        String plugvers = null;
        try {
            JarInputStream jarInputStream = new JarInputStream(new FileInputStream(file));
            Manifest manifest = jarInputStream.getManifest();
            if (null == manifest) {
                jarInputStream.close();
                return null;
            }
            Attributes mainAttributes = manifest.getMainAttributes();
            plugvers = mainAttributes.getValue(attribute);
            jarInputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            log.warn((Object)(e.getMessage() + ": " + file.getAbsolutePath()));
        }
        return plugvers;
    }

    static class InvalidManifestException
    extends Exception {
        public InvalidManifestException(String s) {
            super(s);
        }
    }
}

