/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.plugins;

import com.dtolabs.rundeck.core.execution.script.ScriptfileUtils;
import com.dtolabs.rundeck.core.execution.service.ProviderLoaderException;
import com.dtolabs.rundeck.core.plugins.PluggableService;
import com.dtolabs.rundeck.core.plugins.PluginException;
import com.dtolabs.rundeck.core.plugins.ProviderIdent;
import com.dtolabs.rundeck.core.plugins.ProviderLoader;
import com.dtolabs.rundeck.core.plugins.ScriptPluginProvider;
import com.dtolabs.rundeck.core.plugins.ScriptPluginProviderImpl;
import com.dtolabs.rundeck.core.plugins.metadata.PluginMeta;
import com.dtolabs.rundeck.core.plugins.metadata.ProviderDef;
import com.dtolabs.rundeck.core.utils.FileUtils;
import com.dtolabs.rundeck.core.utils.ZipUtil;
import com.dtolabs.rundeck.core.utils.cache.FileCache;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.log4j.Logger;
import org.yaml.snakeyaml.Yaml;

class ScriptPluginProviderLoader
implements ProviderLoader,
FileCache.Expireable {
    private static final Logger log = Logger.getLogger((String)ScriptPluginProviderLoader.class.getName());
    public static final String SCRIPT_PLUGIN_VERSION = "1.0";
    private final File file;
    final File cachedir;
    private File fileExpandedDir;
    private PluginMeta metadata;
    private Map<ProviderIdent, ScriptPluginProvider> pluginProviderDefs = new HashMap<ProviderIdent, ScriptPluginProvider>();

    public ScriptPluginProviderLoader(File file, File cachedir) {
        this.file = file;
        this.cachedir = cachedir;
    }

    @Override
    public synchronized <T> T load(PluggableService<T> service, String providerName) throws ProviderLoaderException {
        ScriptPluginProvider scriptPluginProvider;
        if (!service.isScriptPluggable()) {
            return null;
        }
        ProviderIdent ident = new ProviderIdent(service.getName(), providerName);
        if (null == this.pluginProviderDefs.get(ident)) {
            PluginMeta pluginMeta;
            try {
                pluginMeta = this.getPluginMeta();
            }
            catch (IOException e) {
                throw new ProviderLoaderException(e, service.getName(), providerName);
            }
            if (null == pluginMeta) {
                throw new ProviderLoaderException("Unable to load plugin metadata for file: " + this.file, service.getName(), providerName);
            }
            for (ProviderDef pluginDef : pluginMeta.getPluginDefs()) {
                ScriptPluginProvider provider;
                if (!this.matchesProvider(ident, pluginDef)) continue;
                try {
                    provider = this.getPlugin(this.file, pluginDef, ident);
                }
                catch (PluginException e) {
                    throw new ProviderLoaderException(e, service.getName(), providerName);
                }
                this.pluginProviderDefs.put(ident, provider);
                break;
            }
        }
        if (null != (scriptPluginProvider = this.pluginProviderDefs.get(ident))) {
            try {
                return service.createScriptProviderInstance(scriptPluginProvider);
            }
            catch (PluginException e) {
                throw new ProviderLoaderException(e, service.getName(), providerName);
            }
        }
        return null;
    }

    private PluginMeta getPluginMeta() throws IOException {
        if (null != this.metadata) {
            return this.metadata;
        }
        this.metadata = ScriptPluginProviderLoader.loadMeta(this.file);
        return this.metadata;
    }

    private ScriptPluginProvider getPlugin(File file, ProviderDef pluginDef, ProviderIdent ident) throws ProviderLoaderException, PluginException {
        if (null == this.fileExpandedDir) {
            File dir;
            try {
                dir = this.expandScriptPlugin(file);
            }
            catch (IOException e) {
                throw new ProviderLoaderException(e, ident.getService(), ident.getProviderName());
            }
            this.fileExpandedDir = dir;
            File script = new File(this.fileExpandedDir, pluginDef.getScriptFile());
            try {
                ScriptfileUtils.setExecutePermissions(script);
            }
            catch (IOException e) {
                log.warn((Object)("Unable to set executable bit for script file: " + script + ": " + e.getMessage()));
            }
            ScriptPluginProviderLoader.debug("expanded plugin dir! " + this.fileExpandedDir);
        } else {
            ScriptPluginProviderLoader.debug("expanded plugin dir: " + this.fileExpandedDir);
        }
        File script = new File(this.fileExpandedDir, pluginDef.getScriptFile());
        if (!script.exists() || !script.isFile()) {
            throw new PluginException("Script file was not found: " + script.getAbsolutePath());
        }
        return new ScriptPluginProviderImpl(pluginDef, file, this.fileExpandedDir);
    }

    private boolean matchesProvider(ProviderIdent ident, ProviderDef pluginDef) {
        return ident.getService().equals(pluginDef.getService()) && ident.getProviderName().equals(pluginDef.getName());
    }

    @Override
    public synchronized boolean isLoaderFor(ProviderIdent ident) {
        PluginMeta pluginMeta;
        try {
            pluginMeta = this.getPluginMeta();
        }
        catch (IOException e) {
            log.warn((Object)("Unable to load file meta: " + e.getMessage()));
            return false;
        }
        if (null == pluginMeta) {
            return false;
        }
        for (ProviderDef pluginDef : pluginMeta.getPluginDefs()) {
            if (!this.matchesProvider(ident, pluginDef)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<ProviderIdent> listProviders() {
        ArrayList<ProviderIdent> providerIdents = new ArrayList<ProviderIdent>();
        PluginMeta pluginMeta = null;
        try {
            pluginMeta = this.getPluginMeta();
        }
        catch (IOException e) {
            log.debug((Object)("Unable to load file meta: " + e.getMessage()));
        }
        if (null == pluginMeta) {
            return providerIdents;
        }
        for (ProviderDef pluginDef : pluginMeta.getPluginDefs()) {
            providerIdents.add(new ProviderIdent(pluginDef.getService(), pluginDef.getName()));
        }
        return providerIdents;
    }

    static PluginMeta loadMeta(File jar) throws IOException {
        ZipInputStream zipinput = new ZipInputStream(new FileInputStream(jar));
        PluginMeta metadata = ScriptPluginProviderLoader.loadMeta(jar, zipinput);
        zipinput.close();
        return metadata;
    }

    static PluginMeta loadMeta(File jar, ZipInputStream zipinput) throws IOException {
        String basename = ScriptPluginProviderLoader.basename(jar);
        PluginMeta metadata = null;
        boolean topfound = false;
        boolean found = false;
        boolean dirfound = false;
        ZipEntry nextEntry = zipinput.getNextEntry();
        while (null != nextEntry) {
            if (!topfound && nextEntry.getName().startsWith(basename + "/")) {
                topfound = true;
            }
            if (!dirfound && (nextEntry.getName().startsWith(basename + "/contents/") || nextEntry.isDirectory() && nextEntry.getName().equals(basename + "/contents"))) {
                dirfound = true;
            }
            if (!found && !nextEntry.isDirectory() && nextEntry.getName().equals(basename + "/plugin.yaml")) {
                try {
                    metadata = ScriptPluginProviderLoader.loadMetadataYaml(zipinput);
                    found = true;
                }
                catch (Throwable e) {
                    log.error((Object)("Error parsing metadata file plugin.yaml: " + e.getMessage()), e);
                }
            }
            if (dirfound && found) break;
            nextEntry = zipinput.getNextEntry();
        }
        if (!topfound) {
            log.error((Object)("Plugin not loaded: Found no " + basename + "/ dir within file: " + jar.getAbsolutePath()));
        }
        if (!found) {
            log.error((Object)("Plugin not loaded: Found no " + basename + "/plugin.yaml within: " + jar.getAbsolutePath()));
        }
        if (!dirfound) {
            log.error((Object)("Plugin not loaded: Found no " + basename + "/contents dir within: " + jar.getAbsolutePath()));
        }
        if (found && dirfound) {
            return metadata;
        }
        return null;
    }

    static PluginMeta loadMetadataYaml(InputStream stream) {
        Yaml yaml = new Yaml();
        return (PluginMeta)yaml.loadAs(stream, PluginMeta.class);
    }

    static boolean validatePluginMeta(PluginMeta pluginList, File file) {
        boolean valid = true;
        if (null == pluginList.getName()) {
            log.error((Object)("name not found in metadata: " + file.getAbsolutePath()));
            valid = false;
        }
        if (null == pluginList.getVersion()) {
            log.error((Object)("version not found in metadata: " + file.getAbsolutePath()));
            valid = false;
        }
        if (null == pluginList.getRundeckPluginVersion()) {
            log.error((Object)("rundeckPluginVersion not found in metadata: " + file.getAbsolutePath()));
            valid = false;
        } else if (!SCRIPT_PLUGIN_VERSION.equals(pluginList.getRundeckPluginVersion())) {
            log.error((Object)("rundeckPluginVersion: " + pluginList.getRundeckPluginVersion() + " is not supported: " + file.getAbsolutePath()));
            valid = false;
        }
        List<ProviderDef> pluginDefs = pluginList.getPluginDefs();
        for (ProviderDef pluginDef : pluginDefs) {
            try {
                ScriptPluginProviderLoader.validateProviderDef(pluginDef);
            }
            catch (PluginException e) {
                valid = false;
            }
        }
        return valid;
    }

    private File expandScriptPlugin(File file) throws IOException {
        File jardir;
        if (!this.cachedir.exists() && !this.cachedir.mkdirs()) {
            log.warn((Object)("Unable to create cache dir: " + this.cachedir.getAbsolutePath()));
        }
        if (!(jardir = this.getFileCacheDir()).exists() && !jardir.mkdir()) {
            log.warn((Object)("Unable to create cache dir for plugin: " + jardir.getAbsolutePath()));
        }
        String prefix = this.getFileBasename() + "/contents";
        ScriptPluginProviderLoader.debug("Expand zip " + file.getAbsolutePath() + " to dir: " + jardir + ", prefix: " + prefix);
        ZipUtil.extractZip(file.getAbsolutePath(), jardir, prefix, prefix + "/");
        return jardir;
    }

    private synchronized boolean removeScriptPluginCache() {
        if (null != this.fileExpandedDir && this.fileExpandedDir.exists()) {
            ScriptPluginProviderLoader.debug("removeScriptPluginCache: " + this.fileExpandedDir);
            return FileUtils.deleteDir(this.fileExpandedDir);
        }
        return true;
    }

    String getFileBasename() {
        return ScriptPluginProviderLoader.basename(this.file);
    }

    private static String basename(File file) {
        String name = file.getName();
        return name.substring(0, name.lastIndexOf("."));
    }

    File getFileCacheDir() {
        return new File(this.cachedir, this.getFileBasename());
    }

    private static void validateProviderDef(ProviderDef pluginDef) throws PluginException {
        if (null == pluginDef.getPluginType() || "".equals(pluginDef.getPluginType())) {
            throw new PluginException("Script plugin missing plugin-type");
        }
        if (!"script".equals(pluginDef.getPluginType())) {
            throw new PluginException("plugin missing has invalid plugin-type: " + pluginDef.getPluginType());
        }
        ScriptPluginProviderLoader.validateScriptProviderDef(pluginDef);
    }

    private static void validateScriptProviderDef(ProviderDef pluginDef) throws PluginException {
        if (null == pluginDef.getName() || "".equals(pluginDef.getName())) {
            throw new PluginException("Script plugin missing name");
        }
        if (null == pluginDef.getService() || "".equals(pluginDef.getService())) {
            throw new PluginException("Script plugin missing service");
        }
        if (null == pluginDef.getScriptFile() || "".equals(pluginDef.getScriptFile())) {
            throw new PluginException("Script plugin missing script-file");
        }
    }

    private static void debug(String msg) {
        if (log.isDebugEnabled()) {
            log.debug((Object)msg);
        }
    }

    @Override
    public void expire() {
        this.removeScriptPluginCache();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScriptPluginProviderLoader that = (ScriptPluginProviderLoader)o;
        if (this.cachedir != null ? !this.cachedir.equals(that.cachedir) : that.cachedir != null) {
            return false;
        }
        return !(this.file != null ? !this.file.equals(that.file) : that.file != null);
    }

    public int hashCode() {
        int result = this.file != null ? this.file.hashCode() : 0;
        result = 31 * result + (this.cachedir != null ? this.cachedir.hashCode() : 0);
        return result;
    }

    static String getVersionForFile(File file) {
        try {
            PluginMeta pluginMeta = ScriptPluginProviderLoader.loadMeta(file);
            return pluginMeta.getVersion();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

