/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.resources;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.execution.service.ExecutionServiceException;
import com.dtolabs.rundeck.core.execution.service.ProviderCreationException;
import com.dtolabs.rundeck.core.plugins.PluggableProviderRegistryService;
import com.dtolabs.rundeck.core.plugins.PluginException;
import com.dtolabs.rundeck.core.plugins.ProviderIdent;
import com.dtolabs.rundeck.core.plugins.ScriptPluginProvider;
import com.dtolabs.rundeck.core.plugins.configuration.ConfigurableService;
import com.dtolabs.rundeck.core.plugins.configuration.ConfigurationException;
import com.dtolabs.rundeck.core.plugins.configuration.DescribableService;
import com.dtolabs.rundeck.core.plugins.configuration.DescribableServiceUtil;
import com.dtolabs.rundeck.core.plugins.configuration.Description;
import com.dtolabs.rundeck.core.resources.DirectoryResourceModelSourceFactory;
import com.dtolabs.rundeck.core.resources.FileResourceModelSourceFactory;
import com.dtolabs.rundeck.core.resources.ResourceModelSource;
import com.dtolabs.rundeck.core.resources.ResourceModelSourceFactory;
import com.dtolabs.rundeck.core.resources.ResourceModelSourceServiceException;
import com.dtolabs.rundeck.core.resources.ScriptPluginResourceModelSourceFactory;
import com.dtolabs.rundeck.core.resources.ScriptResourceModelSourceFactory;
import com.dtolabs.rundeck.core.resources.URLResourceModelSourceFactory;
import java.util.List;
import java.util.Properties;

public class ResourceModelSourceService
extends PluggableProviderRegistryService<ResourceModelSourceFactory>
implements ConfigurableService<ResourceModelSource>,
DescribableService {
    public static final String SERVICE_NAME = "ResourceModelSource";

    public ResourceModelSourceService(Framework framework) {
        super(framework);
        this.registry.put("file", FileResourceModelSourceFactory.class);
        this.registry.put("directory", DirectoryResourceModelSourceFactory.class);
        this.registry.put("url", URLResourceModelSourceFactory.class);
        this.registry.put("script", ScriptResourceModelSourceFactory.class);
    }

    @Override
    public String getName() {
        return SERVICE_NAME;
    }

    public static ResourceModelSourceService getInstanceForFramework(Framework framework) {
        if (null == framework.getService(SERVICE_NAME)) {
            ResourceModelSourceService service = new ResourceModelSourceService(framework);
            framework.setService(SERVICE_NAME, service);
            return service;
        }
        return (ResourceModelSourceService)framework.getService(SERVICE_NAME);
    }

    public ResourceModelSource getSourceForConfiguration(String type, Properties configuration) throws ExecutionServiceException {
        ResourceModelSourceFactory nodesSourceFactory = (ResourceModelSourceFactory)this.providerOfType(type);
        try {
            return nodesSourceFactory.createResourceModelSource(configuration);
        }
        catch (ConfigurationException e) {
            throw new ResourceModelSourceServiceException(e);
        }
        catch (Throwable e) {
            throw new ResourceModelSourceServiceException(e);
        }
    }

    @Override
    public boolean isValidProviderClass(Class clazz) {
        return ResourceModelSourceFactory.class.isAssignableFrom(clazz) && this.hasValidProviderSignature(clazz);
    }

    @Override
    public ResourceModelSourceFactory createProviderInstance(Class<ResourceModelSourceFactory> clazz, String name) throws PluginException, ProviderCreationException {
        return this.createProviderInstanceFromType(clazz, name);
    }

    @Override
    public boolean isScriptPluggable() {
        return true;
    }

    @Override
    public ResourceModelSourceFactory createScriptProviderInstance(ScriptPluginProvider provider) throws PluginException {
        ScriptPluginResourceModelSourceFactory.validateScriptPlugin(provider);
        return new ScriptPluginResourceModelSourceFactory(provider, this.framework);
    }

    @Override
    public ResourceModelSource getProviderForConfiguration(String type, Properties configuration) throws ExecutionServiceException {
        return this.getSourceForConfiguration(type, configuration);
    }

    @Override
    public List<Description> listDescriptions() {
        return DescribableServiceUtil.listDescriptions(this, false);
    }

    @Override
    public List<ProviderIdent> listDescribableProviders() {
        return DescribableServiceUtil.listDescribableProviders(this);
    }
}

