/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.resources.format;

import com.dtolabs.rundeck.core.common.INodeSet;
import com.dtolabs.rundeck.core.common.NodeFileParserException;
import com.dtolabs.rundeck.core.common.NodeReceiver;
import com.dtolabs.rundeck.core.common.NodeSetImpl;
import com.dtolabs.rundeck.core.common.NodesYamlParser;
import com.dtolabs.rundeck.core.plugins.Plugin;
import com.dtolabs.rundeck.core.plugins.configuration.Describable;
import com.dtolabs.rundeck.core.plugins.configuration.Description;
import com.dtolabs.rundeck.core.resources.format.ResourceFormatParser;
import com.dtolabs.rundeck.core.resources.format.ResourceFormatParserException;
import com.dtolabs.rundeck.plugins.util.DescriptionBuilder;
import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@Plugin(name="resourceyaml", service="ResourceFormatParser")
public class ResourceYamlFormatParser
implements ResourceFormatParser,
Describable {
    public static final String SERVICE_PROVIDER_TYPE = "resourceyaml";
    public static final Set<String> EXTENSIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("yaml", "yml")));
    public static final Set<String> MIME_TYPES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("*/yaml", "*/x-yaml")));
    private static final Description DESCRIPTION = DescriptionBuilder.builder().name("resourceyaml").title("Resource YAML").description("The RunDeck Resource YAML format 1.3").build();

    @Override
    public Set<String> getFileExtensions() {
        return EXTENSIONS;
    }

    @Override
    public Set<String> getMIMETypes() {
        return MIME_TYPES;
    }

    @Override
    public INodeSet parseDocument(File file) throws ResourceFormatParserException {
        NodeSetImpl nodes = new NodeSetImpl();
        try {
            new NodesYamlParser(file, (NodeReceiver)nodes).parse();
        }
        catch (NodeFileParserException e) {
            throw new ResourceFormatParserException(e);
        }
        return nodes;
    }

    @Override
    public INodeSet parseDocument(InputStream input) throws ResourceFormatParserException {
        NodeSetImpl nodes = new NodeSetImpl();
        try {
            new NodesYamlParser(input, (NodeReceiver)nodes).parse();
        }
        catch (NodeFileParserException e) {
            throw new ResourceFormatParserException(e);
        }
        return nodes;
    }

    @Override
    public Description getDescription() {
        return DESCRIPTION;
    }
}

