/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.tasks.dispatch;

import com.dtolabs.rundeck.core.cli.NodeDispatchStatusListener;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class NodeExecutionStatusTask
extends Task {
    private String refId;
    private NodeDispatchStatusListener nodeDispatchStatusListener;
    private String nodeName;
    private boolean failOnError;

    public void execute() {
        this.validate();
        if (null != this.getRefId()) {
            Object o = this.getProject().getReference(this.getRefId());
            if (null == o) {
                if (this.failOnError) {
                    throw new BuildException("refId: " + this.getRefId() + ", was not found");
                }
                return;
            }
            if (!(o instanceof NodeDispatchStatusListener)) {
                if (this.failOnError) {
                    throw new BuildException("refId: " + this.getRefId() + ", was not a NodeDispatchStatusListener: " + o.getClass().getName());
                }
                return;
            }
            this.setNodeDispatchStatusListener((NodeDispatchStatusListener)o);
        }
        if (null == this.getNodeDispatchStatusListener()) {
            if (this.failOnError) {
                throw new BuildException("no listener was configured");
            }
            return;
        }
        this.getNodeDispatchStatusListener().reportSuccess(this.getNodeName());
    }

    private void validate() {
        if (null == this.getRefId() && null == this.getNodeDispatchStatusListener()) {
            throw new BuildException("refId is not set and no listener is configured");
        }
        if (null == this.getNodeName()) {
            throw new BuildException("nodeName is not set");
        }
    }

    public String getRefId() {
        return this.refId;
    }

    public void setRefId(String refId) {
        this.refId = refId;
    }

    public NodeDispatchStatusListener getNodeDispatchStatusListener() {
        return this.nodeDispatchStatusListener;
    }

    public void setNodeDispatchStatusListener(NodeDispatchStatusListener nodeDispatchStatusListener) {
        this.nodeDispatchStatusListener = nodeDispatchStatusListener;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }
}

