/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.tasks.net;

import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.dispatcher.DataContextUtils;
import com.dtolabs.rundeck.core.tasks.net.ExtSSHExec;
import java.io.File;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.optional.ssh.SSHBase;
import org.apache.tools.ant.taskdefs.optional.ssh.Scp;
import org.apache.tools.ant.types.Environment;

public class SSHTaskBuilder {
    public static ExtSSHExec build(INodeEntry nodeentry, String[] args, Project project, Map<String, Map<String, String>> dataContext, SSHConnectionInfo sshConnectionInfo, int loglevel) throws BuilderException {
        ExtSSHExec extSSHExec = new ExtSSHExec();
        SSHTaskBuilder.build(new SSHExecImpl(extSSHExec), nodeentry, args, project, dataContext, sshConnectionInfo, loglevel);
        return extSSHExec;
    }

    static void build(SSHExecInterface sshexecTask, INodeEntry nodeentry, String[] args, Project project, Map<String, Map<String, String>> dataContext, SSHConnectionInfo sshConnectionInfo, int loglevel) throws BuilderException {
        SSHTaskBuilder.configureSSHBase(nodeentry, project, sshConnectionInfo, sshexecTask, loglevel);
        String commandString = StringUtils.join((Object[])args, (String)" ");
        sshexecTask.setCommand(commandString);
        sshexecTask.setTimeout(sshConnectionInfo.getSSHTimeout());
        sshexecTask.setOutputproperty("sshexec.output");
        DataContextUtils.addEnvVars(sshexecTask, dataContext);
    }

    private static void configureSSHBase(INodeEntry nodeentry, Project project, SSHConnectionInfo sshConnectionInfo, SSHBaseInterface sshbase, double loglevel) throws BuilderException {
        String username;
        sshbase.setFailonerror(true);
        sshbase.setTrust(true);
        sshbase.setProject(project);
        sshbase.setVerbose(loglevel >= 3.0);
        sshbase.setHost(nodeentry.extractHostname());
        if (nodeentry.containsPort()) {
            int portNum;
            try {
                portNum = Integer.parseInt(nodeentry.extractPort());
            }
            catch (NumberFormatException e) {
                throw new BuilderException("Port number is not valid: " + nodeentry.extractPort(), e);
            }
            sshbase.setPort(portNum);
        }
        if (null == (username = sshConnectionInfo.getUsername())) {
            throw new BuilderException("username was not set");
        }
        sshbase.setUsername(username);
        AuthenticationType authenticationType = sshConnectionInfo.getAuthenticationType();
        if (null == authenticationType) {
            throw new BuilderException("SSH authentication type undetermined");
        }
        switch (authenticationType) {
            case privateKey: {
                String sshKeypath = sshConnectionInfo.getPrivateKeyfilePath();
                if (null == sshKeypath || "".equals(sshKeypath)) {
                    throw new BuilderException("SSH Keyfile path was not set");
                }
                if (!new File(sshKeypath).exists()) {
                    throw new BuilderException("SSH Keyfile does not exist: " + sshKeypath);
                }
                project.log("Using ssh keyfile: " + sshKeypath, 4);
                sshbase.setKeyfile(sshKeypath);
                String passphrase = sshConnectionInfo.getPrivateKeyPassphrase();
                if (null != passphrase) {
                    sshbase.setPassphrase(passphrase);
                    break;
                }
                sshbase.setPassphrase("");
                break;
            }
            case password: {
                boolean valid;
                String password = sshConnectionInfo.getPassword();
                boolean bl = valid = null != password && !"".equals(password);
                if (!valid) {
                    throw new BuilderException("SSH Password was not set");
                }
                sshbase.setPassword(password);
            }
        }
    }

    public static Scp buildScp(INodeEntry nodeentry, Project project, String remotepath, File sourceFile, SSHConnectionInfo sshConnectionInfo, int loglevel) throws BuilderException {
        Scp scp = new Scp();
        SSHTaskBuilder.buildScp(new SCPImpl(scp), nodeentry, project, remotepath, sourceFile, sshConnectionInfo, loglevel);
        return scp;
    }

    static void buildScp(SCPInterface scp, INodeEntry nodeentry, Project project, String remotepath, File sourceFile, SSHConnectionInfo sshConnectionInfo, int loglevel) throws BuilderException {
        if (null == sourceFile) {
            throw new BuilderException("sourceFile was not set");
        }
        if (null == remotepath) {
            throw new BuilderException("remotePath was not set");
        }
        String username = sshConnectionInfo.getUsername();
        if (null == username) {
            throw new BuilderException("username was not set");
        }
        SSHTaskBuilder.configureSSHBase(nodeentry, project, sshConnectionInfo, scp, loglevel);
        scp.setLocalFile(sourceFile.getAbsolutePath());
        String sshUriPrefix = username + "@" + nodeentry.extractHostname() + ":";
        scp.setRemoteTofile(sshUriPrefix + remotepath);
    }

    public static interface SSHConnectionInfo {
        public AuthenticationType getAuthenticationType();

        public String getPrivateKeyfilePath();

        public String getPrivateKeyPassphrase();

        public String getPassword();

        public int getSSHTimeout();

        public String getUsername();
    }

    public static enum AuthenticationType {
        privateKey,
        password;

    }

    public static class BuilderException
    extends Exception {
        public BuilderException() {
        }

        public BuilderException(String s) {
            super(s);
        }

        public BuilderException(String s, Throwable throwable) {
            super(s, throwable);
        }

        public BuilderException(Throwable throwable) {
            super(throwable);
        }
    }

    private static final class SCPImpl
    extends SSHBaseImpl
    implements SCPInterface {
        Scp instance;

        private SCPImpl(Scp instance) {
            super((SSHBase)instance);
            this.instance = instance;
        }

        @Override
        public void setLocalFile(String absolutePath) {
            this.instance.setLocalFile(absolutePath);
        }

        @Override
        public void setRemoteTofile(String s) {
            this.instance.setRemoteTofile(s);
        }
    }

    private static final class SSHExecImpl
    extends SSHBaseImpl
    implements SSHExecInterface {
        ExtSSHExec instance;

        private SSHExecImpl(ExtSSHExec instance) {
            super(instance);
            this.instance = instance;
        }

        @Override
        public void setCommand(String commandString) {
            this.instance.setCommand(commandString);
        }

        @Override
        public void setTimeout(long sshTimeout) {
            this.instance.setTimeout(sshTimeout);
        }

        @Override
        public void setOutputproperty(String s) {
            this.instance.setOutputproperty(s);
        }

        @Override
        public void addEnv(Environment.Variable env) {
            this.instance.addEnv(env);
        }
    }

    private static abstract class SSHBaseImpl
    implements SSHBaseInterface {
        SSHBase instance;

        @Override
        public void setFailonerror(boolean b) {
            this.instance.setFailonerror(b);
        }

        @Override
        public void setTrust(boolean b) {
            this.instance.setTrust(b);
        }

        @Override
        public void setProject(Project project) {
            this.instance.setProject(project);
        }

        @Override
        public void setVerbose(boolean b) {
            this.instance.setVerbose(b);
        }

        @Override
        public void setHost(String s) {
            this.instance.setHost(s);
        }

        @Override
        public void setPort(int portNum) {
            this.instance.setPort(portNum);
        }

        @Override
        public void setUsername(String username) {
            this.instance.setUsername(username);
        }

        @Override
        public void setKeyfile(String sshKeypath) {
            this.instance.setKeyfile(sshKeypath);
        }

        @Override
        public void setPassphrase(String s) {
            this.instance.setPassphrase(s);
        }

        @Override
        public void setPassword(String password) {
            this.instance.setPassword(password);
        }

        private SSHBaseImpl(SSHBase instance) {
            this.instance = instance;
        }

        @Override
        public void setKnownhosts(String knownhosts) {
            this.instance.setKnownhosts(knownhosts);
        }
    }

    static interface SCPInterface
    extends SSHBaseInterface {
        public void setLocalFile(String var1);

        public void setRemoteTofile(String var1);
    }

    static interface SSHExecInterface
    extends SSHBaseInterface,
    DataContextUtils.EnvironmentConfigurable {
        public void setCommand(String var1);

        public void setTimeout(long var1);

        public void setOutputproperty(String var1);
    }

    static interface SSHBaseInterface {
        public void setFailonerror(boolean var1);

        public void setTrust(boolean var1);

        public void setProject(Project var1);

        public void setVerbose(boolean var1);

        public void setHost(String var1);

        public void setPort(int var1);

        public void setUsername(String var1);

        public void setKeyfile(String var1);

        public void setPassphrase(String var1);

        public void setPassword(String var1);

        public void setKnownhosts(String var1);
    }
}

