/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.authorization;

import com.dtolabs.rundeck.core.authentication.Group;
import com.dtolabs.rundeck.core.authentication.Username;
import com.dtolabs.rundeck.core.authorization.Attribute;
import com.dtolabs.rundeck.core.authorization.Authorization;
import com.dtolabs.rundeck.core.authorization.AuthorizationException;
import com.dtolabs.rundeck.core.authorization.Decision;
import com.dtolabs.rundeck.core.authorization.LegacyAuthorization;
import com.dtolabs.rundeck.core.authorization.TimeanddayExp;
import com.dtolabs.rundeck.core.authorization.providers.PoliciesParseException;
import com.dtolabs.rundeck.core.authorization.providers.SAREAuthorization;
import com.dtolabs.rundeck.core.common.Framework;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.log4j.Logger;

public abstract class BaseAclsAuthorization
implements Authorization,
LegacyAuthorization {
    static Logger logger = Logger.getLogger(BaseAclsAuthorization.class);
    private final File aclBasedir;
    private final SAREAuthorization authorization;
    private String[] matchedRoles = new String[0];

    public BaseAclsAuthorization(Framework framework, File aclBasedir) throws IOException, PoliciesParseException {
        this.aclBasedir = aclBasedir;
        this.authorization = new SAREAuthorization(aclBasedir);
    }

    public static List<String> listRoles(File aclBasedir) throws IOException {
        try {
            SAREAuthorization authorization = new SAREAuthorization(aclBasedir);
            return authorization.hackMeSomeRoles();
        }
        catch (PoliciesParseException ppe) {
            return Collections.emptyList();
        }
    }

    void setMatchedRoles(String[] matchedRoles) {
        this.matchedRoles = matchedRoles;
    }

    @Override
    public String[] getMatchedRoles() {
        return null != this.matchedRoles ? (String[])this.matchedRoles.clone() : null;
    }

    @Override
    public String listMatchedRoles() {
        String[] matches = this.getMatchedRoles();
        StringBuffer mrBuffer = new StringBuffer();
        for (int i = 0; i < matches.length; ++i) {
            String matchedRole = matches[i];
            mrBuffer.append(matchedRole);
            if (i == matches.length - 1) continue;
            mrBuffer.append(" ");
        }
        return mrBuffer.toString();
    }

    boolean authorize(String user, String project, String resourceType, String resourceName, String module, String commandName) throws AuthorizationException {
        logger.debug((Object)("authorize(), user: " + user + ", " + " project: " + project + ", " + " deploymentType: " + resourceType + ", " + " deploymentName: " + resourceName + ", " + " module: " + module + ", " + " command: " + commandName));
        if (null == project) {
            return true;
        }
        Calendar rightNow = Calendar.getInstance();
        int day = rightNow.get(7) - 1;
        int hour = rightNow.get(11);
        int minute = rightNow.get(12);
        String timeandday = new TimeanddayExp(Integer.toString(day), Integer.toString(hour), Integer.toString(minute)).toString();
        String[] roles = this.determineUserRoles(user);
        this.setMatchedRoles(roles);
        if (null == roles) {
            logger.error((Object)("Unable to obtain role memberships for user: " + user));
            throw new AuthorizationException("Unable to obtain role memberships for user: " + user + " unknown error");
        }
        if (roles.length == 0) {
            logger.debug((Object)("no roles defined for user: " + user + " , returning false"));
            return false;
        }
        HashMap<String, String> moduleResource = new HashMap<String, String>();
        moduleResource.put("module", module);
        moduleResource.put("name", commandName);
        Subject subject = new Subject();
        subject.getPrincipals().add(new Username(user));
        for (String role : roles) {
            subject.getPrincipals().add(new Group(role));
        }
        HashSet<Attribute> environment = new HashSet<Attribute>();
        environment.add(new Attribute(URI.create("http://dtolabs.com/rundeck/env/resource-type"), resourceType));
        environment.add(new Attribute(URI.create("http://dtolabs.com/rundeck/env/resource-name"), resourceName));
        environment.add(new Attribute(URI.create("http://dtolabs.com/rundeck/env/project"), project));
        environment.add(new Attribute(URI.create("http://dtolabs.com/rundeck/env/now.cron"), timeandday));
        Decision decision = this.authorization.evaluate(moduleResource, subject, "EXECUTE", environment);
        return decision.isAuthorized();
    }

    @Override
    public boolean authorizeScript(String user, String project, String adhocScript) throws AuthorizationException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("authorize(), user: " + user + ", " + " project: " + project + ", " + " adhocScript: " + adhocScript));
        }
        if (null == project) {
            return true;
        }
        Calendar rightNow = Calendar.getInstance();
        int day = rightNow.get(7) - 1;
        int hour = rightNow.get(11);
        int minute = rightNow.get(12);
        String timeandday = new TimeanddayExp(Integer.toString(day), Integer.toString(hour), Integer.toString(minute)).toString();
        String[] roles = this.determineUserRoles(user);
        this.setMatchedRoles(roles);
        if (null == roles) {
            logger.error((Object)("Unable to obtain role memberships for user: " + user));
            throw new AuthorizationException("Unable to obtain role memberships for user: " + user + " unknown error");
        }
        if (roles.length == 0) {
            logger.debug((Object)("no roles defined for user: " + user + " , returning false"));
            return false;
        }
        HashMap<String, String> resource = new HashMap<String, String>();
        resource.put("job", adhocScript);
        Subject subject = new Subject();
        subject.getPrincipals().add(new Username(user));
        for (String role : roles) {
            subject.getPrincipals().add(new Group(role));
        }
        HashSet<Attribute> environment = new HashSet<Attribute>();
        environment.add(new Attribute(URI.create("http://dtolabs.com/rundeck/env/project"), project));
        environment.add(new Attribute(URI.create("http://dtolabs.com/rundeck/env/now.cron"), timeandday));
        Decision decision = this.authorization.evaluate(resource, subject, "EXECUTE", environment);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(user + " authorized: " + decision));
        }
        return decision.isAuthorized();
    }

    public abstract String[] determineUserRoles(String var1);

    public String toString() {
        return "BaseAclsAuthorization{aclBasedir=" + this.aclBasedir + "}";
    }

    public File getAclBasedir() {
        return this.aclBasedir;
    }

    @Override
    public Decision evaluate(Map<String, String> resource, Subject subject, String action, Set<Attribute> environment) {
        return this.authorization.evaluate(resource, subject, action, environment);
    }

    @Override
    public Set<Decision> evaluate(Set<Map<String, String>> resources, Subject subject, Set<String> action, Set<Attribute> environment) {
        return this.authorization.evaluate(resources, subject, action, environment);
    }
}

