/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.authorization;

import com.dtolabs.rundeck.core.authorization.AuthorizationException;
import com.dtolabs.rundeck.core.jndi.JndiConfig;
import com.dtolabs.rundeck.core.utils.IPropertyLookup;

public class JndiConfigParser {
    private final IPropertyLookup propertyLookup;
    static final String PREFIX = "jndi.";
    static final String CONNECTTION_NAME = "jndi.connectionName";
    static final String CONNECTION_PASS = "jndi.connectionPassword";
    static final String CONNECTION_URL = "jndi.connectionUrl";
    static final String ROLE_BASE = "jndi.roleBase";
    static final String ROLE_NAME = "jndi.roleNameRDN";
    static final String ROLE_MEMBER = "jndi.roleMemberRDN";
    static final String USER_BASE = "jndi.userBase";
    static final String USER_NAME_RDN = "jndi.userNameRDN";
    public static final String JNDI_RESOURCE_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    static final String[] REQUIRED_PROPS = new String[]{"jndi.connectionName", "jndi.connectionPassword", "jndi.connectionUrl", "jndi.roleBase", "jndi.roleNameRDN", "jndi.roleMemberRDN", "jndi.userBase", "jndi.userNameRDN"};

    protected JndiConfigParser(IPropertyLookup propertyLookup) {
        this.propertyLookup = propertyLookup;
    }

    private String lookup(String key) {
        if (!this.propertyLookup.hasProperty(key)) {
            throw new AuthorizationException(key + " jndi config property not found");
        }
        String value = this.propertyLookup.getProperty(key);
        if (null == value || "".equals(value)) {
            throw new AuthorizationException(key + " property has null or empty value");
        }
        return value;
    }

    protected JndiConfig parse() {
        return new JndiConfig(this.lookup(CONNECTTION_NAME), this.lookup(CONNECTION_PASS), this.lookup(CONNECTION_URL), this.lookup(ROLE_BASE), this.lookup(ROLE_NAME), this.lookup(ROLE_MEMBER), this.lookup(USER_BASE), this.lookup(USER_NAME_RDN));
    }
}

