/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.authorization.providers;

import com.dtolabs.rundeck.core.authorization.Attribute;
import com.dtolabs.rundeck.core.authorization.Explanation;
import com.dtolabs.rundeck.core.authorization.providers.AclContext;
import com.dtolabs.rundeck.core.authorization.providers.ContextDecision;
import com.dtolabs.rundeck.core.authorization.providers.ContextEvaluation;
import com.dtolabs.rundeck.core.authorization.providers.EnvironmentalContext;
import com.dtolabs.rundeck.core.authorization.providers.Policy;
import com.dtolabs.rundeck.core.utils.Converter;
import com.dtolabs.rundeck.core.utils.PairImpl;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.PredicateUtils;
import org.apache.log4j.Logger;

final class YamlPolicy
implements Policy {
    static final Logger logger = Logger.getLogger((String)YamlPolicy.class.getName());
    public static final String TYPE_PROPERTY = "type";
    public static final String FOR_SECTION = "for";
    public static final String JOB_TYPE = "job";
    public static final String RULES_SECTION = "rules";
    public static final String ACTIONS_SECTION = "actions";
    public static final String CONTEXT_SECTION = "context";
    public Map policyInput;
    private Set<String> usernames = new HashSet<String>();
    private Set<Object> groups = new HashSet<Object>();
    AclContext aclContext;
    private File sourceFile;
    private int sourceIndex;
    private EnvironmentalContext environment;
    private boolean envchecked;

    YamlPolicy(Map policyInput, File sourceFile, int sourceIndex) {
        this.policyInput = policyInput;
        this.sourceFile = sourceFile;
        this.sourceIndex = sourceIndex;
        this.parseByClause();
        this.createAclContext();
        this.parseEnvironment();
    }

    public YamlPolicy(Map yamlDoc) {
        this(yamlDoc, null, -1);
    }

    String identify() {
        return null != this.policyInput.get("id") ? this.policyInput.get("id").toString() : (null != this.sourceFile ? this.sourceFile.getAbsolutePath() : "(unknown file)") + (this.sourceIndex >= 0 ? "[" + this.sourceIndex + "]" : "");
    }

    @Override
    public Set<String> getUsernames() {
        return this.usernames;
    }

    @Override
    public EnvironmentalContext getEnvironment() {
        return this.environment;
    }

    private void parseEnvironment() {
        Object ctxClause = this.policyInput.get(CONTEXT_SECTION);
        if (null != ctxClause && ctxClause instanceof Map) {
            this.environment = new YamlEnvironmentalContext("http://dtolabs.com/rundeck/env/", (Map)ctxClause);
        }
    }

    @Override
    public Set<Object> getGroups() {
        return this.groups;
    }

    @Override
    public AclContext getContext() {
        return this.aclContext;
    }

    private void createAclContext() {
        this.aclContext = new YamlAclContext(this.policyInput, new TypeContextFactory(){

            @Override
            public AclContext createAclContext(List typeSection) {
                return new TypeContext(YamlPolicy.this.createTypeRules(typeSection));
            }
        }, new LegacyContextFactory(){

            @Override
            public AclContext createLegacyContext(Map rules) {
                return new LegacyRulesContext(rules);
            }
        });
    }

    List<ContextMatcher> createTypeRules(List typeSection) {
        ArrayList<ContextMatcher> rules = new ArrayList<ContextMatcher>();
        int i = 1;
        for (Object o : typeSection) {
            Map section = (Map)o;
            rules.add(this.createTypeRuleContext(section, i));
            ++i;
        }
        return rules;
    }

    ContextMatcher createTypeRuleContext(Map section, int i) {
        return new TypeRuleContextMatcher(section, i, this);
    }

    private static String createLegacyJobResourcePath(Map<String, String> resource) {
        return resource.get("group") + "/" + resource.get(JOB_TYPE);
    }

    private void parseByClause() {
        Object byClause = this.policyInput.get("by");
        if (byClause == null) {
            return;
        }
        if (!(byClause instanceof Map)) {
            return;
        }
        Map by = (Map)byClause;
        Object u = by.get("username");
        Object g = by.get("group");
        if (null != u) {
            if (u instanceof String) {
                this.usernames.add((String)u);
            } else if (u instanceof Collection) {
                for (Object o : (Collection)u) {
                    if (!(o instanceof String)) continue;
                    this.usernames.add((String)o);
                }
            }
        }
        if (null != g) {
            if (g instanceof String) {
                this.groups.add(g);
            } else if (g instanceof Collection) {
                for (Object o : (Collection)g) {
                    if (!(o instanceof String)) continue;
                    this.groups.add(o);
                }
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("YamlPolicy[id:");
        sb.append(this.identify()).append(", groups:");
        for (Object group : this.getGroups()) {
            sb.append(group.toString()).append(" ");
        }
        sb.append("]");
        return sb.toString();
    }

    static class YamlAclContext
    implements AclContext {
        private String description = "Not Evaluated: ";
        Map policyDef;
        private final ConcurrentHashMap<String, AclContext> typeContexts = new ConcurrentHashMap();
        TypeContextFactory typeContextFactory;
        LegacyContextFactory legacyContextFactory;
        private Map forsection;
        private ContextDecision invalid;
        static final ContextDecision NO_RESOURCE_TYPE_DECISION = new ContextDecision(Explanation.Code.REJECTED_NO_RESOURCE_TYPE, false, Collections.singletonList(new ContextEvaluation(Explanation.Code.REJECTED_NO_RESOURCE_TYPE, "Resource has no 'type'.")));

        YamlAclContext(Map policyDef, TypeContextFactory typeContextFactory, LegacyContextFactory legacyContextFactory) {
            this.policyDef = policyDef;
            this.typeContextFactory = typeContextFactory;
            this.legacyContextFactory = legacyContextFactory;
            this.initialize();
        }

        private void initialize() {
            boolean useLegacyRules;
            ArrayList<ContextEvaluation> evaluations = new ArrayList<ContextEvaluation>();
            Object descriptionValue = this.policyDef.get("description");
            if (descriptionValue == null || !(descriptionValue instanceof String)) {
                evaluations.add(new ContextEvaluation(Explanation.Code.REJECTED_NO_DESCRIPTION_PROVIDED, "Policy is missing a description."));
                this.invalid = new ContextDecision(Explanation.Code.REJECTED_NO_DESCRIPTION_PROVIDED, false, evaluations);
                return;
            }
            this.description = (String)descriptionValue;
            Object forMap = this.policyDef.get(YamlPolicy.FOR_SECTION);
            if (null != forMap && !(forMap instanceof Map)) {
                evaluations.add(new ContextEvaluation(Explanation.Code.REJECTED_INVALID_FOR_SECTION, "'for' was not declared"));
                this.invalid = new ContextDecision(Explanation.Code.REJECTED_INVALID_FOR_SECTION, false, evaluations);
                return;
            }
            this.forsection = (Map)forMap;
            boolean bl = useLegacyRules = this.policyDef.containsKey(YamlPolicy.RULES_SECTION) && this.policyDef.get(YamlPolicy.RULES_SECTION) instanceof Map;
            if (null != this.forsection) {
                for (Object key : this.forsection.keySet()) {
                    if (!(key instanceof String)) continue;
                    String type = (String)key;
                    Object typeSection = this.forsection.get(key);
                    this.typeContexts.putIfAbsent(type, this.createTypeContext((List)typeSection));
                }
            } else if (useLegacyRules && null != this.legacyContextFactory) {
                Object rulesValue = this.policyDef.get(YamlPolicy.RULES_SECTION);
                Map rules = (Map)rulesValue;
                this.typeContexts.putIfAbsent(YamlPolicy.JOB_TYPE, this.createLegacyContext(rules));
            }
        }

        public String toString() {
            return "Context: " + this.description;
        }

        private AclContext createTypeContext(List typeSection) {
            return this.typeContextFactory.createAclContext(typeSection);
        }

        private AclContext createLegacyContext(Map rules) {
            return this.legacyContextFactory.createLegacyContext(rules);
        }

        private static ContextDecision createNoRulesDecision(String type) {
            return new ContextDecision(Explanation.Code.REJECTED_NO_RULES_DECLARED, false, Collections.singletonList(new ContextEvaluation(Explanation.Code.REJECTED_NO_RULES_DECLARED, "Section for type '" + type + "' was not declared in " + YamlPolicy.FOR_SECTION + " section")));
        }

        @Override
        public ContextDecision includes(Map<String, String> resourceMap, String action) {
            if (null != this.invalid) {
                return this.invalid;
            }
            String type = resourceMap.get(YamlPolicy.TYPE_PROPERTY);
            if (null == type) {
                return NO_RESOURCE_TYPE_DECISION;
            }
            AclContext typeContext = this.typeContexts.get(type);
            if (null == typeContext) {
                return YamlAclContext.createNoRulesDecision(type);
            }
            return typeContext.includes(resourceMap, action);
        }
    }

    static class LegacyRulesContext
    implements AclContext {
        private final Map rules;
        private ConcurrentHashMap<String, Pattern> patternCache = new ConcurrentHashMap();

        public LegacyRulesContext(Map rules) {
            this.rules = rules;
        }

        private boolean regexMatches(String regex, String value) {
            if (!this.patternCache.containsKey(regex)) {
                this.patternCache.putIfAbsent(regex, Pattern.compile(regex));
            }
            Pattern pattern = this.patternCache.get(regex);
            Matcher matcher = pattern.matcher(value);
            return matcher.matches();
        }

        @Override
        public ContextDecision includes(Map<String, String> resourceMap, String action) {
            String resource = YamlPolicy.createLegacyJobResourcePath(resourceMap);
            ArrayList<ContextEvaluation> evaluations = new ArrayList<ContextEvaluation>();
            Set entries = this.rules.entrySet();
            for (Map.Entry entry : entries) {
                Object actions;
                Object ruleKey = entry.getKey();
                if (!(ruleKey instanceof String)) {
                    evaluations.add(new ContextEvaluation(Explanation.Code.REJECTED_CONTEXT_EVALUATION_ERROR, "Invalid key type: " + ruleKey.getClass().getName()));
                    continue;
                }
                String rule = (String)ruleKey;
                if (rule == null || rule.length() == 0) {
                    evaluations.add(new ContextEvaluation(Explanation.Code.REJECTED_CONTEXT_EVALUATION_ERROR, "Resource is empty or null"));
                }
                if (!this.regexMatches(rule, resource)) continue;
                Map ruleMap = (Map)entry.getValue();
                Object actionsKey = ruleMap.get(YamlPolicy.ACTIONS_SECTION);
                if (actionsKey == null) {
                    evaluations.add(new ContextEvaluation(Explanation.Code.REJECTED_ACTIONS_DECLARED_EMPTY, "No actions configured"));
                    continue;
                }
                if (actionsKey instanceof String) {
                    actions = (String)actionsKey;
                    if ("*".equals(actions) || ((String)actions).contains(action)) {
                        evaluations.add(new ContextEvaluation(Explanation.Code.GRANTED_ACTIONS_AND_COMMANDS_MATCHED, "Legacy rule: " + rule + " action: " + (String)actions));
                        return new ContextDecision(Explanation.Code.GRANTED_ACTIONS_AND_COMMANDS_MATCHED, true, evaluations);
                    }
                } else if (actionsKey instanceof List) {
                    actions = (List)actionsKey;
                    if (actions.contains(action)) {
                        evaluations.add(new ContextEvaluation(Explanation.Code.GRANTED_ACTIONS_AND_COMMANDS_MATCHED, "Legacy rule: " + rule + " action: " + actions));
                        return new ContextDecision(Explanation.Code.GRANTED_ACTIONS_AND_COMMANDS_MATCHED, true, evaluations);
                    }
                } else {
                    evaluations.add(new ContextEvaluation(Explanation.Code.REJECTED_CONTEXT_EVALUATION_ERROR, "Invalid action type."));
                }
                evaluations.add(new ContextEvaluation(Explanation.Code.REJECTED_NO_ACTIONS_MATCHED, "No actions matched"));
            }
            return new ContextDecision(Explanation.Code.REJECTED, false, evaluations);
        }
    }

    static class SetContainsPredicate
    implements Predicate {
        HashSet<String> items = new HashSet();

        SetContainsPredicate(Object item) {
            if (item instanceof String) {
                this.items.add((String)item);
            } else if (item instanceof List) {
                this.items.addAll((List)item);
            } else {
                this.items = null;
            }
        }

        public boolean evaluate(Object o) {
            HashSet<String> input;
            if (null == this.items || null == o) {
                return false;
            }
            if (o instanceof String) {
                String[] split;
                HashSet<String> hs = new HashSet<String>();
                String str = (String)o;
                for (String s : split = str.split(",")) {
                    hs.add(s.trim());
                }
                input = hs;
            } else if (o instanceof Collection) {
                input = (HashSet<String>)o;
            } else {
                return false;
            }
            return CollectionUtils.isSubCollection(this.items, (Collection)input);
        }
    }

    static class RegexPredicate
    implements Predicate {
        Pattern regex;

        RegexPredicate(Pattern regex) {
            this.regex = regex;
        }

        public boolean evaluate(Object o) {
            return o instanceof String && this.regex.matcher((String)o).matches();
        }
    }

    static class TypeRuleContextMatcher
    implements ContextMatcher {
        public static final String MATCH_SECTION = "match";
        public static final String EQUALS_SECTION = "equals";
        public static final String CONTAINS_SECTION = "contains";
        public static final String ALLOW_ACTIONS = "allow";
        public static final String DENY_ACTIONS = "deny";
        Map ruleSection;
        int index;
        YamlPolicy policy;
        private static ConcurrentHashMap<String, Pattern> patternCache = new ConcurrentHashMap();

        TypeRuleContextMatcher(Map ruleSection, int index) {
            this(ruleSection, index, null);
        }

        TypeRuleContextMatcher(Map ruleSection, int index, YamlPolicy policy) {
            this.ruleSection = ruleSection;
            this.index = index;
            this.policy = policy;
        }

        public String toString() {
            return this.identify();
        }

        private String identify() {
            return (null != this.policy ? this.policy.identify() : "(unknown policy)") + "[rule: " + this.index + ": " + this.ruleSection + "]";
        }

        private Pattern patternForRegex(String regex) {
            if (!patternCache.containsKey(regex)) {
                Pattern compile = null;
                try {
                    compile = Pattern.compile(regex);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (null == compile) {
                    compile = Pattern.compile("^" + Pattern.quote(regex) + "$");
                }
                patternCache.putIfAbsent(regex, compile);
            }
            return patternCache.get(regex);
        }

        @Override
        public MatchedContext includes(Map<String, String> resource, String action) {
            ArrayList<ContextEvaluation> evaluations = new ArrayList<ContextEvaluation>();
            if (!this.matchesRuleSections(resource, evaluations)) {
                return new MatchedContext(false, new ContextDecision(Explanation.Code.REJECTED, false, evaluations));
            }
            return new MatchedContext(true, this.evaluateActions(action, evaluations));
        }

        ContextDecision evaluateActions(String action, List<ContextEvaluation> evaluations) {
            boolean denied = false;
            if (this.ruleSection.containsKey(DENY_ACTIONS)) {
                HashSet<String> actions = new HashSet<String>();
                Object actionsObj = this.ruleSection.get(DENY_ACTIONS);
                if (actionsObj instanceof String) {
                    String actionStr = (String)actionsObj;
                    actions.add(actionStr);
                } else if (actionsObj instanceof List) {
                    actions.addAll((List)actionsObj);
                } else {
                    evaluations.add(new ContextEvaluation(Explanation.Code.REJECTED_CONTEXT_EVALUATION_ERROR, "Invalid action type."));
                }
                if (0 == actions.size()) {
                    logger.warn((Object)(this.identify() + ": No actions defined in Deny section"));
                } else if (actions.contains("*") || actions.contains(action)) {
                    evaluations.add(new ContextEvaluation(Explanation.Code.REJECTED_DENIED, this + " for actions: " + actions));
                    denied = true;
                }
            }
            if (denied) {
                return new ContextDecision(Explanation.Code.REJECTED_DENIED, false, evaluations);
            }
            boolean allowed = false;
            if (this.ruleSection.containsKey(ALLOW_ACTIONS)) {
                HashSet<String> actions = new HashSet<String>();
                Object actionsObj = this.ruleSection.get(ALLOW_ACTIONS);
                if (actionsObj instanceof String) {
                    String actionStr = (String)actionsObj;
                    actions.add(actionStr);
                } else if (actionsObj instanceof List) {
                    actions.addAll((List)actionsObj);
                } else {
                    evaluations.add(new ContextEvaluation(Explanation.Code.REJECTED_CONTEXT_EVALUATION_ERROR, "Invalid action type."));
                }
                if (0 == actions.size()) {
                    logger.warn((Object)(this.identify() + ": No actions defined in Allow section"));
                } else if (actions.contains("*") || actions.contains(action)) {
                    evaluations.add(new ContextEvaluation(Explanation.Code.GRANTED_ACTIONS_AND_COMMANDS_MATCHED, this + " for actions: " + actions));
                    allowed = true;
                }
            }
            if (allowed) {
                return new ContextDecision(Explanation.Code.GRANTED_ACTIONS_AND_COMMANDS_MATCHED, true, evaluations);
            }
            return new ContextDecision(Explanation.Code.REJECTED, false, evaluations);
        }

        boolean matchesRuleSections(Map<String, String> resource, List<ContextEvaluation> evaluations) {
            int matchesRequired = 0;
            int matchesMet = 0;
            if (this.ruleSection.containsKey(MATCH_SECTION)) {
                ++matchesRequired;
                if (this.ruleMatchesMatchSection(resource, this.ruleSection)) {
                    ++matchesMet;
                } else {
                    evaluations.add(new ContextEvaluation(Explanation.Code.REJECTED, "match section did not match"));
                }
            }
            if (this.ruleSection.containsKey(EQUALS_SECTION)) {
                ++matchesRequired;
                if (this.ruleMatchesEqualsSection(resource, this.ruleSection)) {
                    ++matchesMet;
                } else {
                    evaluations.add(new ContextEvaluation(Explanation.Code.REJECTED, "equals section did not match"));
                }
            }
            if (this.ruleSection.containsKey(CONTAINS_SECTION)) {
                ++matchesRequired;
                if (this.ruleMatchesContainsSection(resource, this.ruleSection)) {
                    ++matchesMet;
                } else {
                    evaluations.add(new ContextEvaluation(Explanation.Code.REJECTED, "contains section did not match"));
                }
            }
            return matchesMet == matchesRequired;
        }

        private boolean validRuleSection(Map section) {
            return null != section && section.size() > 0;
        }

        boolean ruleMatchesContainsSection(Map<String, String> resource, Map ruleSection) {
            Map section = (Map)ruleSection.get(CONTAINS_SECTION);
            return this.validRuleSection(section) && this.predicateMatchRules(section, resource, true, new Converter<String, Predicate>(){

                @Override
                public Predicate convert(String o) {
                    return new SetContainsPredicate(o);
                }
            });
        }

        boolean ruleMatchesEqualsSection(Map<String, String> resource, Map ruleSection) {
            Map section = (Map)ruleSection.get(EQUALS_SECTION);
            return this.validRuleSection(section) && this.predicateMatchRules(section, resource, false, new Converter<String, Predicate>(){

                @Override
                public Predicate convert(String o) {
                    return PredicateUtils.equalPredicate((Object)o);
                }
            });
        }

        boolean ruleMatchesMatchSection(Map<String, String> resource, Map ruleSection) {
            Map section = (Map)ruleSection.get(MATCH_SECTION);
            return this.validRuleSection(section) && this.predicateMatchRules(section, resource, true, new Converter<String, Predicate>(){

                @Override
                public Predicate convert(String o) {
                    return new RegexPredicate(TypeRuleContextMatcher.this.patternForRegex(o));
                }
            });
        }

        boolean predicateMatchRules(Map match, Map<String, String> resource, boolean allowListMatch, Converter<String, Predicate> predicateTransformer) {
            for (Map.Entry o : match.entrySet()) {
                Object test;
                Map.Entry entry = o;
                String key = (String)entry.getKey();
                boolean matched = this.applyTest(resource, allowListMatch, predicateTransformer, key, test = entry.getValue());
                if (matched) continue;
                return false;
            }
            return true;
        }

        boolean applyTest(Map<String, String> resource, boolean allowListMatch, Converter<String, Predicate> predicateTransformer, String key, Object test) {
            ArrayList<Predicate> tests = new ArrayList<Predicate>();
            if (allowListMatch && test instanceof List) {
                for (Object item : (List)test) {
                    String s = (String)item;
                    tests.add(predicateTransformer.convert(s));
                }
            } else if (test instanceof String) {
                tests.add(predicateTransformer.convert((String)test));
            } else {
                logger.error((Object)(this.identify() + ": cannot evaluate unexpected type: " + test.getClass().getName()));
                return false;
            }
            return PredicateUtils.allPredicate(tests).evaluate((Object)resource.get(key));
        }
    }

    static interface ContextMatcher {
        public MatchedContext includes(Map<String, String> var1, String var2);
    }

    static class MatchedContext
    extends PairImpl<Boolean, ContextDecision> {
        MatchedContext(Boolean matched, ContextDecision decision) {
            super(matched, decision);
        }

        public Boolean isMatched() {
            return (Boolean)this.getFirst();
        }

        public ContextDecision getDecision() {
            return (ContextDecision)this.getSecond();
        }
    }

    static class TypeContext
    implements AclContext {
        private final List<ContextMatcher> typeRules;

        public TypeContext(List<ContextMatcher> typeRules) {
            this.typeRules = typeRules;
        }

        @Override
        public ContextDecision includes(Map<String, String> resource, String action) {
            ArrayList<ContextEvaluation> evaluations = new ArrayList<ContextEvaluation>();
            boolean allowed = false;
            boolean denied = false;
            block0: for (ContextMatcher matcher : this.typeRules) {
                MatchedContext matched = matcher.includes(resource, action);
                if (!matched.isMatched().booleanValue()) continue;
                ContextDecision decision = matched.getDecision();
                if (decision.granted()) {
                    allowed = true;
                }
                if (Explanation.Code.REJECTED_DENIED == decision.getCode()) {
                    denied = true;
                }
                evaluations.addAll(decision.getEvaluations());
                if (denied) continue;
                for (ContextEvaluation contextEvaluation : decision.getEvaluations()) {
                    if (Explanation.Code.REJECTED_DENIED != contextEvaluation.id) continue;
                    ContextEvaluation deniedEvaluation = contextEvaluation;
                    denied = true;
                    continue block0;
                }
            }
            return new ContextDecision(denied ? Explanation.Code.REJECTED_DENIED : (allowed ? Explanation.Code.GRANTED : Explanation.Code.REJECTED), allowed && !denied, evaluations);
        }
    }

    static interface TypeContextFactory {
        public AclContext createAclContext(List var1);
    }

    static interface LegacyContextFactory {
        public AclContext createLegacyContext(Map var1);
    }

    static class YamlEnvironmentalContext
    implements EnvironmentalContext {
        Map<URI, String> matcher = new HashMap<URI, String>();
        Map<URI, Pattern> matcherRegex = new HashMap<URI, Pattern>();
        private boolean valid = false;
        private String validation;
        private String description;
        private static Comparator<Attribute> comparator = new Comparator<Attribute>(){

            @Override
            public int compare(Attribute attribute, Attribute attribute2) {
                int u = attribute.property.compareTo(attribute2.property);
                if (u == 0) {
                    return attribute.value.compareTo(attribute2.value);
                }
                return u;
            }
        };
        private HashMap<String, Boolean> memoize = new HashMap();

        YamlEnvironmentalContext(String uriPrefix, Map ctx) {
            boolean invalidentry = false;
            ArrayList<String> errors = new ArrayList<String>();
            for (Map.Entry o : ctx.entrySet()) {
                Map.Entry entry = o;
                if (entry.getKey() instanceof String) {
                    URI uri;
                    String path = (String)entry.getKey();
                    try {
                        uri = new URI(uriPrefix + path);
                    }
                    catch (URISyntaxException e) {
                        errors.add("Context section: " + entry.getKey() + ": invalid URI: " + e.getMessage());
                        invalidentry = true;
                        continue;
                    }
                    if (entry.getValue() instanceof String) {
                        String value = (String)entry.getValue();
                        this.matcher.put(uri, value);
                        try {
                            Pattern compile = Pattern.compile(value);
                            this.matcherRegex.put(uri, compile);
                        }
                        catch (PatternSyntaxException e) {}
                        continue;
                    }
                    errors.add("Context section: " + entry.getKey() + ": expected 'String', saw: " + entry.getValue().getClass().getName());
                    invalidentry = true;
                    continue;
                }
                errors.add("Context section key expected 'String', saw: " + entry.getKey().getClass().getName());
                invalidentry = true;
            }
            if (errors.size() > 0) {
                StringBuffer sb = new StringBuffer();
                for (String error : errors) {
                    if (sb.length() > 0) {
                        sb.append("; ");
                    }
                    sb.append(error);
                }
                this.validation = sb.toString();
            }
            this.valid = !invalidentry && this.matcher.size() >= 1;
            this.description = "YamlEnvironmentalContext{" + (this.valid ? ", valid=" + this.valid + ", context='" + this.matcher + '\'' + '}' : ", valid=" + this.valid + ", validation='" + this.getValidation() + '\'' + '}');
        }

        @Override
        public boolean matches(Set<Attribute> environment) {
            return this.memo(environment);
        }

        private boolean memo(Set<Attribute> environment) {
            String ident = this.ident(environment);
            Boolean found = this.memoize.get(ident);
            if (null == found) {
                found = this.evaluateMatches(environment);
                this.memoize.put(ident, found);
            }
            return found;
        }

        private String ident(Set<Attribute> environment) {
            StringBuilder sb = new StringBuilder();
            TreeSet<Attribute> attributes = new TreeSet<Attribute>(comparator);
            attributes.addAll(environment);
            for (Attribute attribute : attributes) {
                sb.append(attribute.hashCode());
                sb.append("/");
            }
            return sb.toString();
        }

        private boolean evaluateMatches(Set<Attribute> environment) {
            HashSet<URI> matchedSet = new HashSet<URI>();
            for (Attribute attribute : environment) {
                Pattern pattern = this.matcherRegex.get(attribute.property);
                String matchValue = this.matcher.get(attribute.property);
                if (null != matchValue && matchValue.equals(attribute.value)) {
                    matchedSet.add(attribute.property);
                    continue;
                }
                if (null == pattern || !pattern.matcher(attribute.value).matches()) continue;
                matchedSet.add(attribute.property);
            }
            return this.valid && matchedSet.size() == this.matcher.keySet().size();
        }

        @Override
        public boolean isValid() {
            return this.valid;
        }

        public String toString() {
            return this.description;
        }

        public String getValidation() {
            return this.validation;
        }
    }
}

