/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.cli;

import com.dtolabs.rundeck.core.Constants;
import com.dtolabs.rundeck.core.CoreException;
import com.dtolabs.rundeck.core.NodesetEmptyException;
import com.dtolabs.rundeck.core.NodesetFailureException;
import com.dtolabs.rundeck.core.VersionConstants;
import com.dtolabs.rundeck.core.cli.CLIExecutionListener;
import com.dtolabs.rundeck.core.cli.CLILoggerParams;
import com.dtolabs.rundeck.core.cli.CLITool;
import com.dtolabs.rundeck.core.cli.FailedNodesFilestore;
import com.dtolabs.rundeck.core.cli.project.ProjectToolException;
import com.dtolabs.rundeck.core.cli.queue.ConsoleExecutionFollowReceiver;
import com.dtolabs.rundeck.core.cli.queue.QueueTool;
import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.FrameworkProject;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.common.INodeSet;
import com.dtolabs.rundeck.core.common.NodeFileParserException;
import com.dtolabs.rundeck.core.common.NodeFilter;
import com.dtolabs.rundeck.core.common.NodesGeneratorException;
import com.dtolabs.rundeck.core.common.NodesSelector;
import com.dtolabs.rundeck.core.common.NodesYamlGenerator;
import com.dtolabs.rundeck.core.dispatcher.CentralDispatcherException;
import com.dtolabs.rundeck.core.dispatcher.IDispatchedScript;
import com.dtolabs.rundeck.core.dispatcher.QueuedItem;
import com.dtolabs.rundeck.core.dispatcher.QueuedItemResult;
import com.dtolabs.rundeck.core.execution.ExecutionException;
import com.dtolabs.rundeck.core.execution.ExecutionListener;
import com.dtolabs.rundeck.core.execution.ExecutionResult;
import com.dtolabs.rundeck.core.execution.ExecutionService;
import com.dtolabs.rundeck.core.execution.StatusResult;
import com.dtolabs.rundeck.core.execution.StepExecutionItem;
import com.dtolabs.rundeck.core.execution.script.ScriptfileUtils;
import com.dtolabs.rundeck.core.execution.workflow.StepExecutionContext;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.impl.ExecCommandBase;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.impl.ScriptFileCommandBase;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.impl.ScriptURLCommandBase;
import com.dtolabs.rundeck.core.plugins.configuration.ConfigurationException;
import com.dtolabs.rundeck.core.resources.FileResourceModelSource;
import com.dtolabs.rundeck.core.resources.ResourceModelSourceException;
import com.dtolabs.rundeck.core.utils.ExecToolCommandLogger;
import com.dtolabs.rundeck.core.utils.NodeSet;
import com.dtolabs.rundeck.core.utils.OptsUtil;
import com.dtolabs.rundeck.core.utils.Reformatter;
import com.dtolabs.rundeck.core.utils.StringArrayUtil;
import com.dtolabs.rundeck.core.utils.ThreadBoundOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.PropertyConfigurator;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;

public class ExecTool
implements CLITool,
IDispatchedScript,
CLILoggerParams,
StepExecutionContext {
    static final String FILTER_EXCLUDE_PRECEDENCE_OPT = "Z";
    static final String FILTER_EXCLUDE_PRECEDENCE_LONG = "filter-exclude-precedence";
    private boolean argVerbose = false;
    private boolean argDebug = false;
    private boolean argQuiet = false;
    private boolean argKeepgoing;
    private String argIncludeNodes;
    private String argExcludeNodes;
    private File failedNodes;
    private Integer argThreadCount = 1;
    private String argProject;
    private boolean argNoQueue;
    private boolean argTerse;
    private boolean argFollow;
    private boolean argProgress;
    private boolean shouldExit = false;
    protected PrintStream err = System.err;
    protected PrintStream out = System.out;
    protected CommandLine cli;
    protected static final Options options = new Options();
    public static final String NO_QUEUE_FLAG = "L";
    private Framework framework;
    private String baseDir;
    protected NodeFormatter nodeFormatter;
    private boolean argExcludePrecedence = true;
    private String scriptpath;
    private InputStream scriptAsStream;
    private boolean inlineScript;
    private String inlineScriptContent;
    private String scriptURLString;
    private String argNodesFile;
    private File nodesFile;
    private String[] argsDeferred;
    private Map excludeMap = new HashMap();
    private Map includeMap = new HashMap();
    private String[] inputArgs;
    public static final int NODESET_EMPTY_EXIT_CODE = 3;
    public static final String DEFAULT_LOG_FORMAT = "[%user@%node %command][%level] %message";
    public static final String FRAMEWORK_LOG_RUNDECK_EXEC_CONSOLE_FORMAT = "framework.log.dispatch.console.format";
    ExecutionListener mylistener;
    InputStream instream = System.in;

    void setFramework(Framework framework) {
        this.framework = framework;
    }

    ExecTool() {
        this(Constants.getSystemBaseDir());
    }

    ExecTool(String baseDir) {
        this(Framework.getInstance(baseDir));
    }

    public ExecTool(Framework framework) {
        this.framework = framework;
        this.nodeFormatter = new NodeYAMLFormatter();
    }

    @Override
    public CommandLine parseArgs(String[] args) {
        this.inputArgs = (String[])args.clone();
        int lastArg = -1;
        for (int i = 0; i < args.length; ++i) {
            if (!"--".equals(args[i])) continue;
            lastArg = i;
            break;
        }
        if (lastArg >= 0) {
            int argslen = args.length - (lastArg + 1);
            this.argsDeferred = new String[argslen];
            System.arraycopy(args, lastArg + 1, this.argsDeferred, 0, argslen);
        }
        PosixParser parser = new PosixParser();
        try {
            this.cli = parser.parse(options, args);
        }
        catch (ParseException e) {
            this.help();
            throw new ProjectToolException(e);
        }
        if (this.cli.hasOption("K")) {
            this.argKeepgoing = true;
        }
        if (this.cli.hasOption("v")) {
            this.argVerbose = true;
        }
        if (this.cli.hasOption("V")) {
            this.argDebug = true;
        }
        if (this.cli.hasOption("q")) {
            this.argQuiet = true;
        }
        if (this.cli.hasOption('z') || System.getProperties().containsKey("rdeck.cli.terse") && "true".equalsIgnoreCase(System.getProperty("rdeck.cli.terse"))) {
            this.argTerse = true;
        }
        if (this.cli.hasOption(NO_QUEUE_FLAG)) {
            this.argNoQueue = true;
        }
        if (this.cli.hasOption("S") && this.cli.hasOption("s")) {
            throw new CoreException("-s and -S options are mutually exclusive");
        }
        if (this.cli.hasOption("s")) {
            this.scriptpath = new File(this.cli.getOptionValue("s")).getAbsolutePath();
        }
        if (this.cli.hasOption("u")) {
            this.scriptURLString = this.cli.getOptionValue("u");
        }
        if (this.cli.hasOption("S")) {
            this.inlineScript = true;
        }
        if (this.cli.hasOption("f")) {
            this.argFollow = true;
            if (this.cli.hasOption("r")) {
                this.argProgress = true;
            }
        }
        if (this.cli.hasOption("F")) {
            this.failedNodes = new File(this.cli.getOptionValue("F"));
        }
        if (this.cli.hasOption('p')) {
            this.argProject = this.cli.getOptionValue("p");
        } else if (!this.cli.hasOption("p") && this.framework.getFrameworkProjectMgr().listFrameworkProjects().size() == 1) {
            FrameworkProject project = (FrameworkProject)this.framework.getFrameworkProjectMgr().listFrameworkProjects().iterator().next();
            this.argProject = project.getName();
        }
        if (this.cli.hasOption("C")) {
            try {
                this.argThreadCount = Integer.valueOf(this.cli.getOptionValue("C"));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("threadcount must be an integer");
            }
        }
        if (this.cli.hasOption('N')) {
            if (!this.argNoQueue) {
                throw new IllegalArgumentException("-N option requires -L/--noqueue");
            }
            if (!new File(this.cli.getOptionValue('N')).exists()) {
                throw new IllegalArgumentException("specified nodes file does not exist");
            }
            this.argNodesFile = this.cli.getOptionValue('N');
            this.nodesFile = new File(this.argNodesFile);
        }
        if (this.cli.hasOption("h")) {
            this.help();
            this.exit(1);
        }
        boolean parsedFailedNodes = false;
        if (null != this.failedNodes && this.failedNodes.exists()) {
            this.includeMap = FailedNodesFilestore.parseFailedNodes(this.failedNodes);
            if (this.includeMap.size() > 0) {
                parsedFailedNodes = true;
            }
        }
        if (!parsedFailedNodes) {
            String[] keys = NodeSet.FILTER_KEYS_LIST.toArray(new String[NodeSet.FILTER_KEYS_LIST.size()]);
            this.excludeMap = this.parseExcludeArgs(keys);
            this.includeMap = this.parseIncludeArgs(keys);
        }
        this.argExcludePrecedence = ExecTool.determineExclusionPrecedenceForArgs(args, this.cli);
        if (null == this.argProject) {
            throw new IllegalArgumentException("project parameter not specified");
        }
        return this.cli;
    }

    public String generateExecLine(Map<String, String> filterArgs) {
        ArrayList<String> list = new ArrayList<String>();
        if (this.argKeepgoing) {
            list.add("-K");
        }
        if (this.argVerbose) {
            list.add("-v");
        }
        if (this.argDebug) {
            list.add("-V");
        }
        if (this.argQuiet) {
            list.add("-q");
        }
        if (null != this.scriptpath) {
            list.add("-s");
            list.add(this.scriptpath);
        }
        if (null != this.scriptURLString) {
            list.add("-u");
            list.add(this.scriptURLString);
        }
        if (this.inlineScript) {
            list.add("-S");
        }
        if (null != this.failedNodes) {
            list.add("-F");
            list.add(this.failedNodes.getAbsolutePath());
        }
        if (null != this.argProject) {
            list.add("-p");
            list.add(this.argProject);
        }
        if (1 != this.argThreadCount) {
            list.add("-C");
            list.add(this.argThreadCount.toString());
        }
        if (null != this.argNodesFile) {
            list.add("-N");
            list.add(this.argNodesFile);
        }
        if (null != filterArgs) {
            for (Map.Entry<String, String> entry : filterArgs.entrySet()) {
                list.add(entry.getKey());
                list.add(entry.getValue());
            }
        }
        if (null != this.argsDeferred && this.argsDeferred.length > 0) {
            list.add("--");
            list.addAll(Arrays.asList(this.argsDeferred));
        }
        list.add(0, "dispatch");
        return StringArrayUtil.asString(list.toArray(new String[list.size()]), " ");
    }

    protected Map parseExcludeArgs(String[] keys) {
        return ExecTool.parseFilterArgs(keys, this.cli, "X");
    }

    protected Map parseIncludeArgs(String[] keys) {
        return ExecTool.parseFilterArgs(keys, this.cli, "I");
    }

    @Override
    public void run(String[] args) {
        int exitCode;
        block9: {
            exitCode = 1;
            ThreadBoundOutputStream.bindSystemOut();
            ThreadBoundOutputStream.bindSystemErr();
            this.out = System.out;
            this.err = System.err;
            try {
                this.parseArgs(args);
                this.configurePrintStream(this.argQuiet);
                if (!this.hasNecessaryRunArgs()) {
                    this.listAction();
                } else if (this.argNoQueue) {
                    this.runAction();
                } else {
                    this.queueAction();
                }
                exitCode = 0;
            }
            catch (Throwable t) {
                if (null == t.getMessage() || this.argVerbose || "true".equals(System.getProperty("rdeck.traceExceptions"))) {
                    t.printStackTrace();
                }
                this.error(t);
                if (t instanceof NodesetFailureException) {
                    NodesetFailureException nfe = (NodesetFailureException)t;
                    HashMap<String, String> failmap = new HashMap<String, String>();
                    if (null != nfe.getNodeset() && nfe.getNodeset().size() > 0 && null == this.failedNodes) {
                        failmap.put("-I", "name=" + StringArrayUtil.asString(nfe.getNodeset().toArray(new String[nfe.getNodeset().size()]), ","));
                    }
                    this.error("Execute this command to retry on the failed nodes:\n\t" + this.generateExecLine(failmap));
                    exitCode = 9;
                }
                if (!(t instanceof NodesetEmptyException)) break block9;
                exitCode = 3;
            }
        }
        this.exit(exitCode);
    }

    private boolean hasNecessaryRunArgs() {
        return this.hasArgsDeferred() || null != this.getScript() || null != this.getServerScriptFilePath() || this.isInlineScript() || null != this.getScriptURLString();
    }

    private boolean hasArgsDeferred() {
        return null != this.argsDeferred && 0 != this.argsDeferred.length;
    }

    void listAction() {
        try {
            this.log((this.argVerbose ? this.getNodeFormatter() : new DefaultNodeFormatter()).formatNodes(this.filterNodes(false).getNodes()).toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    NodeFormatter getNodeFormatter() {
        return this.nodeFormatter;
    }

    private void queueAction() {
        QueuedItemResult result;
        try {
            if (this.inlineScript && null == this.inlineScriptContent) {
                this.setScriptAsStream(this.instream);
            }
            result = this.framework.getCentralDispatcherMgr().queueDispatcherScript(this);
        }
        catch (CentralDispatcherException e) {
            throw new CoreException("Unable to queue the execution: " + e.getMessage(), e);
        }
        if (null == result || !result.isSuccessful()) {
            throw new CoreException("Queued job request failed: " + (null != result ? result.getMessage() : "Result was null"));
        }
        if (null != result.getMessage()) {
            this.out.println(result.getMessage());
        }
        this.out.println("Queued Execution ID: " + result.getItem().getId() + " <" + result.getItem().getUrl() + ">");
        if (this.argFollow) {
            this.followOutput(result.getItem(), this.argQuiet, this.argProgress);
        }
    }

    private void followOutput(QueuedItem item, boolean quiet, boolean progress) throws CoreException {
        boolean successful = false;
        try {
            ConsoleExecutionFollowReceiver.Mode mode = ConsoleExecutionFollowReceiver.Mode.output;
            if (quiet) {
                mode = ConsoleExecutionFollowReceiver.Mode.quiet;
            } else if (progress) {
                mode = ConsoleExecutionFollowReceiver.Mode.progress;
            }
            successful = QueueTool.followAction(item.getId(), true, mode, this.framework, System.out, this);
        }
        catch (CentralDispatcherException e) {
            throw new CoreException("Failed following output for execution: " + item.getId(), e);
        }
        if (!successful) {
            this.exit(3);
        }
    }

    @Override
    public synchronized ExecutionListener getExecutionListener() {
        if (null == this.mylistener) {
            this.mylistener = this.createExecutionListener();
        }
        return this.mylistener;
    }

    public ExecutionListener createExecutionListener() {
        String logformat = this.getFramework().hasProperty(FRAMEWORK_LOG_RUNDECK_EXEC_CONSOLE_FORMAT) ? this.getFramework().getProperty(FRAMEWORK_LOG_RUNDECK_EXEC_CONSOLE_FORMAT) : DEFAULT_LOG_FORMAT;
        return new CLIExecutionListener(FailedNodesFilestore.createListener(this.getFailedNodes()), this, this.getAntLoglevel(), this.argTerse, logformat);
    }

    void runAction() throws Exception {
        ExecutionResult result = null;
        ExecutionException exception = null;
        Date startDate = new Date();
        try {
            if (this.inlineScript) {
                File inlinefile = null;
                inlinefile = null != this.inlineScriptContent ? this.writeInlineContentToFile() : this.writeStdinInputToFile();
                this.setScriptpath(inlinefile.getAbsolutePath());
                this.setScriptAsStream(new FileInputStream(inlinefile));
            } else if (null != this.scriptpath) {
                this.setScriptAsStream(new FileInputStream(this.getScriptpath()));
            }
            ExecutionService service = this.framework.getExecutionService();
            result = service.executeItem(this, this.createExecutionItem());
            if (null != this.scriptAsStream) {
                try {
                    this.scriptAsStream.close();
                }
                catch (IOException e) {
                    this.error("Error closing stream: " + e.getMessage());
                }
            }
            if (!result.isSuccess()) {
                if (null != result.getResultObject()) {
                    this.error(result.getResultObject().toString());
                }
                if (null != result.getException()) {
                    this.error(result.getException().getMessage());
                }
            }
        }
        catch (ExecutionException e) {
            this.error("Unable to perform the execution: " + e.getMessage());
            exception = e;
        }
        NodeSet filterNodeSelector = this.createFilterNodeSelector();
        String tags = null != filterNodeSelector && null != filterNodeSelector.getInclude() && filterNodeSelector.getInclude().getTags() != null ? filterNodeSelector.getInclude().getTags() : null;
        String script = OptsUtil.join("dispatch", this.inputArgs);
        Collection<INodeEntry> nodeEntryCollection = this.filterNodes(true).getNodes();
        if (null != result && result.isSuccess()) {
            String resultString = null != result.getResultObject() ? result.getResultObject().toString() : "dispatch succeeded";
            try {
                this.framework.getCentralDispatcherMgr().reportExecutionStatus(this.getFrameworkProject(), "dispatch", "succeeded", 0, nodeEntryCollection.size(), tags, script, resultString, startDate, new Date());
            }
            catch (CentralDispatcherException e) {
                e.printStackTrace();
            }
            return;
        }
        String failureString = null != result ? (null != result.getResultObject() ? result.getResultObject().toString() : (null != result && result.getException() != null ? result.getException().getMessage() : "")) : "action failed: result was null";
        int failednodes = nodeEntryCollection.size();
        if (null != result && null != result.getException() && result.getException() instanceof NodesetFailureException) {
            NodesetFailureException failure = (NodesetFailureException)result.getException();
            if (null != failure.getNodeset()) {
                failednodes = failure.getNodeset().size();
            }
        } else if (null != result && null != result.getResultObject() && null != result.getResultObject().getResults()) {
            for (String node : result.getResultObject().getResults().keySet()) {
                StatusResult interpreterResult = result.getResultObject().getResults().get(node);
                if (!interpreterResult.isSuccess()) continue;
                --failednodes;
            }
        }
        try {
            this.framework.getCentralDispatcherMgr().reportExecutionStatus(this.getFrameworkProject(), "dispatch", "failed", failednodes, nodeEntryCollection.size() - failednodes, tags, script, failureString, startDate, new Date());
        }
        catch (CentralDispatcherException e) {
            e.printStackTrace();
        }
        if (null != result && null != result.getException()) {
            throw result.getException();
        }
        if (null != exception) {
            throw exception;
        }
        throw new CoreException(failureString);
    }

    StepExecutionItem createExecutionItem() {
        if (null != this.getScript() || null != this.getServerScriptFilePath() || null != this.getScriptAsStream()) {
            return new ScriptFileCommandBase(){

                @Override
                public String getScript() {
                    return ExecTool.this.getScript();
                }

                @Override
                public InputStream getScriptAsStream() {
                    return ExecTool.this.getScriptAsStream();
                }

                @Override
                public String getServerScriptFilePath() {
                    return ExecTool.this.getServerScriptFilePath();
                }

                @Override
                public String[] getArgs() {
                    return ExecTool.this.getArgs();
                }
            };
        }
        if (null != this.scriptURLString) {
            return new ScriptURLCommandBase(){

                @Override
                public String getURLString() {
                    return ExecTool.this.getScriptURLString();
                }

                @Override
                public String[] getArgs() {
                    return ExecTool.this.getArgs();
                }

                @Override
                public StepExecutionItem getFailureHandler() {
                    return null;
                }

                @Override
                public boolean isKeepgoingOnSuccess() {
                    return false;
                }
            };
        }
        return new ExecCommandBase(){

            @Override
            public String[] getCommand() {
                return ExecTool.this.getArgs();
            }
        };
    }

    @Override
    public String getUser() {
        return this.getFramework().getAuthenticationMgr().getUserInfo().getUsername();
    }

    protected NodeSet createFilterNodeSelector() {
        return ExecTool.createNodeSet(this.includeMap, this.excludeMap, this.argExcludePrecedence, this.argThreadCount, this.argKeepgoing, this.failedNodes);
    }

    protected NodeSet createNodeSet(Map includeMap, Map excludeMap) {
        return ExecTool.createNodeSet(includeMap, excludeMap, true, this.argThreadCount, this.argKeepgoing, this.failedNodes);
    }

    protected static NodeSet createNodeSet(Map includeMap, Map excludeMap, boolean excludePrecedence, Integer threadCount, boolean keepgoing, File failedNodesfile) {
        NodeSet nodeset = new NodeSet();
        nodeset.createExclude(excludeMap).setDominant(excludePrecedence);
        nodeset.createInclude(includeMap).setDominant(!excludePrecedence);
        nodeset.setThreadCount(threadCount);
        nodeset.setKeepgoing(keepgoing);
        nodeset.setFailedNodesfile(failedNodesfile);
        return nodeset;
    }

    public static void main(String[] args) throws Exception {
        File configDir = Constants.getFrameworkConfigFile();
        PropertyConfigurator.configure((String)new File(configDir, "log4j.properties").getAbsolutePath());
        File systemBaseDir = new File(Constants.getSystemBaseDir());
        ExecTool ExecTool2 = new ExecTool(systemBaseDir.getAbsolutePath());
        ExecTool2.shouldExit = true;
        ExecTool2.run(args);
    }

    @Override
    public void exit(int exitcode) {
        if (this.shouldExit) {
            System.exit(exitcode);
        } else if (0 != exitcode) {
            this.warn("ExecTool.exit() called while in embedded usage, not exitting.");
        }
    }

    @Override
    public void help() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(80, "dispatch [-h] [-v] [-V] [-q] [-p project] [-I nodes] [-X xnodes] [--threadcount <1>] [--keepgoing] [--queue] [[-S] | [-s <>] | [-- command-args]]", null, options, "Examples:\n| dispatch\n | => Prints all nodes\n| dispatch -p default -- whoami\n | => Runs the whoami command on all nodes\n| dispatch -X node1 -- uptime\n | => Runs the uptime command on all nodes except node1\n| dispatch -s myscript.sh\n | => Copies and then runs myscript.sh to matcing nodes\n\n[RUNDECK version " + VersionConstants.VERSION + " (" + VersionConstants.BUILD + ")]");
    }

    @Override
    public void log(String message) {
        System.out.println(message);
    }

    @Override
    public void warn(String message) {
        System.err.println("warn: " + message);
    }

    @Override
    public void error(String message) {
        System.err.println("error: " + message);
    }

    private void error(Throwable t) {
        this.error(t.getMessage());
    }

    @Override
    public void debug(String message) {
        if (this.argDebug) {
            this.log("debug: " + message);
        }
    }

    @Override
    public void verbose(String message) {
        if (this.argVerbose) {
            this.log("verbose: " + message);
        }
    }

    protected BuildListener createExecToolCommandLogger(int level, Reformatter gen) {
        ExecToolCommandLogger logger = new ExecToolCommandLogger(gen);
        logger.setMessageOutputLevel(level);
        logger.setOutputPrintStream(this.out);
        logger.setErrorPrintStream(this.err);
        logger.setEmacsMode(true);
        return logger;
    }

    protected void configurePrintStream(boolean quiet) {
        if (quiet) {
            String logpath = this.framework.getProperty("framework.logs.dir");
            if (null == logpath || "".equals(logpath)) {
                throw new CoreException("Cannot configure print stream to a file. framework.logs.dir property not set");
            }
            File logsdir = new File(logpath);
            if (!logsdir.isDirectory() || !logsdir.exists()) {
                throw new CoreException("Cannot configure print stream to a file. Path does not exist or is not a directory: " + logpath);
            }
            try {
                File logfile = File.createTempFile("dispatch-", ".log", logsdir);
                ThreadBoundOutputStream.bindSystemOut().installThreadStream(new FileOutputStream(logfile));
            }
            catch (IOException e) {
                throw new CoreException("Cannot configure print stream to a file. Failed created log file: " + e.getMessage());
            }
        }
    }

    public boolean isArgKeepgoing() {
        return this.argKeepgoing;
    }

    public void setArgKeepgoing(boolean argKeepgoing) {
        this.argKeepgoing = argKeepgoing;
    }

    public boolean isArgQuiet() {
        return this.argQuiet;
    }

    public void setArgQuiet(boolean argQuiet) {
        this.argQuiet = argQuiet;
    }

    public boolean isArgDebug() {
        return this.argDebug;
    }

    public void setArgDebug(boolean argDebug) {
        this.argDebug = argDebug;
    }

    public boolean isArgVerbose() {
        return this.argVerbose;
    }

    public void setArgVerbose(boolean argVerbose) {
        this.argVerbose = argVerbose;
    }

    public String getArgIncludeNodes() {
        return this.argIncludeNodes;
    }

    public void setArgIncludeNodes(String argIncludeNodes) {
        this.argIncludeNodes = argIncludeNodes;
    }

    public String getArgExcludeNodes() {
        return this.argExcludeNodes;
    }

    public void setArgExcludeNodes(String argExcludeNodes) {
        this.argExcludeNodes = argExcludeNodes;
    }

    public Integer getArgThreadCount() {
        return this.argThreadCount;
    }

    public void setArgThreadCount(Integer argThreadCount) {
        this.argThreadCount = argThreadCount;
    }

    public String getArgDepot() {
        return this.getArgFrameworkProject();
    }

    public void setArgDepot(String argProject) {
        this.setArgFrameworkProject(argProject);
    }

    public String getArgFrameworkProject() {
        return this.argProject;
    }

    public void setArgFrameworkProject(String argProject) {
        this.argProject = argProject;
    }

    public Map getExcludeMap() {
        return this.excludeMap;
    }

    public void setExcludeMap(Map excludeMap) {
        this.excludeMap = excludeMap;
    }

    public Map getIncludeMap() {
        return this.includeMap;
    }

    public void setIncludeMap(Map includeMap) {
        this.includeMap = includeMap;
    }

    public String[] getArgsDeferred() {
        return null != this.argsDeferred ? (String[])this.argsDeferred.clone() : null;
    }

    public void setArgsDeferred(String[] argsDeferred) {
        this.argsDeferred = null != argsDeferred ? (String[])argsDeferred.clone() : null;
    }

    public boolean isArgExcludePrecedence() {
        return this.argExcludePrecedence;
    }

    public void setArgExcludePrecedence(boolean argExcludePrecedence) {
        this.argExcludePrecedence = argExcludePrecedence;
    }

    public String getScriptpath() {
        return this.scriptpath;
    }

    public void setScriptpath(String scriptpath) {
        this.scriptpath = scriptpath;
    }

    public boolean isInlineScript() {
        return this.inlineScript;
    }

    public void setInlineScript(boolean inlineScript) {
        this.inlineScript = inlineScript;
    }

    public String getInlineScriptContent() {
        return this.inlineScriptContent;
    }

    public void setInlineScriptContent(String inlineScriptContent) {
        this.inlineScriptContent = inlineScriptContent;
    }

    public File getFailedNodes() {
        return this.failedNodes;
    }

    public void setFailedNodes(File failedNodes) {
        this.failedNodes = failedNodes;
    }

    public boolean isArgNoQueue() {
        return this.argNoQueue;
    }

    public void setArgNoQueue(boolean argNoQueue) {
        this.argNoQueue = argNoQueue;
    }

    @Override
    public Framework getFramework() {
        return this.framework;
    }

    @Override
    public NodesSelector getNodeSelector() {
        return this.createFilterNodeSelector().nodeSelectorWithDefault(this.framework.getFrameworkNodeName());
    }

    @Override
    public INodeSet getNodes() {
        return this.filterNodes(true);
    }

    @Override
    public int getThreadCount() {
        return this.argThreadCount;
    }

    @Override
    public String getNodeRankAttribute() {
        return null;
    }

    @Override
    public boolean isNodeRankOrderAscending() {
        return true;
    }

    @Override
    public boolean isKeepgoing() {
        return this.argKeepgoing;
    }

    @Override
    public String getFrameworkProject() {
        return this.getArgFrameworkProject();
    }

    @Override
    public String getScript() {
        return this.getInlineScriptContent();
    }

    @Override
    public InputStream getScriptAsStream() {
        return this.scriptAsStream;
    }

    public void setScriptAsStream(InputStream scriptAsStream) {
        this.scriptAsStream = scriptAsStream;
    }

    @Override
    public String getServerScriptFilePath() {
        return this.getScriptpath();
    }

    @Override
    public NodeSet getNodeSet() {
        return this.createFilterNodeSelector();
    }

    @Override
    public String[] getArgs() {
        return this.getArgsDeferred();
    }

    @Override
    public int getLoglevel() {
        if (this.argDebug) {
            return 4;
        }
        if (this.argQuiet && this.argVerbose) {
            return 1;
        }
        if (this.argVerbose) {
            return 3;
        }
        if (this.argQuiet) {
            return 0;
        }
        return 2;
    }

    @Override
    public Map<String, Map<String, String>> getDataContext() {
        return null;
    }

    @Override
    public Map<String, Map<String, String>> getPrivateDataContext() {
        return null;
    }

    @Override
    public File getNodesFile() {
        return this.nodesFile;
    }

    static boolean determineExclusionPrecedenceForArgs(String[] args, CommandLine cli) {
        if (cli.hasOption(FILTER_EXCLUDE_PRECEDENCE_OPT)) {
            return "true".equals(cli.getOptionValue(FILTER_EXCLUDE_PRECEDENCE_OPT));
        }
        for (int i = 0; i < args.length; ++i) {
            String option = args[i];
            if ("-X".equals(option) || "--xnodes".equals(option)) {
                return true;
            }
            if (!"-I".equals(option) && !"--nodes".equals(option)) continue;
            return false;
        }
        return true;
    }

    protected static Map<String, String> parseMultiNodeArgs(String[] keys, String[] values) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (null != values && values.length > 0) {
            for (String exclude : values) {
                int i1 = exclude.indexOf("=");
                if (i1 > 0 && i1 <= exclude.length() - 1) {
                    String k = exclude.substring(0, i1);
                    String v = exclude.substring(i1 + 1);
                    map.put(k, v);
                    continue;
                }
                if (i1 >= 0) continue;
                map.put(keys[0], exclude);
            }
        }
        return map;
    }

    protected static Map<String, String> parseFilterArgs(String[] keys, CommandLine cli, String opt) {
        String[] strings = cli.getOptionValues(opt);
        if ((null == strings || strings.length == 0) && null != cli.getOptionValue(opt)) {
            strings = new String[]{cli.getOptionValue(opt)};
        }
        return ExecTool.parseMultiNodeArgs(keys, strings);
    }

    private INodeSet readNodesFile() {
        FrameworkProject project = this.framework.getFrameworkProjectMgr().getFrameworkProject(this.argProject);
        try {
            if (null != this.argNodesFile) {
                return this.loadLocalFile(this.argNodesFile);
            }
            return project.getNodeSet();
        }
        catch (NodeFileParserException e) {
            throw new CoreException("Error parsing nodes resource file: " + e.getMessage(), e);
        }
    }

    private INodeSet loadLocalFile(String argNodesFile) {
        try {
            return FileResourceModelSource.parseFile(argNodesFile, this.framework, this.argProject);
        }
        catch (ConfigurationException e) {
            throw new CoreException("Error parsing nodes resource file: " + e.getMessage(), e);
        }
        catch (ResourceModelSourceException e) {
            throw new CoreException("Error parsing nodes resource file: " + e.getMessage(), e);
        }
    }

    INodeSet filterNodes() {
        return this.filterNodes(false);
    }

    INodeSet filterNodes(boolean singleNodeDefault) {
        INodeSet n = this.readNodesFile();
        this.debug("total unfiltered nodes=" + n.getNodeNames().size());
        NodeSet filterNodeSelector = this.createFilterNodeSelector();
        if (0 != n.getNodeNames().size()) {
            this.debug("applying nodeset filter... " + this.getNodeSelector().toString());
            return NodeFilter.filterNodes(singleNodeDefault ? filterNodeSelector.nodeSelectorWithDefault(this.framework.getFrameworkNodeName()) : filterNodeSelector.nodeSelectorWithDefaultAll(), n);
        }
        this.verbose("Empty node list");
        return n;
    }

    void setNodeFormatter(NodeFormatter nodeFormatter) {
        this.nodeFormatter = nodeFormatter;
    }

    @Override
    public String getScriptURLString() {
        return this.scriptURLString;
    }

    public void setScriptURLString(String scriptURLString) {
        this.scriptURLString = scriptURLString;
    }

    @Override
    public int getStepNumber() {
        return 1;
    }

    @Override
    public List<Integer> getStepContext() {
        return null;
    }

    protected File writeStdinInputToFile() {
        return this.writeInputToFile(this.instream);
    }

    protected File writeInputToFile(InputStream input) {
        File tempfile;
        this.verbose("reading stdin and saving it to file...");
        try {
            tempfile = ScriptfileUtils.writeScriptTempfile(this.framework, input);
        }
        catch (IOException e) {
            throw new CoreException("error while reading script input from stdin: " + e.getMessage());
        }
        this.verbose("Wrote stdin input to file: " + tempfile);
        try {
            ScriptfileUtils.setExecutePermissions(tempfile);
        }
        catch (IOException e) {
            this.warn("Failed to set execute permissions on tempfile, execution may fail: " + tempfile.getAbsolutePath());
        }
        return tempfile;
    }

    protected File writeInlineContentToFile() {
        File tempfile;
        this.verbose("writing inline content to temporary file...");
        try {
            tempfile = ScriptfileUtils.writeScriptTempfile(this.framework, this.getInlineScriptContent());
        }
        catch (IOException e) {
            throw new CoreException("error while reading script input from stdin: " + e.getMessage());
        }
        this.verbose("Wrote inline script content to file: " + tempfile);
        try {
            ScriptfileUtils.setExecutePermissions(tempfile);
        }
        catch (IOException e) {
            this.warn("Failed to set execute permissions on tempfile, execution may fail: " + tempfile.getAbsolutePath());
        }
        return tempfile;
    }

    public int getAntLoglevel() {
        if (this.argDebug) {
            return 4;
        }
        if (this.argQuiet && this.argVerbose) {
            return 1;
        }
        if (this.argVerbose) {
            return 3;
        }
        if (this.argQuiet) {
            return 0;
        }
        return 2;
    }

    @Override
    public boolean isDebug() {
        return this.argDebug;
    }

    @Override
    public boolean isVerbose() {
        return this.argVerbose;
    }

    @Override
    public boolean isQuiet() {
        return this.argQuiet;
    }

    static {
        options.addOption("h", "help", false, "print usage");
        options.addOption("v", "verbose", false, "verbose mode");
        options.addOption("V", "debug", false, "Debug output mode");
        options.addOption("q", "quiet", false, "quiet mode");
        options.addOption("K", "keepgoing", false, "keep going if there are errors");
        options.addOption("C", "threadcount", true, "number of threads");
        options.addOption("I", "nodes", true, "include node list");
        options.addOption("X", "xnodes", true, "exclude node list");
        options.addOption("F", "failednodes", true, "Filepath to store failed nodes");
        options.addOption("p", "project", true, "project name");
        options.addOption(FILTER_EXCLUDE_PRECEDENCE_OPT, FILTER_EXCLUDE_PRECEDENCE_LONG, true, "true/false. if true, exclusion filters have precedence over inclusion filters");
        options.addOption("s", "scriptfile", true, "scriptfile script file");
        options.addOption("u", "url", true, "script URL");
        options.addOption("S", "stdin", false, "read script from stdin");
        options.addOption("N", "nodesfile", true, "Path to arbitrary nodes file (with -L/--noqueue only)");
        options.addOption(NO_QUEUE_FLAG, "noqueue", false, "Run locally, do not send the execution to the command dispatcher queue");
        options.addOption("Q", "queue", false, "Send the execution to the command dispatcher queue (default behavior)");
        options.addOption("z", "terse", false, "leave log messages unadorned");
        options.addOption("f", "follow", false, "Follow queued execution output");
        options.addOption("r", "progress", false, "In follow mode, print progress indicator chars");
    }

    public static class LogLevelConvertBuildListener
    implements BuildListener {
        private BuildListener listener;
        private Map<Integer, Integer> levels = new HashMap<Integer, Integer>();

        public LogLevelConvertBuildListener(BuildListener listener, Map<Integer, Integer> levels) {
            this.listener = listener;
            this.levels = levels;
        }

        public void messageLogged(BuildEvent event) {
            int prio = event.getPriority();
            if (this.levels.containsKey(prio)) {
                int newprio = this.levels.get(prio);
                event.setMessage(event.getMessage(), newprio);
            }
            this.listener.messageLogged(event);
        }

        public void buildStarted(BuildEvent event) {
            this.listener.buildStarted(event);
        }

        public void buildFinished(BuildEvent event) {
            this.listener.buildFinished(event);
        }

        public void targetStarted(BuildEvent event) {
            this.listener.targetStarted(event);
        }

        public void targetFinished(BuildEvent event) {
            this.listener.targetFinished(event);
        }

        public void taskStarted(BuildEvent event) {
            this.listener.taskStarted(event);
        }

        public void taskFinished(BuildEvent event) {
            this.listener.taskFinished(event);
        }
    }

    static class NodeYAMLFormatter
    implements NodeFormatter {
        NodeYAMLFormatter() {
        }

        @Override
        public StringBuffer formatNodes(Collection nodes) throws Exception {
            return this.generate(nodes);
        }

        StringBuffer generate(Collection c) throws NodesGeneratorException, IOException {
            StringWriter writer = new StringWriter();
            NodesYamlGenerator gen = new NodesYamlGenerator(writer);
            for (Object aC : c) {
                gen.addNode((INodeEntry)aC);
            }
            gen.generate();
            return writer.getBuffer();
        }
    }

    public static interface NodeFormatter {
        public StringBuffer formatNodes(Collection var1) throws Exception;
    }

    static class DefaultNodeFormatter
    implements NodeFormatter {
        DefaultNodeFormatter() {
        }

        @Override
        public StringBuffer formatNodes(Collection nodes) throws Exception {
            return this.formatResults(nodes);
        }

        StringBuffer formatResults(Collection c) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            for (Object aC : c) {
                INodeEntry node = (INodeEntry)aC;
                sb.append(node.getNodename());
                if (i < c.size() - 1) {
                    sb.append(" ");
                }
                ++i;
            }
            return sb;
        }
    }
}

