/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.common;

import com.dtolabs.rundeck.core.common.NodeEntryImpl;
import com.dtolabs.rundeck.core.common.NodeFileParser;
import com.dtolabs.rundeck.core.common.NodeFileParserException;
import com.dtolabs.rundeck.core.common.NodeReceiver;
import com.dtolabs.shared.resources.ResourceXMLConstants;
import com.dtolabs.shared.resources.ResourceXMLParser;
import com.dtolabs.shared.resources.ResourceXMLParserException;
import com.dtolabs.shared.resources.ResourceXMLReceiver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;

public class NodesXMLParser
implements NodeFileParser,
ResourceXMLReceiver {
    final File file;
    final InputStream input;
    final NodeReceiver nodeReceiver;

    public NodesXMLParser(File file, NodeReceiver nodeReceiver) {
        this.file = file;
        this.input = null;
        this.nodeReceiver = nodeReceiver;
    }

    public NodesXMLParser(InputStream input, NodeReceiver nodeReceiver) {
        this.input = input;
        this.file = null;
        this.nodeReceiver = nodeReceiver;
    }

    @Override
    public void parse() throws NodeFileParserException {
        ResourceXMLParser resourceXMLParser = null != this.file ? new ResourceXMLParser(this.file) : new ResourceXMLParser(this.input);
        resourceXMLParser.setReceiver(this);
        try {
            resourceXMLParser.parse();
        }
        catch (ResourceXMLParserException e) {
            throw new NodeFileParserException(e);
        }
        catch (IOException e) {
            throw new NodeFileParserException(e);
        }
    }

    @Override
    public boolean resourceParsed(ResourceXMLParser.Entity entity) {
        return true;
    }

    private void fillNode(ResourceXMLParser.Entity entity, NodeEntryImpl node) {
        HashSet<String> tags1;
        node.setUsername(entity.getProperty("username"));
        node.setHostname(entity.getProperty("hostname"));
        node.setOsArch(entity.getProperty("osArch"));
        node.setOsFamily(entity.getProperty("osFamily"));
        node.setOsName(entity.getProperty("osName"));
        node.setOsVersion(entity.getProperty("osVersion"));
        node.setDescription(entity.getProperty("description"));
        String tags = entity.getProperty("tags");
        if (null != tags && !"".equals(tags)) {
            tags1 = new HashSet();
            for (String s : tags.split(",")) {
                tags1.add(s.trim());
            }
        } else {
            tags1 = new HashSet<String>();
        }
        node.setTags(tags1);
        if (null == node.getAttributes()) {
            node.setAttributes(new HashMap<String, String>());
        }
        if (null != entity.getProperties()) {
            for (String key : entity.getProperties().stringPropertyNames()) {
                if (ResourceXMLConstants.allPropSet.contains(key)) continue;
                node.getAttributes().put(key, entity.getProperty(key));
            }
        }
    }

    @Override
    public void resourcesParsed(ResourceXMLParser.EntitySet entities) {
        for (ResourceXMLParser.Entity entity : entities.getEntities()) {
            if (!"node".equals(entity.getResourceType())) continue;
            NodeEntryImpl node = new NodeEntryImpl(entity.getProperty("hostname"), entity.getName());
            this.fillNode(entity, node);
            if (null == this.nodeReceiver) continue;
            this.nodeReceiver.putNode(node);
        }
    }
}

