/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.common;

import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.common.NodeEntryFactory;
import com.dtolabs.rundeck.core.common.NodesFileGenerator;
import com.dtolabs.rundeck.core.common.NodesGeneratorException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class NodesYamlGenerator
implements NodesFileGenerator {
    private File destfile;
    private OutputStream outputStream;
    private Writer writer;
    private HashMap<String, Map> maps = new HashMap();

    public NodesYamlGenerator(File destfile) {
        this();
        this.destfile = destfile;
    }

    public NodesYamlGenerator(OutputStream outputStream) {
        this();
        this.outputStream = outputStream;
    }

    public NodesYamlGenerator(Writer writer) {
        this();
        this.writer = writer;
    }

    private NodesYamlGenerator() {
    }

    @Override
    public void addNode(INodeEntry node) {
        this.maps.put(node.getNodename(), NodeEntryFactory.toMap(node));
    }

    @Override
    public void addNodes(Collection<INodeEntry> nodes) {
        for (INodeEntry iNodeEntry : nodes) {
            this.addNode(iNodeEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate() throws IOException, NodesGeneratorException {
        if (null == this.destfile && null == this.outputStream && null == this.writer) {
            throw new NullPointerException("destfile or outputstream was not set");
        }
        if (null == this.maps || this.maps.size() < 1) {
            throw new NodesGeneratorException("Node set is empty");
        }
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Yaml yaml = new Yaml(dumperOptions);
        if (null != this.writer) {
            yaml.dump(this.maps, this.writer);
        } else {
            if (null != this.destfile) {
                FileWriter writeout = new FileWriter(this.destfile);
                try {
                    yaml.dump(this.maps, (Writer)writeout);
                }
                finally {
                    ((Writer)writeout).close();
                }
            }
            OutputStreamWriter writeout = new OutputStreamWriter(this.outputStream);
            try {
                yaml.dump(this.maps, (Writer)writeout);
            }
            finally {
                ((Writer)writeout).close();
            }
        }
    }
}

