/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.dispatcher;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.execution.script.ScriptfileUtils;
import com.dtolabs.rundeck.core.utils.Converter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.filters.ReplaceTokens;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.types.Environment;

public class DataContextUtils {
    public static final String ENV_VAR_PREFIX = "RD_";

    public static String[] replaceDataReferences(String[] args, Map<String, Map<String, String>> data, Converter<String, String> converter, boolean failIfUnexpanded) {
        if (null == data || data.isEmpty()) {
            return args;
        }
        if (null == args || args.length < 1) {
            return args;
        }
        String[] newargs = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            newargs[i] = DataContextUtils.replaceDataReferences(arg, data, converter, failIfUnexpanded);
        }
        return newargs;
    }

    public static String[] replaceDataReferences(String[] args, Map<String, Map<String, String>> data) {
        return DataContextUtils.replaceDataReferences(args, data, null, false);
    }

    public static Map<String, Object> replaceDataReferences(Map<String, Object> input, Map<String, Map<String, String>> data) {
        HashMap<String, Object> output = new HashMap<String, Object>();
        for (String s : input.keySet()) {
            Object o = input.get(s);
            output.put(s, DataContextUtils.replaceDataReferencesInObject(o, data));
        }
        return output;
    }

    private static Object replaceDataReferencesInObject(Object o, Map<String, Map<String, String>> data) {
        if (o instanceof String) {
            return DataContextUtils.replaceDataReferences((String)o, data);
        }
        if (o instanceof Map) {
            Map sub = (Map)o;
            return DataContextUtils.replaceDataReferences(sub, data);
        }
        if (o instanceof Collection) {
            ArrayList<Object> result = new ArrayList<Object>();
            Collection r = (Collection)o;
            for (Object o1 : r) {
                result.add(DataContextUtils.replaceDataReferencesInObject(o1, data));
            }
            return result;
        }
        return o;
    }

    public static String replaceDataReferences(String input, Map<String, Map<String, String>> data) {
        return DataContextUtils.replaceDataReferences(input, data, null, false);
    }

    public static Map<String, Map<String, String>> merge(Map<String, Map<String, String>> targetContext, Map<String, Map<String, String>> newContext) {
        HashMap<String, Map<String, String>> result = DataContextUtils.deepCopy(targetContext);
        for (Map.Entry<String, Map<String, String>> entry : newContext.entrySet()) {
            if (!targetContext.containsKey(entry.getKey())) {
                result.put(entry.getKey(), new HashMap());
            } else {
                result.put(entry.getKey(), new HashMap<String, String>(targetContext.get(entry.getKey())));
            }
            result.get(entry.getKey()).putAll(entry.getValue());
        }
        return result;
    }

    private static HashMap<String, Map<String, String>> deepCopy(Map<String, Map<String, String>> context) {
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        for (Map.Entry<String, Map<String, String>> entry : context.entrySet()) {
            map.put(entry.getKey(), new HashMap<String, String>(entry.getValue()));
        }
        return map;
    }

    public static String replaceDataReferences(String input, Map<String, Map<String, String>> data, Converter<String, String> converter, boolean failOnUnexpanded) {
        if (null == data) {
            return input;
        }
        Pattern p = Pattern.compile("\\$\\{([^\\s.]+)\\.([^\\s}]+)\\}");
        Matcher m = p.matcher(input);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String value;
            String key = m.group(1);
            String nm = m.group(2);
            if (null != key && null != nm && null != data.get(key) && null != data.get(key).get(nm)) {
                value = data.get(key).get(nm);
                if (null != converter) {
                    value = converter.convert(value);
                }
                m.appendReplacement(sb, Matcher.quoteReplacement(value));
                continue;
            }
            if (failOnUnexpanded && null != key && null != nm && (null == data.get(key) || null == data.get(key).get(nm))) {
                throw new UnresolvedDataReferenceException(input, m.group());
            }
            value = m.group(0);
            if (null != converter) {
                value = converter.convert(value);
            }
            m.appendReplacement(sb, Matcher.quoteReplacement(value));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static String escapeShell(String s) {
        if (null == s) {
            return s;
        }
        if (s.startsWith("'") && s.endsWith("'")) {
            return s;
        }
        if (s.startsWith("\"") && s.endsWith("\"")) {
            return s.replaceAll("([\\\\`])", "\\\\$1");
        }
        return s.replaceAll("([&><|;\\\\`])", "\\\\$1");
    }

    public static String escapeWindowsShell(String s) {
        if (null == s) {
            return s;
        }
        if (s.startsWith("'") && s.endsWith("'")) {
            return s;
        }
        if (s.startsWith("\"") && s.endsWith("\"")) {
            return s.replaceAll("([`^])", "^$1");
        }
        return s.replaceAll("([&><|;^`])", "^$1");
    }

    public static File replaceTokensInFile(String sourceFile, Map<String, Map<String, String>> dataContext, Framework framework) throws IOException {
        return DataContextUtils.replaceTokensInFile(new File(sourceFile), dataContext, framework);
    }

    public static File replaceTokensInFile(File sourceFile, Map<String, Map<String, String>> dataContext, Framework framework) throws IOException {
        ReplaceTokens replaceTokens = new ReplaceTokens((Reader)new InputStreamReader(new FileInputStream(sourceFile)));
        Map<String, String> toks = DataContextUtils.flattenDataContext(dataContext);
        DataContextUtils.configureReplaceTokens(toks, replaceTokens);
        File temp = ScriptfileUtils.writeScriptTempfile(framework, (Reader)replaceTokens);
        ScriptfileUtils.setExecutePermissions(temp);
        return temp;
    }

    public static File replaceTokensInScript(String script, Map<String, Map<String, String>> dataContext, Framework framework) throws IOException {
        StringReader read = new StringReader(script);
        ReplaceTokens replaceTokens = new ReplaceTokens((Reader)read);
        Map<String, String> toks = DataContextUtils.flattenDataContext(dataContext);
        DataContextUtils.configureReplaceTokens(toks, replaceTokens);
        File temp = ScriptfileUtils.writeScriptTempfile(framework, (Reader)replaceTokens);
        ScriptfileUtils.setExecutePermissions(temp);
        return temp;
    }

    public static File replaceTokensInStream(InputStream stream, Map<String, Map<String, String>> dataContext, Framework framework) throws IOException {
        ReplaceTokens replaceTokens = new ReplaceTokens((Reader)new InputStreamReader(stream));
        Map<String, String> toks = DataContextUtils.flattenDataContext(dataContext);
        DataContextUtils.configureReplaceTokens(toks, replaceTokens);
        File temp = ScriptfileUtils.writeScriptTempfile(framework, (Reader)replaceTokens);
        ScriptfileUtils.setExecutePermissions(temp);
        return temp;
    }

    public static Map<String, String> flattenDataContext(Map<String, Map<String, String>> dataContext) {
        HashMap<String, String> res = new HashMap<String, String>();
        if (null != dataContext) {
            for (Map.Entry<String, Map<String, String>> entry : dataContext.entrySet()) {
                String p = entry.getKey() + ".";
                Map<String, String> map = entry.getValue();
                if (null == map) continue;
                for (Map.Entry<String, String> entry2 : map.entrySet()) {
                    if (null == map.get(entry2.getKey())) continue;
                    res.put(p + entry2.getKey(), entry2.getValue());
                }
            }
        }
        return res;
    }

    public static void configureReplaceTokens(Map<String, String> data, ReplaceTokens replaceTokens) {
        replaceTokens.setBeginToken('@');
        replaceTokens.setEndToken('@');
        for (Map.Entry<String, String> entry : data.entrySet()) {
            ReplaceTokens.Token token = new ReplaceTokens.Token();
            token.setKey(entry.getKey());
            token.setValue(entry.getValue());
            replaceTokens.addConfiguredToken(token);
        }
    }

    public static Map<String, String> generateEnvVarsFromData(Map<String, String> options, String prefix) {
        if (null == options) {
            return null;
        }
        HashMap<String, String> envs = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : options.entrySet()) {
            if (null == entry.getKey() || null == entry.getValue()) continue;
            envs.put(DataContextUtils.generateEnvVarName(prefix + "." + entry.getKey()), entry.getValue());
        }
        return envs;
    }

    public static void addEnvVarsFromContextForExec(ExecTask execTask, Map<String, Map<String, String>> dataContext) {
        Map<String, String> environment = DataContextUtils.generateEnvVarsFromContext(dataContext);
        if (null != environment) {
            for (Map.Entry<String, String> entry : environment.entrySet()) {
                String key = entry.getKey();
                if (null == key || null == entry.getValue()) continue;
                Environment.Variable env = new Environment.Variable();
                env.setKey(key);
                env.setValue(entry.getValue());
                execTask.addEnv(env);
            }
        }
    }

    public static void addEnvVars(EnvironmentConfigurable sshexecTask, Map<String, Map<String, String>> dataContext) {
        Map<String, String> environment = DataContextUtils.generateEnvVarsFromContext(dataContext);
        if (null != environment) {
            for (Map.Entry<String, String> entry : environment.entrySet()) {
                String key = entry.getKey();
                if (null == key || null == entry.getValue()) continue;
                Environment.Variable env = new Environment.Variable();
                env.setKey(key);
                env.setValue(entry.getValue());
                sshexecTask.addEnv(env);
            }
        }
    }

    public static Map<String, String> generateEnvVarsFromContext(Map<String, Map<String, String>> dataContext) {
        HashMap<String, String> context = new HashMap<String, String>();
        if (null != dataContext) {
            for (Map.Entry<String, Map<String, String>> entry : dataContext.entrySet()) {
                Map<String, String> envs = DataContextUtils.generateEnvVarsFromData(entry.getValue(), entry.getKey());
                if (null == envs) continue;
                context.putAll(envs);
            }
        }
        return context;
    }

    public static String generateEnvVarName(String key) {
        return ENV_VAR_PREFIX + key.toUpperCase().replaceAll("[^a-zA-Z0-9_]", "_");
    }

    public static Map<String, Map<String, String>> addContext(String key, Map<String, String> data, Map<String, Map<String, String>> context) {
        HashMap<String, Map<String, String>> newdata = new HashMap<String, Map<String, String>>();
        if (null != context) {
            newdata.putAll(context);
        }
        newdata.put(key, data);
        return newdata;
    }

    public static Map<String, String> nodeData(INodeEntry nodeentry) {
        HashMap<String, String> data = new HashMap<String, String>();
        if (null != nodeentry) {
            HashSet<String> skipProps = new HashSet<String>();
            skipProps.addAll(Arrays.asList("nodename", "osName", "osVersion", "osArch", "osFamily"));
            data.put("name", DataContextUtils.notNull(nodeentry.getNodename()));
            data.put("hostname", DataContextUtils.notNull(nodeentry.getHostname()));
            data.put("os-name", DataContextUtils.notNull(nodeentry.getOsName()));
            data.put("os-version", DataContextUtils.notNull(nodeentry.getOsVersion()));
            data.put("os-arch", DataContextUtils.notNull(nodeentry.getOsArch()));
            data.put("os-family", DataContextUtils.notNull(nodeentry.getOsFamily()));
            data.put("username", DataContextUtils.notNull(nodeentry.getUsername()));
            data.put("description", DataContextUtils.notNull(nodeentry.getDescription()));
            data.put("tags", null != nodeentry.getTags() ? DataContextUtils.join(nodeentry.getTags(), ",") : "");
            if (null != nodeentry.getAttributes()) {
                for (String name : nodeentry.getAttributes().keySet()) {
                    if (null == nodeentry.getAttributes().get(name) || data.containsKey(name) || skipProps.contains(name)) continue;
                    data.put(name, DataContextUtils.notNull(nodeentry.getAttributes().get(name)));
                }
            }
        }
        return data;
    }

    private static String notNull(String value) {
        return null != value ? value : "";
    }

    public static String join(Collection<String> list, String separator) {
        StringBuilder sb = new StringBuilder();
        for (String s : list) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static interface EnvironmentConfigurable {
        public void addEnv(Environment.Variable var1);
    }

    public static class UnresolvedDataReferenceException
    extends RuntimeException {
        private String template;
        private String referenceName;

        public UnresolvedDataReferenceException(String template, String referenceName) {
            super("Property " + referenceName + " could not be resolved in template: " + template);
            this.template = template;
            this.referenceName = referenceName;
        }

        public String getTemplate() {
            return this.template;
        }

        public String getReferenceName() {
            return this.referenceName;
        }
    }
}

