/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.workflow;

import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.ExecutionListenerOverride;
import com.dtolabs.rundeck.core.execution.FailedNodesListener;
import com.dtolabs.rundeck.core.execution.StepExecutionItem;
import com.dtolabs.rundeck.core.execution.workflow.ContextLogger;
import com.dtolabs.rundeck.core.execution.workflow.ContextStack;
import com.dtolabs.rundeck.core.execution.workflow.ContextualExecutionListener;
import com.dtolabs.rundeck.core.execution.workflow.StepExecutionContext;
import com.dtolabs.rundeck.core.execution.workflow.WFStepContext;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionItem;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionListener;
import com.dtolabs.rundeck.core.execution.workflow.WorkflowExecutionResult;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepExecutionItem;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepResult;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class WorkflowExecutionListenerImpl
extends ContextualExecutionListener
implements WorkflowExecutionListener {
    private InheritableThreadLocal<WFStepContext> localStep = new InheritableThreadLocal();
    private InheritableThreadLocal<INodeEntry> localNode = new InheritableThreadLocal();
    private InheritableThreadLocal<ContextStack<WFStepContext>> contextStack = new InheritableThreadLocal();
    private WorkflowExecutionListenerImpl delegate;

    protected WorkflowExecutionListenerImpl(WorkflowExecutionListenerImpl delegate) {
        super(delegate);
        this.delegate = delegate;
    }

    public WorkflowExecutionListenerImpl(FailedNodesListener failedNodesListener, ContextLogger logger, boolean terse, String logFormat) {
        super(failedNodesListener, logger, terse, logFormat);
    }

    @Override
    public void beginExecuteNodeStep(ExecutionContext context, NodeStepExecutionItem item, INodeEntry node) {
        if (null != this.delegate) {
            this.delegate.beginExecuteNodeStep(context, item, node);
            return;
        }
        super.beginExecuteNodeStep(context, item, node);
        this.localNode.set(node);
        this.log(4, "[workflow] beginExecuteNodeStep(" + node.getNodename() + "): " + item.getType() + ": " + item);
    }

    @Override
    public void finishExecuteNodeStep(NodeStepResult result, ExecutionContext context, StepExecutionItem item, INodeEntry node) {
        if (null != this.delegate) {
            this.delegate.finishExecuteNodeStep(result, context, item, node);
            return;
        }
        super.finishExecuteNodeStep(result, context, item, node);
        this.localNode.set(null);
        this.log(4, "[workflow] finishExecuteNodeStep(" + node.getNodename() + "): " + item.getType() + ": " + result);
    }

    @Override
    public Map<String, String> getLoggingContext() {
        if (null != this.delegate) {
            return this.delegate.getLoggingContext();
        }
        if (null != this.localStep.get() || null != this.localNode.get()) {
            HashMap<String, String> loggingContext = new HashMap<String, String>();
            if (null != this.localNode.get()) {
                INodeEntry node = (INodeEntry)this.localNode.get();
                loggingContext.put("node", node.getNodename());
                loggingContext.put("user", node.extractUserName());
            }
            if (null != this.localStep.get()) {
                WFStepContext wfStepInfo = (WFStepContext)this.localStep.get();
                int step = wfStepInfo.getStep();
                if (null != this.contextStack.get()) {
                    loggingContext.put("command", this.generateContextString(((ContextStack)this.contextStack.get()).copyPush(wfStepInfo)));
                } else {
                    loggingContext.put("command", this.generateContextString(ContextStack.create(wfStepInfo)));
                }
                if (step > -1) {
                    loggingContext.put("step", Integer.toString(step));
                }
            }
            return loggingContext;
        }
        return null;
    }

    private String generateContextString(ContextStack<WFStepContext> stack) {
        if (null != this.delegate) {
            return this.delegate.generateContextString(stack);
        }
        Object[] strings = new String[stack.size()];
        int i = 0;
        for (WFStepContext context : stack.stack()) {
            strings[i++] = this.makePrefix(context);
        }
        return StringUtils.join((Object[])strings, (String)":");
    }

    private String makePrefix(WFStepContext wfStepInfo) {
        if (null != this.delegate) {
            return this.delegate.makePrefix(wfStepInfo);
        }
        String type = wfStepInfo.getStepItem().getType();
        if (wfStepInfo.getStepItem() instanceof NodeStepExecutionItem) {
            NodeStepExecutionItem ns = (NodeStepExecutionItem)wfStepInfo.getStepItem();
            type = type + "-" + ns.getNodeStepType();
        }
        return wfStepInfo.getStep() + "-" + type;
    }

    @Override
    public void beginWorkflowExecution(StepExecutionContext executionContext, WorkflowExecutionItem item) {
        if (null != this.delegate) {
            this.delegate.beginWorkflowExecution(executionContext, item);
            return;
        }
        if (null != this.localStep.get()) {
            WFStepContext info = (WFStepContext)this.localStep.get();
            if (null != this.contextStack.get()) {
                this.contextStack.set(((ContextStack)this.contextStack.get()).copyPush(info));
            } else {
                this.contextStack.set(ContextStack.create(info));
            }
        }
        this.localStep.set(null);
        this.localNode.set(null);
        this.log(4, "[workflow] Begin execution: " + item.getType() + " context: " + this.contextStack.get());
    }

    @Override
    public void finishWorkflowExecution(WorkflowExecutionResult result, StepExecutionContext executionContext, WorkflowExecutionItem item) {
        if (null != this.delegate) {
            this.delegate.finishWorkflowExecution(result, executionContext, item);
            return;
        }
        ContextStack stack = (ContextStack)this.contextStack.get();
        if (null != stack) {
            if (stack.size() > 0) {
                this.contextStack.set(stack.copyPop());
            } else {
                this.contextStack.set(null);
            }
        }
        this.localStep.set(null);
        this.localNode.set(null);
        this.log(4, "[workflow] Finish execution:  " + item.getType() + ": " + result);
    }

    @Override
    public void beginWorkflowItem(int step, StepExecutionItem item) {
        if (null != this.delegate) {
            this.delegate.beginWorkflowItem(step, item);
            return;
        }
        this.localStep.set(new WFStepContext(item, step));
        this.log(4, "[workflow] Begin step: " + step + "," + item.getType());
    }

    @Override
    public void finishWorkflowItem(int step, StepExecutionItem item) {
        if (null != this.delegate) {
            this.delegate.finishWorkflowItem(step, item);
            return;
        }
        this.localStep.set(null);
        this.log(4, "[workflow] Finish step: " + step + "," + item.getType());
    }

    @Override
    public ExecutionListenerOverride createOverride() {
        return new WorkflowExecutionListenerImpl(this);
    }
}

