/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.jndi;

import com.dtolabs.rundeck.core.jndi.JndiConfig;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.log4j.Category;

public class Jndi {
    static Category logger = Category.getInstance((String)Jndi.class.getName());
    private DirContext initialDirContext;
    private String connectionName;
    private String connectionPassword;
    private String connectionUrl;
    private String roleBase;
    private String roleNameRDN;
    private String roleMemberRDN;
    private String userBase;
    private String userNameRDN;

    public void setInitialDirContext(DirContext initialDirContext) {
        this.initialDirContext = initialDirContext;
    }

    public DirContext getInitialDirContext() {
        return this.initialDirContext;
    }

    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public void setConnectionPassword(String connectionPassword) {
        this.connectionPassword = connectionPassword;
    }

    public String getConnectionPassword() {
        return this.connectionPassword;
    }

    public void setConnectionUrl(String connectionUrl) {
        this.connectionUrl = connectionUrl;
    }

    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    public void setRoleBase(String roleBase) {
        this.roleBase = roleBase;
    }

    public String getRoleBase() {
        return this.roleBase;
    }

    public void setRoleNameRDN(String roleNameRDN) {
        this.roleNameRDN = roleNameRDN;
    }

    public String getRoleNameRDN() {
        return this.roleNameRDN;
    }

    public void setRoleMemberRDN(String roleMemberRDN) {
        this.roleMemberRDN = roleMemberRDN;
    }

    public String getRoleMemberRDN() {
        return this.roleMemberRDN;
    }

    public void setUserBase(String userBase) {
        this.userBase = userBase;
    }

    public String getUserBase() {
        return this.userBase;
    }

    public void setUserNameRDN(String userNameRDN) {
        this.userNameRDN = userNameRDN;
    }

    public String getUserNameRDN() {
        return this.userNameRDN;
    }

    public Jndi(String connectionName, String connectionPassword, String connectionUrl, String roleBase, String roleNameRDN, String roleMemberRDN, String userBase, String userNameRDN) throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>(11);
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", connectionUrl);
        env.put("java.naming.security.principal", connectionName);
        env.put("java.naming.security.credentials", connectionPassword);
        InitialDirContext initialCtx = new InitialDirContext(env);
        this.setInitialDirContext(initialCtx);
        this.setConnectionName(connectionName);
        this.setConnectionPassword(connectionPassword);
        this.setConnectionUrl(connectionUrl);
        this.setRoleBase(roleBase);
        this.setRoleNameRDN(roleNameRDN);
        this.setRoleMemberRDN(roleMemberRDN);
        this.setUserBase(userBase);
        this.setUserNameRDN(userNameRDN);
    }

    public Jndi(JndiConfig cfg) throws NamingException {
        this(cfg.getConnectionName(), cfg.getConnectionPassword(), cfg.getConnectionUrl(), cfg.getRoleBase(), cfg.getRoleNameRDN(), cfg.getRoleMemberRDN(), cfg.getUserBase(), cfg.getUserNameRDN());
    }

    public String[] getUsers(String roleName) throws NamingException {
        logger.debug((Object)("Obtaining users for roleName: " + roleName));
        String roleBase = this.getRoleBase();
        String filter = "(" + this.getRoleNameRDN() + "=" + roleName + ")";
        logger.debug((Object)("returningAttributes set to: " + this.getRoleMemberRDN()));
        NamingEnumeration roleResults = this.search(roleBase, filter, new String[]{this.getRoleMemberRDN()});
        String[] users = this.getUsers(roleName, roleResults);
        return users;
    }

    public String[] getRoles(String userName) throws NamingException {
        logger.debug((Object)("Obtaining roles for userName: " + userName));
        String roleBase = this.getRoleBase();
        String filter = "(" + this.getRoleNameRDN() + "=*)";
        logger.debug((Object)("returningAttributes set to: " + this.getRoleMemberRDN()));
        NamingEnumeration roleResults = this.search(roleBase, filter, new String[]{this.getRoleMemberRDN()});
        String[] roles = this.getRoles(userName, roleResults);
        return roles;
    }

    private String[] getUsers(String roleName, NamingEnumeration roleResults) throws NamingException {
        ArrayList<String> userList = new ArrayList<String>();
        while (roleResults != null && roleResults.hasMore()) {
            SearchResult roleResult = (SearchResult)roleResults.next();
            String roleResultName = roleResult.getName();
            if ("".equals(roleResultName)) {
                logger.debug((Object)"ignoring empty result");
                continue;
            }
            logger.debug((Object)("retrieved roleResultName: " + roleResultName + ", setting return list"));
            String roleResultValue = roleResultName.split("=")[1];
            Attributes roleAttrs = roleResult.getAttributes();
            Attribute roleAttr = roleAttrs.get(this.getRoleMemberRDN());
            NamingEnumeration<?> valueEnum = roleAttr.getAll();
            while (valueEnum != null && valueEnum.hasMore()) {
                String value = (String)valueEnum.next();
                logger.debug((Object)("belongs to: " + roleResultValue));
                userList.add(value);
            }
        }
        String[] users = null;
        users = null != userList ? this.toStringArray(userList) : new String[]{};
        return users;
    }

    private String[] getRoles(String userName, NamingEnumeration roleResults) throws NamingException {
        String userDNRegex = "^" + this.getUserNameRDN() + "=" + userName + ",.*,{0,1}" + this.getUserBase() + "$";
        logger.debug((Object)(userName + " has regex dn: " + userDNRegex));
        ArrayList<String> roleList = new ArrayList<String>();
        logger.debug((Object)"processing results");
        block0: while (roleResults != null && roleResults.hasMore()) {
            SearchResult roleResult = (SearchResult)roleResults.next();
            String roleResultName = roleResult.getName();
            if ("".equals(roleResultName)) {
                logger.debug((Object)"ignoring empty result");
                continue;
            }
            logger.debug((Object)("retrieved roleResultName: " + roleResultName + ", setting return list"));
            String roleResultValue = roleResultName.split("=")[1];
            logger.debug((Object)("roleResultValue: " + roleResultValue));
            Attributes roleAttrs = roleResult.getAttributes();
            if (roleAttrs.size() == 0) {
                logger.debug((Object)("no attributes defined for role: " + roleResultName + " continuing"));
                continue;
            }
            Attribute roleAttr = roleAttrs.get(this.getRoleMemberRDN());
            if (null != roleAttr) {
                NamingEnumeration<?> valueEnum = roleAttr.getAll();
                while (valueEnum != null && valueEnum.hasMore()) {
                    String value = (String)valueEnum.next();
                    logger.debug((Object)("checking value: " + value));
                    if (!value.matches(userDNRegex)) continue;
                    logger.debug((Object)("belongs to: " + roleResultValue));
                    roleList.add(roleResultValue);
                    continue block0;
                }
                continue;
            }
            logger.debug((Object)("roleMemberRdn: " + this.getRoleMemberRDN() + " not found, continuing"));
        }
        String[] roles = null;
        roles = null != roleList ? this.toStringArray(roleList) : new String[]{};
        return roles;
    }

    private String[] toStringArray(List list) {
        return list.toArray(new String[list.size()]);
    }

    private NamingEnumeration search(String base, String filter, String[] returnAttrs) throws NamingException {
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        constraints.setReturningAttributes(returnAttrs);
        logger.debug((Object)("searching, base: " + base + " using filter: " + filter));
        DirContext initialDirContext = this.getInitialDirContext();
        NamingEnumeration<SearchResult> results = initialDirContext.search(base, filter, constraints);
        return results;
    }
}

