/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.plugins.configuration;

import com.dtolabs.rundeck.core.plugins.configuration.Property;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyBase;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyScope;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyValidator;
import com.dtolabs.rundeck.core.plugins.configuration.ValidationException;
import java.util.List;

public class PropertyUtil {
    static final PropertyValidator booleanValidator = new PropertyValidator(){

        @Override
        public boolean isValid(String value) throws ValidationException {
            return "true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value);
        }
    };
    static final PropertyValidator integerValidator = new PropertyValidator(){

        @Override
        public boolean isValid(String value) throws ValidationException {
            try {
                Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                throw new ValidationException("Not a valid integer");
            }
            return true;
        }
    };
    static final PropertyValidator longValidator = new PropertyValidator(){

        @Override
        public boolean isValid(String value) throws ValidationException {
            try {
                Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                throw new ValidationException("Not a valid integer");
            }
            return true;
        }
    };

    public static Property forType(Property.Type type, String name, String title, String description, boolean required, String defaultValue, List<String> values) {
        return PropertyUtil.forType(type, name, title, description, required, defaultValue, values, null);
    }

    public static Property forType(Property.Type type, String name, String title, String description, boolean required, String defaultValue, List<String> values, PropertyValidator validator) {
        return PropertyUtil.forType(type, name, title, description, required, defaultValue, values, validator, null);
    }

    public static Property forType(Property.Type type, String name, String title, String description, boolean required, String defaultValue, List<String> values, PropertyValidator validator, PropertyScope scope) {
        switch (type) {
            case Integer: {
                return PropertyUtil.integer(name, title, description, required, defaultValue, validator, scope);
            }
            case Boolean: {
                return PropertyUtil.bool(name, title, description, required, defaultValue, scope);
            }
            case Long: {
                return PropertyUtil.longProp(name, title, description, required, defaultValue, validator, scope);
            }
            case Select: {
                return PropertyUtil.select(name, title, description, required, defaultValue, values, scope);
            }
            case FreeSelect: {
                return PropertyUtil.freeSelect(name, title, description, required, defaultValue, values, validator, scope);
            }
        }
        return PropertyUtil.string(name, title, description, required, defaultValue, validator, scope);
    }

    public static Property string(String name, String title, String description, boolean required, String defaultValue) {
        return PropertyUtil.string(name, title, description, required, defaultValue, null);
    }

    public static Property string(String name, String title, String description, boolean required, String defaultValue, PropertyValidator validator) {
        return PropertyUtil.string(name, title, description, required, defaultValue, validator, null);
    }

    public static Property string(String name, String title, String description, boolean required, String defaultValue, PropertyValidator validator, PropertyScope scope) {
        return new StringProperty(name, title, description, required, defaultValue, validator, scope);
    }

    public static Property bool(String name, String title, String description, boolean required, String defaultValue) {
        return PropertyUtil.bool(name, title, description, required, defaultValue, null);
    }

    public static BooleanProperty bool(String name, String title, String description, boolean required, String defaultValue, PropertyScope scope) {
        return new BooleanProperty(name, title, description, required, defaultValue, scope);
    }

    public static Property integer(String name, String title, String description, boolean required, String defaultValue) {
        return PropertyUtil.integer(name, title, description, required, defaultValue, null);
    }

    public static Property integer(String name, String title, String description, boolean required, String defaultValue, PropertyValidator validator) {
        return PropertyUtil.integer(name, title, description, required, defaultValue, validator, null);
    }

    public static Property integer(String name, String title, String description, boolean required, String defaultValue, PropertyValidator validator, PropertyScope scope) {
        return new IntegerProperty(name, title, description, required, defaultValue, validator, scope);
    }

    public static Property longProp(String name, String title, String description, boolean required, String defaultValue) {
        return PropertyUtil.longProp(name, title, description, required, defaultValue, null);
    }

    public static Property longProp(String name, String title, String description, boolean required, String defaultValue, PropertyValidator validator) {
        return PropertyUtil.longProp(name, title, description, required, defaultValue, validator, null);
    }

    public static Property longProp(String name, String title, String description, boolean required, String defaultValue, PropertyValidator validator, PropertyScope scope) {
        return new LongProperty(name, title, description, required, defaultValue, validator, scope);
    }

    public static Property select(String name, String title, String description, boolean required, String defaultValue, List<String> selectValues) {
        return PropertyUtil.select(name, title, description, required, defaultValue, selectValues, null);
    }

    public static Property select(String name, String title, String description, boolean required, String defaultValue, List<String> selectValues, PropertyScope scope) {
        return new SelectProperty(name, title, description, required, defaultValue, selectValues, scope);
    }

    public static Property freeSelect(String name, String title, String description, boolean required, String defaultValue, List<String> selectValues) {
        return PropertyUtil.freeSelect(name, title, description, required, defaultValue, selectValues, null);
    }

    public static Property freeSelect(String name, String title, String description, boolean required, String defaultValue, List<String> selectValues, PropertyValidator validator) {
        return PropertyUtil.freeSelect(name, title, description, required, defaultValue, selectValues, validator, null);
    }

    public static Property freeSelect(String name, String title, String description, boolean required, String defaultValue, List<String> selectValues, PropertyValidator validator, PropertyScope scope) {
        return new FreeSelectProperty(name, title, description, required, defaultValue, selectValues, validator, scope);
    }

    static PropertyValidator andValidator(final PropertyValidator first, final PropertyValidator second) {
        if (null == first) {
            return second;
        }
        if (null == second) {
            return first;
        }
        return new PropertyValidator(){

            @Override
            public boolean isValid(String value) throws ValidationException {
                return first.isValid(value) && second.isValid(value);
            }
        };
    }

    private static class Generic
    extends PropertyBase {
        private final Property.Type type;

        public Generic(String name, String title, String description, boolean required, String defaultValue, PropertyValidator validator, Property.Type type) {
            super(name, title, description, required, defaultValue, validator);
            this.type = type;
        }

        @Override
        public Property.Type getType() {
            return this.type;
        }
    }

    static final class LongProperty
    extends PropertyBase {
        public LongProperty(String name, String title, String description, boolean required, String defaultValue, PropertyValidator validator, PropertyScope scope) {
            super(name, title, description, required, defaultValue, PropertyUtil.andValidator(longValidator, validator), scope);
        }

        @Override
        public Property.Type getType() {
            return Property.Type.Long;
        }
    }

    static final class IntegerProperty
    extends PropertyBase {
        public IntegerProperty(String name, String title, String description, boolean required, String defaultValue, PropertyValidator validator, PropertyScope scope) {
            super(name, title, description, required, defaultValue, PropertyUtil.andValidator(integerValidator, validator), scope);
        }

        @Override
        public Property.Type getType() {
            return Property.Type.Integer;
        }
    }

    static final class BooleanProperty
    extends PropertyBase {
        public BooleanProperty(String name, String title, String description, boolean required, String defaultValue, PropertyScope scope) {
            super(name, title, description, required, defaultValue, booleanValidator, scope);
        }

        @Override
        public Property.Type getType() {
            return Property.Type.Boolean;
        }
    }

    static final class SelectValidator
    implements PropertyValidator {
        final List<String> selectValues;

        SelectValidator(List<String> selectValues) {
            this.selectValues = selectValues;
        }

        @Override
        public boolean isValid(String value) throws ValidationException {
            return this.selectValues.contains(value);
        }
    }

    static final class SelectProperty
    extends PropertyBase {
        final List<String> selectValues;

        public SelectProperty(String name, String title, String description, boolean required, String defaultValue, List<String> selectValues, PropertyScope scope) {
            super(name, title, description, required, defaultValue, new SelectValidator(selectValues), scope);
            this.selectValues = selectValues;
        }

        @Override
        public Property.Type getType() {
            return Property.Type.Select;
        }

        @Override
        public List<String> getSelectValues() {
            return this.selectValues;
        }
    }

    static final class FreeSelectProperty
    extends PropertyBase {
        final List<String> selectValues;

        public FreeSelectProperty(String name, String title, String description, boolean required, String defaultValue, List<String> selectValues, PropertyValidator validator, PropertyScope scope) {
            super(name, title, description, required, defaultValue, validator, scope);
            this.selectValues = selectValues;
        }

        @Override
        public Property.Type getType() {
            return Property.Type.FreeSelect;
        }

        @Override
        public List<String> getSelectValues() {
            return this.selectValues;
        }
    }

    static final class StringProperty
    extends PropertyBase {
        public StringProperty(String name, String title, String description, boolean required, String defaultValue, PropertyValidator validator, PropertyScope scope) {
            super(name, title, description, required, defaultValue, validator, scope);
        }

        @Override
        public Property.Type getType() {
            return Property.Type.String;
        }
    }
}

