/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.plugins.configuration;

import com.dtolabs.rundeck.core.plugins.configuration.Description;
import com.dtolabs.rundeck.core.plugins.configuration.Property;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyValidator;
import com.dtolabs.rundeck.core.plugins.configuration.ValidationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class Validator {
    public static Report validate(Properties props, Description desc) {
        Report report = new Report();
        List<Property> properties = desc.getProperties();
        if (null != properties) {
            for (Property property : properties) {
                String key = property.getName();
                String value = props.getProperty(key);
                if (null == value || "".equals(value)) {
                    if (!property.isRequired()) continue;
                    report.errors.put(key, "required");
                    continue;
                }
                PropertyValidator validator = property.getValidator();
                if (null == validator) continue;
                try {
                    if (validator.isValid(value)) continue;
                    report.errors.put(key, "Invalid value");
                }
                catch (ValidationException e) {
                    report.errors.put(key, "Invalid value: " + e.getMessage());
                }
            }
        }
        return report;
    }

    public static Map<String, String> mapProperties(Map<String, String> input, Description desc) {
        Map<String, String> mapping = desc.getPropertiesMapping();
        if (null == mapping) {
            return input;
        }
        return Validator.performMapping(input, mapping, false);
    }

    private static Map<String, String> performMapping(Map<String, String> input, Map<String, String> mapping, boolean skip) {
        HashMap<String, String> props = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : input.entrySet()) {
            if (null != mapping.get(entry.getKey())) {
                props.put(mapping.get(entry.getKey()), entry.getValue());
                continue;
            }
            if (skip) continue;
            props.put(entry.getKey(), entry.getValue());
        }
        return props;
    }

    public static Map<String, String> demapProperties(Map<String, String> input, Description desc) {
        Map<String, String> mapping = desc.getPropertiesMapping();
        if (null == mapping) {
            return input;
        }
        HashMap<String, String> rev = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : mapping.entrySet()) {
            rev.put(entry.getValue(), entry.getKey());
        }
        return Validator.performMapping(input, rev, true);
    }

    public static class Report {
        private HashMap<String, String> errors = new HashMap();

        public HashMap<String, String> getErrors() {
            return this.errors;
        }

        public boolean isValid() {
            return 0 == this.errors.size();
        }
    }
}

