/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.utils;

import com.dtolabs.rundeck.core.utils.MapGenerator;
import com.dtolabs.rundeck.core.utils.Reformatter;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;

public class LogReformatter
implements Reformatter {
    private Map<String, String> data;
    private MapGenerator<String, String> generator;
    private final MessageFormat messageFormat;

    private LogReformatter(String format) {
        String s = "{4}";
        if (null != format) {
            s = format.replaceAll("%user", "{0}");
            s = s.replaceAll("%node", "{1}");
            s = s.replaceAll("%command", "{2}");
            s = s.replaceAll("%level", "{3}");
            s = s.replaceAll("%message", "{4}");
        }
        this.messageFormat = new MessageFormat(s);
    }

    public LogReformatter(String format, Map<String, String> data) {
        this(format);
        this.data = data;
    }

    public LogReformatter(String format, MapGenerator<String, String> generator) {
        this(format);
        this.generator = generator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String reformat(Map<String, String> context, String message) {
        HashMap<String, String> tokens = new HashMap<String, String>();
        if (null != context) {
            tokens.putAll(context);
        }
        if (null != this.generator) {
            tokens.putAll(this.generator.getMap());
        } else if (null != this.data) {
            tokens.putAll(this.data);
        }
        String[] arr = new String[]{null != tokens.get("user") ? (String)tokens.get("user") : "", null != tokens.get("node") ? (String)tokens.get("node") : "", null != tokens.get("command") ? (String)tokens.get("command") : "", (String)tokens.get("level"), message};
        MessageFormat messageFormat = this.messageFormat;
        synchronized (messageFormat) {
            return this.messageFormat.format(arr);
        }
    }
}

