/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.utils;

import com.dtolabs.rundeck.core.cli.CLIUtils;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.dispatcher.DataContextUtils;
import com.dtolabs.rundeck.core.utils.Converter;
import com.dtolabs.utils.Streams;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class ScriptExecUtil {
    public static int runLocalCommand(String[] command, Map<String, String> envMap, File workingdir, OutputStream outputStream, OutputStream errorStream) throws IOException, InterruptedException {
        String[] envarr = ScriptExecUtil.createEnvironmentArray(envMap);
        Runtime runtime = Runtime.getRuntime();
        Process exec = runtime.exec(command, envarr, workingdir);
        Streams.StreamCopyThread errthread = Streams.copyStreamThread(exec.getErrorStream(), errorStream);
        Streams.StreamCopyThread outthread = Streams.copyStreamThread(exec.getInputStream(), outputStream);
        errthread.start();
        outthread.start();
        exec.getOutputStream().close();
        int result = exec.waitFor();
        errthread.join();
        outthread.join();
        if (null != outthread.getException()) {
            throw outthread.getException();
        }
        if (null != errthread.getException()) {
            throw errthread.getException();
        }
        return result;
    }

    private static String[] createEnvironmentArray(Map<String, String> envMap) {
        ArrayList<String> envlist = new ArrayList<String>();
        for (Map.Entry<String, String> entry : envMap.entrySet()) {
            envlist.add(entry.getKey() + "=" + entry.getValue());
        }
        return envlist.toArray(new String[envlist.size()]);
    }

    public static String[] createScriptArgs(Map<String, Map<String, String>> localDataContext, String scriptargs, String[] scriptargsarr, String scriptinterpreter, boolean interpreterargsquoted, String filepath) {
        return ScriptExecUtil.createScriptArgs(localDataContext, null, scriptargs, scriptargsarr, scriptinterpreter, interpreterargsquoted, filepath);
    }

    public static String[] createScriptArgs(Map<String, Map<String, String>> localDataContext, INodeEntry node, String scriptargs, String[] scriptargsarr, String scriptinterpreter, boolean interpreterargsquoted, String filepath) {
        ArrayList<String> arglist = new ArrayList<String>();
        if (null != scriptinterpreter) {
            arglist.addAll(Arrays.asList(scriptinterpreter.split(" ")));
        }
        if (null != scriptinterpreter && interpreterargsquoted) {
            StringBuilder sbuf = new StringBuilder(filepath);
            if (null != scriptargs) {
                sbuf.append(" ");
                sbuf.append(DataContextUtils.replaceDataReferences(scriptargs, localDataContext));
            } else if (null != scriptargsarr) {
                String[] strings;
                for (String string : strings = DataContextUtils.replaceDataReferences(scriptargsarr, localDataContext)) {
                    sbuf.append(" ");
                    sbuf.append(string);
                }
            }
            arglist.add(sbuf.toString());
        } else {
            arglist.add(filepath);
            if (null != scriptargs) {
                arglist.addAll(Arrays.asList(DataContextUtils.replaceDataReferences(scriptargs.split(" "), localDataContext)));
            } else if (null != scriptargsarr) {
                String[] newargs = DataContextUtils.replaceDataReferences(scriptargsarr, localDataContext);
                Converter<String, String> quote = null != node ? CLIUtils.argumentQuoteForOperatingSystem(node.getOsFamily()) : CLIUtils.argumentQuoteForOperatingSystem(null);
                for (int i = 0; i < newargs.length; ++i) {
                    String replaced = newargs[i];
                    if (!replaced.equals(scriptargsarr[i]) || CLIUtils.containsSpace(replaced)) {
                        arglist.add(quote.convert(replaced));
                        continue;
                    }
                    arglist.add(replaced);
                }
            }
        }
        return arglist.toArray(new String[arglist.size()]);
    }
}

