/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.client.utils;

import com.dtolabs.client.utils.AuthorizationFailureException;
import com.dtolabs.client.utils.ClientState;
import com.dtolabs.client.utils.HttpAuthenticator;
import com.dtolabs.client.utils.HttpClientChannel;
import com.dtolabs.client.utils.HttpClientException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.log4j.Category;

class BaseHttpClientChannel
extends HttpClientChannel {
    static Category logger = Category.getInstance((String)BaseHttpClientChannel.class.getName());
    private HttpAuthenticator authenticator;

    public BaseHttpClientChannel(String urlSpec, HttpAuthenticator authenticator, Map query) {
        super(urlSpec, query);
        this.authenticator = authenticator;
    }

    public BaseHttpClientChannel(String urlSpec, HttpAuthenticator authenticator, Map query, OutputStream destination) {
        super(urlSpec, query, destination);
        this.authenticator = authenticator;
    }

    public BaseHttpClientChannel(String urlSpec, HttpAuthenticator authenticator, Map query, OutputStream destination, String expectedContentType) {
        super(urlSpec, query, destination, expectedContentType);
        this.authenticator = authenticator;
    }

    @Override
    protected void postMakeRequest() {
    }

    @Override
    protected RequestEntity getRequestEntity(PostMethod method) {
        return null;
    }

    @Override
    protected NameValuePair[] getRequestBody(PostMethod method) {
        return new NameValuePair[0];
    }

    @Override
    protected boolean isPostMethod() {
        return false;
    }

    @Override
    protected boolean doAuthentication(HttpMethod origMethod) throws HttpClientException {
        logger.debug((Object)"doAuthentication called");
        HttpState state = ClientState.getHttpState();
        this.getHttpClient().setState(state);
        URL reqUrl = this.getRequestURL();
        logger.debug((Object)"calling authenticator");
        if (!this.authenticator.authenticate(reqUrl, this.getHttpClient())) {
            ClientState.resetHttpState();
            throw new AuthorizationFailureException("Unable to authenticate user: " + this.authenticator.getUsername());
        }
        return true;
    }

    @Override
    protected boolean needsReAuthentication(int resultCode, HttpMethod method) {
        return this.authenticator.needsReAuthentication(resultCode, method);
    }
}

