/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.authorization.providers;

import com.dtolabs.rundeck.core.authorization.providers.PoliciesDocument;
import com.dtolabs.rundeck.core.authorization.providers.PoliciesParseException;
import com.dtolabs.rundeck.core.authorization.providers.PoliciesYaml;
import com.dtolabs.rundeck.core.authorization.providers.PolicyCollection;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class PoliciesCache
implements Iterable<PolicyCollection> {
    static final long DIR_LIST_CHECK_DELAY = Long.getLong(PoliciesCache.class.getName() + ".DirListCheckDelay", 60000L);
    static final long FILE_CHECK_DELAY = Long.getLong(PoliciesCache.class.getName() + ".FileCheckDelay", 60000L);
    private static final Logger logger = Logger.getLogger(PoliciesCache.class);
    static final FilenameFilter filenameFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".aclpolicy");
        }
    };
    private Set<File> warned = new HashSet<File>();
    private Map<File, CacheItem> cache = new HashMap<File, CacheItem>();
    private DocumentBuilder builder;
    private File rootDir;
    long lastDirListCheckTime = 0L;
    private File[] lastDirList;

    public PoliciesCache(File rootDir) throws ParserConfigurationException {
        this.rootDir = rootDir;
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        domFactory.setNamespaceAware(true);
        this.builder = domFactory.newDocumentBuilder();
        this.builder.setErrorHandler(null);
    }

    private File[] listDirFiles() {
        if (System.currentTimeMillis() - this.lastDirListCheckTime > DIR_LIST_CHECK_DELAY) {
            this.doListDir();
        }
        return this.lastDirList;
    }

    private void doListDir() {
        this.lastDirList = this.rootDir.listFiles(filenameFilter);
        this.lastDirListCheckTime = System.currentTimeMillis();
    }

    public synchronized void add(File file) throws PoliciesParseException {
        this.getDocument(file);
    }

    private PolicyCollection createEntry(File file) throws PoliciesParseException {
        try {
            Document document = this.builder.parse(file);
            if (this.warned.add(file)) {
                logger.warn((Object)("Deprecated ACLPOLICY format (XML): " + file.getAbsolutePath()));
            }
            return new PoliciesDocument(document, file);
        }
        catch (SAXException e) {
            try {
                return new PoliciesYaml(file);
            }
            catch (Exception e1) {
                throw new PoliciesParseException(e1);
            }
        }
        catch (IOException e) {
            throw new PoliciesParseException(e);
        }
    }

    public synchronized PolicyCollection getDocument(File file) throws PoliciesParseException {
        CacheItem entry = this.cache.get(file);
        long checkTime = System.currentTimeMillis();
        if (null == entry || checkTime - entry.cacheTime > FILE_CHECK_DELAY) {
            long lastmod = file.lastModified();
            if (null == entry || lastmod > entry.modTime) {
                if (!file.exists()) {
                    CacheItem remove = this.cache.remove(file);
                    entry = null;
                } else {
                    PolicyCollection entry1 = this.createEntry(file);
                    if (null != entry1) {
                        entry = new CacheItem(entry1, lastmod);
                        this.cache.put(file, entry);
                    } else {
                        this.cache.remove(file);
                        entry = null;
                    }
                }
            } else {
                entry.touch(checkTime);
            }
        }
        return null != entry ? entry.policyCollection : null;
    }

    @Override
    public Iterator<PolicyCollection> iterator() {
        File[] files = this.listDirFiles();
        return new cacheIterator(null != files ? Arrays.asList(files).iterator() : new ArrayList().iterator());
    }

    private class cacheIterator
    implements Iterator<PolicyCollection> {
        Iterator<File> intIter;
        private File nextFile;
        private PolicyCollection nextDocument;

        public cacheIterator(Iterator<File> intIter) {
            this.intIter = intIter;
            this.nextFile = this.intIter.hasNext() ? this.intIter.next() : null;
            this.loadNextDocument();
        }

        private void loadNextDocument() {
            while (this.hasNextFile() && null == this.nextDocument) {
                File nextFile2 = this.getNextFile();
                try {
                    this.nextDocument = PoliciesCache.this.getDocument(nextFile2);
                }
                catch (PoliciesParseException e) {
                    logger.warn((Object)("Unable to parse aclpolicy: " + nextFile2 + ". Reason " + e.getMessage()), (Throwable)e);
                    e.printStackTrace();
                }
            }
        }

        private File getNextFile() {
            File next = this.nextFile;
            this.nextFile = this.intIter.hasNext() ? this.intIter.next() : null;
            return next;
        }

        private PolicyCollection getNextDocument() {
            PolicyCollection doc = this.nextDocument;
            this.nextDocument = null;
            this.loadNextDocument();
            return doc;
        }

        public boolean hasNextFile() {
            return null != this.nextFile;
        }

        @Override
        public boolean hasNext() {
            return null != this.nextDocument;
        }

        @Override
        public PolicyCollection next() {
            return this.getNextDocument();
        }

        @Override
        public void remove() {
        }
    }

    private static class CacheItem {
        PolicyCollection policyCollection;
        Long cacheTime;
        Long modTime;

        private CacheItem(PolicyCollection policyCollection, Long modTime) {
            this.policyCollection = policyCollection;
            this.modTime = modTime;
            this.cacheTime = System.currentTimeMillis();
        }

        public void touch(Long time) {
            this.cacheTime = time;
        }
    }
}

