/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.cli.jobs;

import com.dtolabs.rundeck.core.Constants;
import com.dtolabs.rundeck.core.cli.BaseTool;
import com.dtolabs.rundeck.core.cli.CLIToolLogger;
import com.dtolabs.rundeck.core.cli.CLIToolOptions;
import com.dtolabs.rundeck.core.cli.CLIToolOptionsException;
import com.dtolabs.rundeck.core.cli.DefaultCLIToolLogger;
import com.dtolabs.rundeck.core.cli.FrameworkSingleProjectResolver;
import com.dtolabs.rundeck.core.cli.Log4JCLIToolLogger;
import com.dtolabs.rundeck.core.cli.SingleProjectResolver;
import com.dtolabs.rundeck.core.cli.jobs.JobsToolException;
import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.dispatcher.CentralDispatcherException;
import com.dtolabs.rundeck.core.dispatcher.DeleteJobResult;
import com.dtolabs.rundeck.core.dispatcher.ILoadJobsRequest;
import com.dtolabs.rundeck.core.dispatcher.IStoredJob;
import com.dtolabs.rundeck.core.dispatcher.IStoredJobLoadResult;
import com.dtolabs.rundeck.core.dispatcher.IStoredJobsQuery;
import com.dtolabs.rundeck.core.dispatcher.JobDefinitionFileFormat;
import com.dtolabs.rundeck.core.dispatcher.StoredJobsRequestDuplicateOption;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class JobsTool
extends BaseTool
implements IStoredJobsQuery,
ILoadJobsRequest {
    public static final Logger log4j = Logger.getLogger(JobsTool.class);
    public static final String ACTION_LIST = "list";
    public static final String ACTION_LOAD = "load";
    public static final String ACTION_PURGE = "purge";
    private StoredJobsRequestDuplicateOption duplicateOption = StoredJobsRequestDuplicateOption.update;
    private Actions action = Actions.list;
    private String argName;
    private String argGroup;
    private String argIdlist;
    String argProject;
    private boolean argVerbose;
    private File argFile;
    private JobDefinitionFileFormat format = JobDefinitionFileFormat.xml;
    private CLIToolLogger clilogger;
    public static final String GROUP_OPTION = "g";
    public static final String NAME_OPTION = "n";
    public static final String IDLIST_OPTION = "i";
    public static final String FILE_OPTION = "f";
    public static final String VERBOSE_OPTION = "v";
    public static final String NAME_OPTION_LONG = "name";
    public static final String GROUP_OPTION_LONG = "group";
    public static final String IDLIST_OPTION_LONG = "idlist";
    public static final String FILE_OPTION_LONG = "file";
    public static final String VERBOSE_OPTION_LONG = "verbose";
    public static final String PROJECT_OPTION = "p";
    public static final String PROJECT_OPTION_LONG = "project";
    public static final String DUPLICATE_OPTION = "d";
    public static final String DUPLICATE_OPTION_LONG = "duplicate";
    public static final String FORMAT_OPTION = "F";
    public static final String FORMAT_OPTION_LONG = "format";
    private final Framework framework;
    SingleProjectResolver internalResolver;

    public Actions getAction() {
        return this.action;
    }

    public void setAction(Actions action) {
        this.action = action;
    }

    public String getArgName() {
        return this.argName;
    }

    public void setArgName(String argName) {
        this.argName = argName;
    }

    public boolean isArgVerbose() {
        return this.argVerbose;
    }

    public void setArgVerbose(boolean argVerbose) {
        this.argVerbose = argVerbose;
    }

    @Override
    public String getNameMatch() {
        return this.getArgName();
    }

    @Override
    public String getGroupMatch() {
        return this.getArgGroup();
    }

    @Override
    public String getIdlist() {
        return this.getArgIdlist();
    }

    @Override
    public String getProjectFilter() {
        return this.getArgProject();
    }

    public File getArgFile() {
        return this.argFile;
    }

    public void setArgFile(File argFile) {
        this.argFile = argFile;
    }

    @Override
    public StoredJobsRequestDuplicateOption getDuplicateOption() {
        return this.duplicateOption;
    }

    @Override
    public String getProject() {
        return this.getArgProject();
    }

    public String getArgGroup() {
        return this.argGroup;
    }

    public void setArgGroup(String argGroup) {
        this.argGroup = argGroup;
    }

    public String getArgIdlist() {
        return this.argIdlist;
    }

    public void setArgIdlist(String argIdlist) {
        this.argIdlist = argIdlist;
    }

    public String getArgProject() {
        return this.argProject;
    }

    public void setArgProject(String argProject) {
        this.argProject = argProject;
    }

    public static void main(String[] args) throws Exception {
        PropertyConfigurator.configure((String)new File(Constants.getFrameworkConfigFile(), "log4j.properties").getAbsolutePath());
        JobsTool tool = new JobsTool(new DefaultCLIToolLogger());
        tool.setShouldExit(true);
        int exitCode = 1;
        try {
            tool.run(args);
            exitCode = 0;
        }
        catch (CLIToolOptionsException e) {
            exitCode = 2;
            tool.error(e.getMessage());
            tool.help();
        }
        catch (Throwable e) {
            if (e.getMessage() == null || tool.argVerbose) {
                e.printStackTrace();
            }
            tool.error("Error: " + e.getMessage());
        }
        tool.exit(exitCode);
    }

    public JobsTool() {
        this(Framework.getInstance(Constants.getSystemBaseDir()), new Log4JCLIToolLogger(log4j));
    }

    @Override
    protected boolean isUseHelpOption() {
        return true;
    }

    public JobsTool(CLIToolLogger logger) {
        this(Framework.getInstance(Constants.getSystemBaseDir()), logger);
    }

    public JobsTool(Framework framework) {
        this(framework, null);
    }

    public JobsTool(Framework framework, CLIToolLogger logger) {
        this.framework = framework;
        this.internalResolver = new FrameworkSingleProjectResolver(framework);
        this.clilogger = logger;
        if (null == this.clilogger) {
            this.clilogger = new Log4JCLIToolLogger(log4j);
        }
        CommonOptions commonOptions = new CommonOptions();
        LoadOptions loadOptions = new LoadOptions();
        ListOptions listOptions = new ListOptions();
        PurgeOptions purgeOptions = new PurgeOptions();
        this.addToolOptions(commonOptions);
        this.addToolOptions(loadOptions);
        this.addToolOptions(listOptions);
        this.addToolOptions(purgeOptions);
    }

    @Override
    public CommandLine parseArgs(String[] args) throws CLIToolOptionsException {
        CommandLine line = super.parseArgs(args);
        if (args.length > 0 && !args[0].startsWith("-")) {
            try {
                this.action = Actions.valueOf(args[0]);
            }
            catch (IllegalArgumentException e) {
                throw new CLIToolOptionsException("Invalid action: " + args[0] + ", must be one of: " + Arrays.toString((Object[])Actions.values()));
            }
        }
        return line;
    }

    @Override
    protected void go() throws JobsToolException, CLIToolOptionsException {
        switch (this.action) {
            case list: {
                this.listAction();
                break;
            }
            case load: {
                this.loadAction();
                break;
            }
            case purge: {
                this.purgeAction();
                break;
            }
            default: {
                throw new CLIToolOptionsException("Unrecognized action: " + (Object)((Object)this.action));
            }
        }
    }

    @Override
    public String getHelpString() {
        return "rd-jobs [<action>] [options...]: list or delete Jobs on the server, or upload Jobs to the server from a file\n\tList action (default):\nrd-jobs [list] [query options] : list jobs matching the query, or all available\nrd-jobs [list] --name <name> : Match jobs with the given name\nrd-jobs [list] [query options] --file <output> : Save matched Jobs to output file as XML\nrd-jobs [list] [query options] --file <output> --format <xml|yaml> : Save matched Jobs to output file as XML or YAML\n\tPurge action:\nrd-jobs purge -p <project> [query options] : Delete jobs from the project matching the options\nrd-jobs purge -p <project> --file <file> [query options] : Delete jobs from the project matching the options, after saving them to a file\n\tLoad action:\nrd-jobs load --file <file> : load jobs stored in XML file, require each to define its project\nrd-jobs load -p <project> --file <file> : load jobs stored in XML file to specific project\nrd-jobs load --file <file> -F yaml : load jobs stored in YAML file";
    }

    private void loadAction() throws JobsToolException {
        HashMap<String, ArrayList> map;
        ArrayList list;
        Collection<IStoredJobLoadResult> result;
        try {
            result = this.framework.getCentralDispatcherMgr().loadJobs(this, this.argFile, this.format);
        }
        catch (CentralDispatcherException e) {
            String msg = "Failed request to load jobs: " + e.getMessage();
            throw new JobsToolException(msg, e);
        }
        if (null == result) {
            throw new JobsToolException("Upload request returned null");
        }
        this.log("# Total Jobs Uploaded: " + result.size() + " jobs");
        ArrayList<IStoredJobLoadResult> failed = new ArrayList<IStoredJobLoadResult>();
        ArrayList<IStoredJobLoadResult> skipped = new ArrayList<IStoredJobLoadResult>();
        ArrayList<IStoredJobLoadResult> succeeded = new ArrayList<IStoredJobLoadResult>();
        for (IStoredJobLoadResult item : result) {
            if (!item.isSuccessful()) {
                failed.add(item);
                continue;
            }
            if (item.isSkippedJob()) {
                skipped.add(item);
                continue;
            }
            succeeded.add(item);
        }
        if (failed.size() > 0) {
            this.log("# Failed to add " + failed.size() + " Jobs:");
            list = this.genJobDetailList((Collection<? extends IStoredJob>)failed);
            map = new HashMap<String, ArrayList>();
            map.put("failed", list);
            this.logYaml(map);
        }
        if (skipped.size() > 0) {
            this.log("# Skipped " + skipped.size() + " Jobs:");
            list = this.genJobDetailList((Collection<? extends IStoredJob>)skipped);
            map = new HashMap();
            map.put("skipped", list);
            this.logYaml(map);
        }
        if (succeeded.size() > 0) {
            this.log("# Succeeded creating/updating " + succeeded.size() + "  Jobs:");
            list = this.genJobDetailList((Collection<? extends IStoredJob>)succeeded);
            map = new HashMap();
            map.put("succeeded", list);
            this.logYaml(map);
        }
        if (failed.size() > 0) {
            throw new JobsToolException("Failed to load " + failed.size() + " Jobs");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listAction() throws JobsToolException {
        Collection<IStoredJob> result;
        try {
            FileOutputStream output = null != this.argFile ? new FileOutputStream(this.argFile) : null;
            try {
                result = this.framework.getCentralDispatcherMgr().listStoredJobs(this, output, this.format);
            }
            finally {
                if (null != output) {
                    output.close();
                }
            }
        }
        catch (CentralDispatcherException e) {
            String msg = "Failed request to list the queue: " + e.getMessage();
            throw new JobsToolException(msg, e);
        }
        catch (IOException e) {
            String msg = "Failed request to list the queue: " + e.getMessage();
            throw new JobsToolException(msg, e);
        }
        if (null == result) {
            throw new JobsToolException("List request returned null");
        }
        this.log("# Found " + result.size() + " jobs:");
        this.logYaml(this.genJobDetailList(result));
        if (null != this.argFile) {
            this.log("Wrote " + (Object)((Object)this.format) + " to file: " + this.argFile.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeAction() throws JobsToolException {
        HashMap<String, List<Map<String, String>>> map;
        List<Map<String, String>> list;
        Collection<DeleteJobResult> deleteresult;
        try {
            Collection<IStoredJob> result;
            FileOutputStream output = null != this.argFile ? new FileOutputStream(this.argFile) : null;
            try {
                result = this.framework.getCentralDispatcherMgr().listStoredJobs(this, output, this.format);
            }
            finally {
                if (null != output) {
                    output.close();
                }
            }
            if (null != this.argFile) {
                this.log("Wrote " + (Object)((Object)this.format) + " to file: " + this.argFile.getAbsolutePath());
            }
            ArrayList<String> jobIds = new ArrayList<String>();
            for (IStoredJob job : result) {
                jobIds.add(job.getJobId());
            }
            if (jobIds.size() == 0) {
                this.log("# Found 0 matching jobs");
                return;
            }
            if (this.argVerbose) {
                this.log("# Deleting " + result.size() + " jobs...");
            }
            deleteresult = this.framework.getCentralDispatcherMgr().deleteStoredJobs(jobIds);
        }
        catch (CentralDispatcherException e) {
            String msg = "Failed request to list the queue: " + e.getMessage();
            throw new JobsToolException(msg, e);
        }
        catch (IOException e) {
            String msg = "Failed request to list the queue: " + e.getMessage();
            throw new JobsToolException(msg, e);
        }
        ArrayList<DeleteJobResult> successful = new ArrayList<DeleteJobResult>();
        ArrayList<DeleteJobResult> failed = new ArrayList<DeleteJobResult>();
        for (DeleteJobResult jobResult : deleteresult) {
            if (!jobResult.isSuccessful()) {
                failed.add(jobResult);
                continue;
            }
            successful.add(jobResult);
        }
        if (successful.size() > 0) {
            this.log("# Deleted " + successful.size() + " Jobs:");
            list = this.genJobDetailList((List<DeleteJobResult>)successful);
            map = new HashMap<String, List<Map<String, String>>>();
            map.put("deleted", list);
            this.logYaml(map);
        }
        if (failed.size() > 0) {
            this.log("# Failed to delete " + failed.size() + " Jobs:");
            list = this.genJobDetailList((List<DeleteJobResult>)failed);
            map = new HashMap();
            map.put("failed", list);
            this.logYaml(map);
            throw new JobsToolException("Failed to delete " + failed.size() + " jobs");
        }
    }

    private List<Map<String, String>> genJobDetailList(List<DeleteJobResult> result) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        for (DeleteJobResult item : result) {
            list.add(this.genJobDetail(item));
        }
        return list;
    }

    private Map<String, String> genJobDetail(DeleteJobResult item) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", item.getId());
        if (null != item.getMessage()) {
            map.put("message", item.getMessage());
        }
        if (null != item.getErrorCode()) {
            map.put("errorCode", item.getErrorCode());
        }
        return map;
    }

    private void logYaml(Object list) {
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Yaml yaml = new Yaml(dumperOptions);
        this.log(yaml.dump(list));
    }

    private ArrayList genJobDetailList(Collection<? extends IStoredJob> result) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (IStoredJob iStoredJob : result) {
            list.add(this.genJobDetail(iStoredJob));
        }
        return list;
    }

    private Object genJobDetail(IStoredJob item) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.isArgVerbose()) {
            IStoredJobLoadResult load;
            map.put(NAME_OPTION_LONG, item.getName());
            if (null != item.getDescription() && !"".equals(item.getDescription())) {
                map.put("description", item.getDescription());
            }
            if (item instanceof IStoredJobLoadResult && null != (load = (IStoredJobLoadResult)item).getMessage()) {
                map.put("message", load.getMessage());
            }
            if (null != item.getGroup()) {
                map.put(GROUP_OPTION_LONG, item.getGroup());
            }
            if (null != item.getJobId()) {
                map.put("id", item.getJobId());
            }
            if (null != item.getUrl()) {
                map.put("url", item.getUrl());
            }
            if (null != item.getProject()) {
                map.put(PROJECT_OPTION_LONG, item.getProject());
            }
        } else {
            IStoredJobLoadResult load;
            String ident = (null != item.getGroup() ? item.getGroup() + "/" : "") + item.getName();
            if (item instanceof IStoredJobLoadResult && !(load = (IStoredJobLoadResult)item).isSuccessful()) {
                map.put("job", ident);
                if (null != load.getMessage()) {
                    map.put("reason", load.getMessage());
                }
                return map;
            }
            String desc = null != item.getDescription() && !"".equals(item.getDescription()) ? " - '" + item.getDescription() + "'" : "";
            return ident + desc;
        }
        return map;
    }

    @Override
    public void log(String output) {
        if (null != this.clilogger) {
            this.clilogger.log(output);
        }
    }

    @Override
    public void error(String output) {
        if (null != this.clilogger) {
            this.clilogger.error(output);
        }
    }

    @Override
    public void warn(String output) {
        if (null != this.clilogger) {
            this.clilogger.warn(output);
        }
    }

    @Override
    public void verbose(String message) {
        if (null != this.clilogger) {
            this.clilogger.verbose(message);
        }
    }

    @Override
    public void debug(String message) {
        if (null != this.clilogger) {
            this.clilogger.debug(message);
        }
    }

    private class PurgeOptions
    implements CLIToolOptions {
        private PurgeOptions() {
        }

        @Override
        public void addOptions(Options options) {
        }

        @Override
        public void parseArgs(CommandLine cli, String[] original) throws CLIToolOptionsException {
        }

        @Override
        public void validate(CommandLine cli, String[] original) throws CLIToolOptionsException {
            if (Actions.purge == JobsTool.this.action) {
                if (null == JobsTool.this.argProject) {
                    if (JobsTool.this.internalResolver.hasSingleProject()) {
                        JobsTool.this.argProject = JobsTool.this.internalResolver.getSingleProjectName();
                        JobsTool.this.debug("# No project specified, defaulting to: " + JobsTool.this.argProject);
                    } else {
                        throw new CLIToolOptionsException("purge action: -p/--project option is required");
                    }
                }
                if (null == JobsTool.this.argGroup && null == JobsTool.this.argIdlist && null == JobsTool.this.argName) {
                    throw new CLIToolOptionsException("purge action: Some filter option is required");
                }
            }
        }
    }

    private class ListOptions
    implements CLIToolOptions {
        private ListOptions() {
        }

        @Override
        public void addOptions(Options options) {
            options.addOption(JobsTool.NAME_OPTION, JobsTool.NAME_OPTION_LONG, true, "Job Name. List jobs matching this name. (list/purge action)");
            options.addOption(JobsTool.GROUP_OPTION, JobsTool.GROUP_OPTION_LONG, true, "Group name. List jobs within this group or sub-group (list/purge action)");
            options.addOption(JobsTool.IDLIST_OPTION, JobsTool.IDLIST_OPTION_LONG, true, "Job ID List. List Jobs with these IDs explicitly. Comma-separated, e.g.: 1,2,3. (list/purge action)");
        }

        @Override
        public void parseArgs(CommandLine cli, String[] original) throws CLIToolOptionsException {
            if (cli.hasOption(JobsTool.NAME_OPTION)) {
                JobsTool.this.argName = cli.getOptionValue(JobsTool.NAME_OPTION);
            }
            if (cli.hasOption(JobsTool.GROUP_OPTION)) {
                JobsTool.this.argGroup = cli.getOptionValue(JobsTool.GROUP_OPTION);
            }
            if (cli.hasOption(JobsTool.IDLIST_OPTION)) {
                JobsTool.this.argIdlist = cli.getOptionValue(JobsTool.IDLIST_OPTION);
            }
            if (cli.hasOption(JobsTool.PROJECT_OPTION)) {
                JobsTool.this.argProject = cli.getOptionValue(JobsTool.PROJECT_OPTION);
            }
        }

        @Override
        public void validate(CommandLine cli, String[] original) throws CLIToolOptionsException {
            if (Actions.list == JobsTool.this.action && null == JobsTool.this.argProject) {
                if (JobsTool.this.internalResolver.hasSingleProject()) {
                    JobsTool.this.argProject = JobsTool.this.internalResolver.getSingleProjectName();
                    JobsTool.this.debug("# No project specified, defaulting to: " + JobsTool.this.argProject);
                } else {
                    throw new CLIToolOptionsException("list action: -p/--project option is required");
                }
            }
        }
    }

    private class LoadOptions
    implements CLIToolOptions {
        private LoadOptions() {
        }

        @Override
        public void addOptions(Options options) {
            options.addOption(JobsTool.DUPLICATE_OPTION, JobsTool.DUPLICATE_OPTION_LONG, true, "Duplicate job behavior option. When loading jobs, treat definitions that already exist on the server in the given manner: 'update' existing jobs,'skip' the uploaded definitions, or 'create' them anyway. (load action. default: update)");
        }

        @Override
        public void parseArgs(CommandLine cli, String[] original) throws CLIToolOptionsException {
            if (cli.hasOption(JobsTool.DUPLICATE_OPTION)) {
                String dupeopt = cli.getOptionValue(JobsTool.DUPLICATE_OPTION);
                try {
                    JobsTool.this.duplicateOption = StoredJobsRequestDuplicateOption.valueOf(dupeopt);
                }
                catch (IllegalArgumentException e) {
                    throw new CLIToolOptionsException("Illegal value for --duplicate: '" + dupeopt + "', must be one of: " + Arrays.toString((Object[])StoredJobsRequestDuplicateOption.values()));
                }
            }
        }

        @Override
        public void validate(CommandLine cli, String[] original) throws CLIToolOptionsException {
            if (Actions.load == JobsTool.this.action) {
                if (null != JobsTool.this.argName) {
                    JobsTool.this.warn("load action: -n/--name option only valid with list action");
                }
                if (null != JobsTool.this.argGroup) {
                    JobsTool.this.warn("load action: -g/--group option only valid with list action");
                }
                if (null != JobsTool.this.argIdlist) {
                    JobsTool.this.warn("load action: -i/--idlist option only valid with list action");
                }
                if (null == JobsTool.this.argFile) {
                    throw new CLIToolOptionsException("load action: -f/--file option is required");
                }
                if (null != JobsTool.this.argFile && !JobsTool.this.argFile.exists()) {
                    throw new CLIToolOptionsException("load action: -f/--file option: File does not exist: " + JobsTool.this.argFile.getAbsolutePath());
                }
            }
        }
    }

    private class CommonOptions
    implements CLIToolOptions {
        private CommonOptions() {
        }

        @Override
        public void addOptions(Options options) {
            options.addOption(JobsTool.FILE_OPTION, JobsTool.FILE_OPTION_LONG, true, "File path. For list action, path to store the job definitions found in XML.  For load action, path to an XML file to upload.");
            options.addOption(JobsTool.VERBOSE_OPTION, JobsTool.VERBOSE_OPTION_LONG, false, "Enable verbose output");
            options.addOption(JobsTool.FORMAT_OPTION, JobsTool.FORMAT_OPTION_LONG, true, "Format for input/output file. One of: " + Arrays.toString((Object[])JobDefinitionFileFormat.values()));
            options.addOption(JobsTool.PROJECT_OPTION, JobsTool.PROJECT_OPTION_LONG, true, "Project name. List jobs within this project, or import jobs to this project.");
        }

        @Override
        public void parseArgs(CommandLine cli, String[] original) throws CLIToolOptionsException {
            if (cli.hasOption(JobsTool.VERBOSE_OPTION)) {
                JobsTool.this.argVerbose = true;
            }
            if (cli.hasOption(JobsTool.FILE_OPTION)) {
                JobsTool.this.argFile = new File(cli.getOptionValue(JobsTool.FILE_OPTION));
            }
            if (cli.hasOption(JobsTool.FORMAT_OPTION)) {
                try {
                    JobsTool.this.format = JobDefinitionFileFormat.valueOf(cli.getOptionValue(JobsTool.FORMAT_OPTION));
                }
                catch (IllegalArgumentException e) {
                    throw new CLIToolOptionsException("Invalid format: " + cli.getOptionValue(JobsTool.FORMAT_OPTION) + ", must be one of: " + Arrays.toString((Object[])JobDefinitionFileFormat.values()));
                }
            }
        }

        @Override
        public void validate(CommandLine cli, String[] original) throws CLIToolOptionsException {
        }
    }

    public static enum Actions {
        list("list"),
        load("load"),
        purge("purge");

        private String name;

        private Actions(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

